/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.messaging.SystemRepositoryTrustMessageConsumer;
import de.willuhn.jameica.services.UpdateService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;

public class OnlineUpdates
extends AbstractBox {
    private static final I18N i18n = Application.getI18n();
    private static final Settings settings = new Settings(OnlineUpdates.class);
    private SystemRepositoryTrustMessageConsumer mc = new SystemRepositoryTrustMessageConsumer();

    @Override
    public String getName() {
        return "Jameica: " + Application.getI18n().tr("Online-Updates");
    }

    @Override
    public boolean isActive() {
        return this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        UpdateService service = (UpdateService)Application.getBootLoader().getBootable(UpdateService.class);
        return settings.getString("displayed", null) == null && !service.getUpdateCheck();
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public int getDefaultIndex() {
        return 0;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        InfoPanel panel = new InfoPanel();
        panel.setIcon("dialog-question-large.png");
        panel.setTitle(i18n.tr("Online-Updates f\u00fcr Plugins aktivieren?"));
        panel.setText(i18n.tr("Soll Jameica regelm\u00e4\u00dfig nach Online-Updates zu den installierten Plugins suchen?\nBei der Aktivierung werden ggf. Informationen zum SSL-Zertifikat des Server angezeigt."));
        panel.setComment(i18n.tr("Sie k\u00f6nnen diese Einstellungen jederzeit in \"Datei\u00bbEinstellungen\u00bbUpdates\" \u00e4ndern."));
        Button button = new Button(i18n.tr("Online-Updates aktivieren"), new UpdateState(), Boolean.TRUE, false, "ok.png");
        panel.addButton(button);
        button = new Button(i18n.tr("Online-Updates nicht verwenden"), new UpdateState(), Boolean.FALSE, false, "process-stop.png");
        panel.addButton(button);
        panel.addButton(new Button(i18n.tr("Einstellungen..."), new de.willuhn.jameica.gui.internal.action.Settings(), i18n.tr("Updates"), false, "document-properties.png"));
        panel.paint(parent);
    }

    private class UpdateState
    implements Action {
        private UpdateState() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            boolean b = (Boolean)context;
            if (b) {
                OnlineUpdates.this.mc.performTrust();
            }
            UpdateService service = (UpdateService)Application.getBootLoader().getBootable(UpdateService.class);
            service.setUpdateCheck(b);
            settings.setAttribute("displayed", DateUtil.DEFAULT_FORMAT.format(new Date()));
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(b ? i18n.tr("Online-Updates aktiviert") : i18n.tr("Online-Updates deaktiviert"), b ? 0 : 2));
            GUI.getCurrentView().reload();
        }
    }
}

