/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BoxRegistry {
    private static Settings settings = new Settings(Box.class);
    private static Class<Box>[] boxes = null;

    public static synchronized List<Box> getBoxes() {
        LinkedList<Box> instances = new LinkedList<Box>();
        if (boxes == null) {
            ClassFinder finder = Application.getClassLoader().getClassFinder();
            try {
                boxes = finder.findImplementors(Box.class);
                if (boxes == null || boxes.length == 0) {
                    throw new ClassNotFoundException();
                }
            }
            catch (ClassNotFoundException ce) {
                Logger.warn((String)"no boxes found, jameica welcome page will be empty");
                boxes = new Class[0];
            }
        }
        BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        for (Class<Box> c : boxes) {
            try {
                instances.add(beanService.get(c));
            }
            catch (Exception e) {
                Logger.error((String)("unable to load box " + c.getName() + ", skipping"), (Throwable)e);
            }
        }
        Collections.sort(instances);
        for (int i = 0; i < instances.size(); ++i) {
            ((Box)instances.get(i)).setIndex(i);
        }
        return instances;
    }

    public static int getHeight(Box box) {
        if (box == null) {
            return -1;
        }
        int i = settings.getInt(box.getClass().getName() + ".height", box.getHeight());
        return i > 0 ? i : -1;
    }

    public static void setHeight(Box box, int height) {
        if (box == null) {
            return;
        }
        if (height < 0) {
            settings.setAttribute(box.getClass().getName() + ".height", null);
        } else {
            settings.setAttribute(box.getClass().getName() + ".height", height);
        }
    }
}

