/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.services.BackupService;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BackupInfos
extends AbstractBox {
    private static final I18N i18n = Application.getI18n();

    @Override
    public String getName() {
        return "Jameica: " + Application.getI18n().tr("Backup-Informationen");
    }

    @Override
    public int getHeight() {
        return 300;
    }

    @Override
    public boolean isActive() {
        return !this.getErrors().isEmpty();
    }

    private List<String> getErrors() {
        BackupService service = (BackupService)Application.getBootLoader().getBootable(BackupService.class);
        return service.getLastErrors();
    }

    @Override
    public boolean getDefaultEnabled() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public int getDefaultIndex() {
        return 0;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        InfoPanel panel = new InfoPanel(){

            @Override
            public Composite extend(InfoPanel.DrawState state, Composite comp, Object context) {
                if (state != InfoPanel.DrawState.TEXT_AFTER) {
                    return comp;
                }
                TablePart table = new TablePart(BackupInfos.this.getErrors(), null);
                table.setMulti(false);
                table.setRememberColWidths(true);
                table.setRememberOrder(true);
                table.setRememberState(true);
                table.removeFeature(FeatureSummary.class);
                table.addColumn(i18n.tr("Fehlermeldung"), null);
                Composite myComp = new Composite(comp, 0);
                myComp.setLayout((Layout)SWTUtil.createGrid(1, false));
                GridData gd = new GridData(768);
                gd.heightHint = 150;
                myComp.setLayoutData((Object)gd);
                SimpleContainer c = new SimpleContainer(myComp, true);
                c.addPart(table);
                return comp;
            }
        };
        panel.setTitle(i18n.tr(i18n.tr("Hinweis zum letzten Backup")));
        panel.setIcon("dialog-information-large.png");
        panel.setText(i18n.tr("W\u00e4hrend der letzten Programmsitzung traten die folgenden Fehler auf, welche die automatische Erstellung des Backups beim Programmende verhinderten."));
        panel.setComment(i18n.tr("Pr\u00fcfen Sie ggf. die Logdatei auf vorhandene Fehlermeldungen."));
        panel.setUrl("https://www.willuhn.de/wiki/doku.php?id=support:fehlermelden");
        panel.paint(parent);
    }
}

