/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.internal.parts.LogoPart;
import de.willuhn.jameica.gui.internal.parts.PanelButtonBack;
import de.willuhn.jameica.gui.internal.parts.SearchPart;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.parts.TitlePart;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class View
implements Part {
    private SashForm sash;
    private Composite view;
    private ScrolledComposite scroll;
    private Composite content;
    private Composite snapin;
    private boolean snappedIn = false;
    private Composite parent;
    private SearchPart searchPart;
    private NotificationPanel notifications;
    private String title;
    private LogoPart logoPart;
    private TitlePart titlePart;

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.parent = parent;
        this.init();
    }

    private void init() {
        Composite comp;
        this.sash = new SashForm(this.parent, 512);
        this.sash.setLayoutData((Object)new GridData(1808));
        this.sash.setLayout((Layout)SWTUtil.createGrid(1, true));
        this.view = new Composite((Composite)this.sash, 2048);
        this.view.setLayoutData((Object)new GridData(1808));
        this.view.setLayout((Layout)SWTUtil.createGrid(1, true));
        this.snapin = new Composite((Composite)this.sash, 2048);
        this.snapin.setLayoutData((Object)new GridData(1808));
        this.snapin.setLayout((Layout)SWTUtil.createGrid(1, true));
        this.sash.setMaximizedControl((Control)this.view);
        if (!Customizing.SETTINGS.getBoolean("application.view.hidelogo", true)) {
            comp = new Composite(this.view, 0);
            comp.setLayout((Layout)SWTUtil.createGrid(1, false));
            comp.setLayoutData((Object)new GridData(768));
            this.logoPart = new LogoPart();
            this.logoPart.paint(comp);
        }
        if (!Customizing.SETTINGS.getBoolean("application.view.hidepanel", false)) {
            comp = new Composite(this.view, 0);
            comp.setLayout((Layout)SWTUtil.createGrid(1, false));
            comp.setLayoutData((Object)new GridData(768));
            this.titlePart = new TitlePart(this.title, false);
            this.titlePart.paint(comp);
        }
        comp = new Composite(this.view, 0);
        comp.setLayoutData((Object)new GridData(768));
        GridLayout l = new GridLayout(2, false);
        l.marginLeft = 3;
        l.marginRight = 3;
        comp.setLayout((Layout)l);
        if (!Customizing.SETTINGS.getBoolean("application.view.hidemessages", false)) {
            try {
                this.notifications = new NotificationPanel();
                this.notifications.setBackground(true);
                this.notifications.setBorder(1);
                this.notifications.setReceiveMessages(true);
                this.notifications.paint(comp);
            }
            catch (Exception e) {
                Logger.error((String)"unable to paint notification panel", (Throwable)e);
            }
        }
        if (!Customizing.SETTINGS.getBoolean("application.view.hidesearch", false)) {
            this.searchPart = new SearchPart();
            try {
                Composite comp2 = new Composite(comp, 0);
                GridData gd = new GridData(128);
                gd.widthHint = 300;
                comp2.setLayoutData((Object)gd);
                comp2.setLayout((Layout)SWTUtil.createGrid(1, false));
                this.searchPart.paint(comp2);
            }
            catch (Exception e) {
                Logger.error((String)"unable to draw search part");
            }
        }
        GUI.getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode != 0x100000E) {
                    return;
                }
                try {
                    GUI.getCurrentView().reload();
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
            }
        });
    }

    protected void cleanContent() {
        if (this.content != null && !this.content.isDisposed()) {
            this.content.dispose();
        }
        if (this.scroll != null && !this.scroll.isDisposed()) {
            this.scroll.dispose();
        }
        if (Customizing.SETTINGS.getBoolean("application.scrollview", false)) {
            this.scroll = new ScrolledComposite(this.view, 768);
            this.scroll.setLayoutData((Object)new GridData(1808));
            this.scroll.setLayout((Layout)SWTUtil.createGrid(1, true));
            this.scroll.setExpandHorizontal(true);
            this.scroll.setExpandVertical(true);
            this.scroll.setMinHeight(Customizing.SETTINGS.getInt("application.scrollview.minheight", 580));
            this.content = new Composite((Composite)this.scroll, 0);
            this.scroll.setContent((Control)this.content);
        } else {
            this.content = new Composite(this.view, 0);
        }
        this.content.setLayoutData((Object)new GridData(1808));
        GridLayout l = new GridLayout();
        l.marginHeight = 6;
        l.marginWidth = 6;
        this.content.setLayout((Layout)l);
        if (this.titlePart != null) {
            this.titlePart.clearButtons();
            this.titlePart.addButton(new PanelButtonBack());
        }
        if (this.notifications != null) {
            this.notifications.reset();
        }
        this.setTitle(null);
    }

    public void addPanelButton(PanelButton b) {
        if (this.titlePart != null) {
            this.titlePart.addButton(b);
        }
    }

    public void snapIn() {
        GUI.startSync(new Runnable(){

            @Override
            public void run() {
                View.this.sash.setMaximizedControl(null);
                int[] weights = new int[]{GUI.SETTINGS.getInt("snapin.height.0", 3), GUI.SETTINGS.getInt("snapin.height.1", 1)};
                if (weights[0] <= 0) {
                    weights[0] = 3;
                }
                if (weights[1] <= 0) {
                    weights[1] = 1;
                }
                View.this.sash.setWeights(weights);
                View.this.snappedIn = true;
            }
        });
    }

    public void snapOut() {
        GUI.startSync(new Runnable(){

            @Override
            public void run() {
                try {
                    int[] weights = View.this.sash.getWeights();
                    GUI.SETTINGS.setAttribute("snapin.height.0", weights[0]);
                    GUI.SETTINGS.setAttribute("snapin.height.1", weights[1]);
                    SWTUtil.disposeChildren(View.this.snapin);
                    View.this.sash.setMaximizedControl((Control)View.this.view);
                }
                finally {
                    View.this.snappedIn = false;
                }
            }
        });
    }

    public boolean snappedIn() {
        return this.snappedIn;
    }

    public Composite getSnapin() {
        return this.snapin;
    }

    public void setTitle(String text) {
        this.title = text;
        if (this.titlePart != null) {
            this.titlePart.setTitle(this.title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setLogoText(String text) {
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(text, 2));
    }

    public void setErrorText(String text) {
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(text, 1));
    }

    public void setSuccessText(String text) {
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(text, 0));
    }

    public NotificationPanel getNotificationPanel() {
        return this.notifications;
    }

    public SearchPart getSearchPart() {
        return this.searchPart;
    }

    public LogoPart getLogoPart() {
        return this.logoPart;
    }

    protected void refreshContent() {
        this.view.layout();
    }

    protected Composite getContent() {
        return this.content;
    }
}

