/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.StatusBarItem;
import de.willuhn.jameica.gui.internal.action.LogExport;
import de.willuhn.jameica.gui.internal.parts.LogList;
import de.willuhn.jameica.gui.parts.Panel;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class StatusBarTextItem
implements StatusBarItem {
    private Label text = null;
    private boolean snapIn = false;

    public StatusBarTextItem() {
        Application.getMessagingFactory().getMessagingQueue("jameica.statusbar").registerMessageConsumer(new StatusMessageConsumer());
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        this.text = GUI.getStyleFactory().createLabel(comp, 0);
        GridData at = new GridData(1808);
        at.verticalAlignment = 2;
        at.verticalIndent = 1;
        at.widthHint = 600;
        this.text.setAlignment(131072);
        this.text.setLayoutData((Object)at);
        this.text.setText("");
        if (!Customizing.SETTINGS.getBoolean("application.statusbar.hidelog", false)) {
            final Canvas c = new Canvas(comp, 0);
            GridData gd = new GridData(1808);
            at.verticalAlignment = 3;
            gd.widthHint = 20;
            c.setLayoutData((Object)gd);
            c.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    GC gc = event.gc;
                    Rectangle size = c.getBounds();
                    gc.drawImage(SWTUtil.getImage(StatusBarTextItem.this.snapIn ? "minimize.png" : "maximize.png"), size.width - 20, 3);
                }
            });
            MouseAdapter ma = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (GUI.getView().snappedIn()) {
                        GUI.getView().snapOut();
                    }
                    if (StatusBarTextItem.this.snapIn) {
                        StatusBarTextItem.this.snapIn = false;
                        c.redraw();
                        return;
                    }
                    try {
                        Panel panel = new Panel(Application.getI18n().tr("System-Meldungen"), new LogList(), false);
                        panel.addButton(new PanelButton("minimize.png", new Action(){

                            @Override
                            public void handleAction(Object context) throws ApplicationException {
                                if (GUI.getView().snappedIn()) {
                                    GUI.getView().snapOut();
                                }
                                StatusBarTextItem.this.snapIn = false;
                                c.redraw();
                            }
                        }, Application.getI18n().tr("Minimieren")));
                        panel.addButton(new PanelButton("document-save.png", new LogExport(), Application.getI18n().tr("Log-Ausgaben in Datei speichern")));
                        panel.paint(GUI.getView().getSnapin());
                        GUI.getView().snapIn();
                        StatusBarTextItem.this.snapIn = true;
                        c.redraw();
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"unable to display log list", (Throwable)re);
                    }
                }
            };
            String s = Application.getI18n().tr("Klicken Sie hier, um die letzten Zeilen des System-Logs anzuzeigen.");
            c.setToolTipText(s);
            c.addMouseListener((MouseListener)ma);
        }
    }

    private class StatusMessageConsumer
    implements MessageConsumer {
        private long lastClick;

        private StatusMessageConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{StatusBarMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            if (message == null) {
                return;
            }
            final StatusBarMessage m = (StatusBarMessage)message;
            final Display d = GUI.getDisplay();
            if (d == null || d.isDisposed()) {
                return;
            }
            final long currentClick = System.currentTimeMillis();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StatusBarTextItem.this.text != null && !StatusBarTextItem.this.text.isDisposed()) {
                        Color color = null;
                        switch (m.getType()) {
                            case 1: {
                                color = Color.ERROR;
                                break;
                            }
                            case 0: {
                                color = Color.SUCCESS;
                                break;
                            }
                            default: {
                                color = Color.FOREGROUND;
                            }
                        }
                        StatusBarTextItem.this.text.setForeground(color.getSWTColor());
                        StatusBarTextItem.this.text.setText(m.getText() + " ");
                        StatusBarTextItem.this.text.update();
                        StatusBarTextItem.this.text.redraw();
                        StatusMessageConsumer.this.lastClick = currentClick;
                    }
                }
            });
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    d.timerExec(10000, new Runnable(){

                        @Override
                        public void run() {
                            if (currentClick == StatusMessageConsumer.this.lastClick && !StatusBarTextItem.this.text.isDisposed()) {
                                StatusBarTextItem.this.text.setText("");
                                StatusBarTextItem.this.text.update();
                                StatusBarTextItem.this.text.redraw();
                            }
                        }
                    });
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }
}

