/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.StatusBarItem;
import de.willuhn.jameica.gui.internal.action.Appointments;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class StatusBarCalendarItem
implements StatusBarItem {
    private Label text = null;
    private DateFormat df = new SimpleDateFormat("EEEE, dd.MM.yyyy HH:mm", Application.getConfig().getLocale());

    public StatusBarCalendarItem() {
        new Worker().start();
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.text = GUI.getStyleFactory().createLabel(parent, 0);
        GridData at = new GridData(768);
        at.verticalAlignment = 2;
        at.widthHint = 210;
        at.horizontalIndent = 5;
        at.verticalIndent = 1;
        this.text.setAlignment(16384);
        this.text.setLayoutData((Object)at);
        this.text.setText(this.df.format(new Date()));
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    new Appointments().handleAction(null);
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
            }
        });
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("date watcher for statusbar calendar");
        }

        @Override
        public void run() {
            Display display;
            while ((display = GUI.getDisplay()) != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (StatusBarCalendarItem.this.text != null && !StatusBarCalendarItem.this.text.isDisposed()) {
                            StatusBarCalendarItem.this.text.setText(StatusBarCalendarItem.this.df.format(new Date()));
                        }
                    }
                });
                try {
                    Worker.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Logger.info((String)"statusbar calendar interrupted");
                    return;
                }
            }
            return;
        }
    }
}

