/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.StatusBarItem;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class StatusBar
implements Part {
    private ArrayList<StatusBarItem> items = new ArrayList();
    private Composite status;
    private StackLayout progressStack;
    private Composite progressComp;
    private ProgressBar progress;
    private ProgressBar noProgress;

    public void addItem(StatusBarItem item) {
        this.items.add(item);
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        int height = 20;
        try {
            FontData font = Font.DEFAULT.getSWTFont().getFontData()[0];
            int h = SWTUtil.pt2px(font.getHeight());
            if (h > 0) {
                height = h;
            }
        }
        catch (Throwable font) {
            // empty catch block
        }
        this.status = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.heightHint = height + 12;
        this.status.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.status.setLayout((Layout)layout);
        this.progressComp = new Composite(this.status, 0);
        GridData gd = new GridData(32);
        gd.widthHint = 60;
        gd.heightHint = height + 10;
        this.progressComp.setLayoutData((Object)gd);
        this.progressStack = new StackLayout();
        this.progressComp.setLayout((Layout)this.progressStack);
        this.progress = new ProgressBar(this.progressComp, 2);
        this.progress.setToolTipText(Application.getI18n().tr("Vorgang wird bearbeitet..."));
        this.noProgress = new ProgressBar(this.progressComp, 0);
        this.progressStack.topControl = this.noProgress;
        int size = this.items.size();
        Composite tComp = new Composite(this.status, 2048);
        tComp.setLayoutData((Object)new GridData(1808));
        GridLayout tgd = new GridLayout(2 * size - 1, false);
        tgd.marginHeight = 0;
        tgd.marginWidth = 0;
        tgd.horizontalSpacing = 0;
        tgd.verticalSpacing = 0;
        tComp.setLayout((Layout)tgd);
        for (int i = 0; i < size; ++i) {
            StatusBarItem item = this.items.get(i);
            item.paint(tComp);
            if (i >= size - 1) continue;
            Label sep = GUI.getStyleFactory().createLabel(tComp, 514);
            GridData sepgd = new GridData(1040);
            sepgd.widthHint = 5;
            sep.setLayoutData((Object)sepgd);
        }
    }

    public synchronized void startProgress() {
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (StatusBar.this.progressComp == null || StatusBar.this.progressComp.isDisposed()) {
                    return;
                }
                StatusBar.this.progressStack.topControl = StatusBar.this.progress;
                StatusBar.this.progressComp.layout();
            }
        });
    }

    public synchronized void stopProgress() {
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (StatusBar.this.progressComp == null || StatusBar.this.progressComp.isDisposed()) {
                    return;
                }
                StatusBar.this.progressStack.topControl = StatusBar.this.noProgress;
                StatusBar.this.progressComp.layout();
            }
        });
    }

    public void setSuccessText(String message) {
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(message, 0));
    }

    public void setErrorText(String message) {
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(message, 1));
    }
}

