/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Menu;
import de.willuhn.jameica.gui.Navigation;
import de.willuhn.jameica.gui.Sleak;
import de.willuhn.jameica.gui.StatusBar;
import de.willuhn.jameica.gui.StatusBarCalendarItem;
import de.willuhn.jameica.gui.StatusBarTextItem;
import de.willuhn.jameica.gui.View;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.internal.parts.BackgroundTaskMonitor;
import de.willuhn.jameica.gui.internal.parts.PanelButtonAttachment;
import de.willuhn.jameica.gui.internal.parts.PanelButtonBookmark;
import de.willuhn.jameica.gui.internal.views.FatalErrorView;
import de.willuhn.jameica.gui.parts.FormTextPart;
import de.willuhn.jameica.gui.parts.Panel;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.style.StyleFactory;
import de.willuhn.jameica.gui.style.StyleFactoryDefaultImpl;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.ApplicationCallback;
import de.willuhn.jameica.system.ApplicationCallbackSWT;
import de.willuhn.jameica.system.ApplicationController;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.JameicaException;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;

public class GUI
implements ApplicationController {
    static final Settings SETTINGS = new Settings(GUI.class);
    private static final String QUEUE_UNBIND_FAIL = "jameica.gui.view.unbind.fail";
    private static final String QUEUE_UNBIND = "jameica.gui.view.unbind";
    private static GUI gui;
    private Display display = null;
    private Shell shell = null;
    private ApplicationCallback callback = null;
    private StyleFactory styleFactory = null;
    private SashForm sash = null;
    private Navigation navi = null;
    private Menu menu = null;
    private View view = null;
    private StatusBar statusBar = null;
    private SashForm left = null;
    private Composite right = null;
    private FormTextPart help = null;
    private AbstractView currentView = null;
    private Stack<HistoryEntry> history = new Stack();
    private boolean skipHistory = false;
    private boolean stop = false;
    private BackgroundTask task = null;

    public GUI() {
        if (gui != null) {
            throw new RuntimeException("unable to start second gui");
        }
        gui = this;
    }

    @Override
    public void init() throws ApplicationException {
        try {
            Logger.info((String)"startup GUI");
            Logger.info((String)("SWT version: " + SWT.getVersion() + "/" + SWT.getPlatform()));
            Point dpi = GUI.getDisplay().getDPI();
            Logger.info((String)("Pixel density of screen (DPI): " + (Serializable)(dpi != null ? Integer.valueOf(dpi.y) : "n/a") + ", configured: " + SWTUtil.getDPI()));
            Rectangle r = GUI.getDisplay().getBounds();
            if (r.height < 800) {
                Logger.info((String)("display height smaller than 800px (" + r.width + "x" + r.width + ") - auto-activating netbook mode"));
                Customizing.SETTINGS.setAttribute("application.scrollview", true);
            } else if (Customizing.SETTINGS.getBoolean("application.scrollview.force", false)) {
                Logger.info((String)"forcing netbook mode");
                Customizing.SETTINGS.setAttribute("application.scrollview", true);
            } else if (Customizing.SETTINGS.getString("application.scrollview", null) != null) {
                Logger.info((String)("display height larger than 800px (" + r.width + "x" + r.width + ") - disable netbook mode"));
                Customizing.SETTINGS.setAttribute("application.scrollview", null);
            }
            String name = Application.getI18n().tr(Customizing.SETTINGS.getString("application.name", "Jameica {0}"), Application.getManifest().getVersion().toString());
            GUI.getShell().setData("systemshell", (Object)Boolean.TRUE);
            GUI.getShell().setLayout((Layout)SWTUtil.createGrid(1, false));
            GUI.getShell().setLayoutData((Object)new GridData(1808));
            String icon = Customizing.SETTINGS.getString("application.icon", null);
            if (icon != null) {
                this.shell.setImage(SWTUtil.getImage(icon));
            } else {
                this.shell.setImages(new Image[]{SWTUtil.getImage("hibiscus-icon-64x64.png"), SWTUtil.getImage("hibiscus-icon-128x128.png"), SWTUtil.getImage("hibiscus-icon-256x256.png")});
            }
            GUI.getShell().setText(name);
            Logger.info((String)"adding menu");
            try {
                this.menu = new Menu((Decorations)GUI.getShell());
            }
            catch (Exception e) {
                Logger.error((String)"error while loading menu, skipping", (Throwable)e);
            }
            this.sash = new SashForm((Composite)GUI.getShell(), 256);
            this.sash.setLayout((Layout)SWTUtil.createGrid(1, true));
            this.sash.setLayoutData((Object)new GridData(1808));
            this.left = new SashForm((Composite)this.sash, 512);
            this.left.setLayout((Layout)SWTUtil.createGrid(1, true));
            this.left.setLayoutData((Object)new GridData(1808));
            Logger.info((String)"adding navigation");
            this.navi = new Navigation();
            Panel np = new Panel(Application.getI18n().tr("Navigation"), this.navi);
            try {
                np.paint((Composite)this.left);
            }
            catch (Exception e) {
                Logger.error((String)"error while loading navigation, skipping", (Throwable)e);
            }
            this.help = new FormTextPart();
            Panel p = new Panel(Application.getI18n().tr("Hilfe"), this.help);
            p.paint((Composite)this.left);
            this.right = new Composite((Composite)this.sash, 0);
            this.right.setLayout((Layout)SWTUtil.createGrid(1, true));
            this.right.setLayoutData((Object)new GridData(1808));
            Logger.info((String)"adding content view");
            this.view = new View();
            this.view.paint(this.right);
            this.left.setWeights(new int[]{SETTINGS.getInt("navi.height.0", 8), SETTINGS.getInt("navi.height.1", 5)});
            this.left.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GUI.this.left == null || GUI.this.left.isDisposed()) {
                        return;
                    }
                    int[] i = GUI.this.left.getWeights();
                    SETTINGS.setAttribute("navi.height.0", i[0]);
                    SETTINGS.setAttribute("navi.height.1", i[1]);
                }
            });
            this.sash.setWeights(new int[]{SETTINGS.getInt("main.width.0", 1), SETTINGS.getInt("main.width.1", 3)});
            this.sash.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (GUI.this.sash == null || GUI.this.sash.isDisposed()) {
                        return;
                    }
                    int[] i = GUI.this.sash.getWeights();
                    SETTINGS.setAttribute("main.width.0", i[0]);
                    SETTINGS.setAttribute("main.width.1", i[1]);
                }
            });
            GUI.toggleNavigation();
            Logger.info((String)"adding status panel");
            Composite bottom = new Composite((Composite)GUI.getShell(), 0);
            bottom.setLayout((Layout)SWTUtil.createGrid(1, true));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            bottom.setLayoutData((Object)gd);
            this.statusBar = new StatusBar();
            if (!Customizing.SETTINGS.getBoolean("application.statusbar.hidecalendar", false)) {
                this.statusBar.addItem(new StatusBarCalendarItem());
            }
            this.statusBar.addItem(new StatusBarTextItem());
            this.statusBar.paint(bottom);
            List<Manifest> list = Application.getPluginLoader().getInstalledManifests();
            for (int i = 0; i < list.size(); ++i) {
                Manifest mf = list.get(i);
                if (!mf.isInstalled()) {
                    Logger.info((String)("plugin " + mf.getName() + " is not installed, skipping"));
                    continue;
                }
                try {
                    this.menu.add(mf.getMenu());
                    this.navi.add(mf.getNavigation());
                    continue;
                }
                catch (Throwable t) {
                    Logger.error((String)"error while loading navigation for plugin", (Throwable)t);
                }
            }
            this.position();
            GUI.getNavigation().expand();
            Logger.info((String)"open shell");
            GUI.getShell().open();
            Application.getMessagingFactory().sendSyncMessage(new SystemMessage(1, Application.getI18n().tr("{0} erfolgreich gestartet", name)));
            this.loop();
        }
        catch (Exception e) {
            Logger.error((String)"unable to load GUI", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Starten der Benutzeroberfl\u00e4che"));
        }
    }

    private void position() {
        int x = SETTINGS.getInt("window.x", -1);
        int y = SETTINGS.getInt("window.y", -1);
        int width = SETTINGS.getInt("window.width", 1000);
        int height = SETTINGS.getInt("window.height", 780);
        Logger.info((String)("window position: " + x + "x" + y + ", size: " + width + "x" + height));
        GUI.getShell().setSize(width, height);
        if (x >= 0 && y >= 0) {
            Rectangle rect = GUI.getDisplay().getClientArea();
            if (x < rect.width && y < rect.height) {
                GUI.getShell().setLocation(x, y);
            }
        }
        if (SETTINGS.getBoolean("window.maximized", false)) {
            Logger.info((String)"window size: maximized");
            GUI.getShell().setMaximized(true);
        }
        GUI.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    Shell shell = (Shell)e.widget;
                    boolean maximized = shell.getMaximized();
                    Point size = shell.getSize();
                    Point loc = shell.toDisplay(0, 0);
                    Logger.info((String)("saving window maximized flag: " + maximized));
                    SETTINGS.setAttribute("window.maximized", maximized);
                    if (!maximized && size.x >= 0 && size.y >= 0) {
                        Logger.info((String)("saving window size: " + size.x + "x" + size.y));
                        SETTINGS.setAttribute("window.width", size.x);
                        SETTINGS.setAttribute("window.height", size.y);
                    }
                    if (!maximized && loc.x >= 0 && loc.y >= 0) {
                        Logger.info((String)("saving window location: " + loc.x + "x" + loc.y));
                        SETTINGS.setAttribute("window.x", loc.x);
                        SETTINGS.setAttribute("window.y", loc.y);
                    }
                }
                catch (Throwable t) {
                    Logger.error((String)"error while saving window position/size", (Throwable)t);
                }
            }
        });
    }

    public static boolean hasPreviousView() {
        return gui != null && GUI.gui.history != null && GUI.gui.history.size() > 0;
    }

    public static void startPreviousView() {
        if (gui == null || GUI.gui.history == null || GUI.gui.history.size() == 0) {
            Logger.debug((String)"unable to start previous view. you are already at the first page in this session ;)");
            return;
        }
        final HistoryEntry entry = GUI.gui.history.pop();
        if (entry == null) {
            return;
        }
        GUI.gui.skipHistory = true;
        MessageConsumer mc = new MessageConsumer(){

            @Override
            public void handleMessage(Message message) throws Exception {
                Logger.info((String)"unbind() failed while trying to start previous view, restoring history entry");
                GUI.gui.history.push(entry);
            }

            @Override
            public Class[] getExpectedMessageTypes() {
                return new Class[]{QueryMessage.class};
            }

            @Override
            public boolean autoRegister() {
                return false;
            }
        };
        MessagingQueue queue = Application.getMessagingFactory().getMessagingQueue(QUEUE_UNBIND_FAIL);
        try {
            queue.registerMessageConsumer(mc);
            GUI.startView(entry.view.getClass(), entry.view.getCurrentObject());
        }
        finally {
            queue.unRegisterMessageConsumer(mc);
        }
    }

    public static AbstractView getCurrentView() {
        return GUI.gui.currentView;
    }

    public static Navigation getNavigation() {
        return GUI.gui.navi;
    }

    public static Menu getMenu() {
        return GUI.gui.menu;
    }

    public static void startView(Class clazz, Object o) {
        if (clazz == null) {
            Logger.error((String)"no view class given");
            return;
        }
        try {
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            GUI.startView((AbstractView)beanService.get(clazz), o);
        }
        catch (Throwable t) {
            if (clazz.equals(FatalErrorView.class)) {
                Logger.error((String)"error loop detected");
                throw new RuntimeException("unable to display error view");
            }
            Logger.error((String)("error while loading view " + clazz.getName()), (Throwable)t);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen der View"), 1));
            GUI.gui.skipHistory = true;
            GUI.startView(FatalErrorView.class, (Object)t);
        }
    }

    public static void startView(String className, Object o) {
        if (className == null || className.length() == 0) {
            Logger.error((String)"no view class given");
            return;
        }
        try {
            GUI.startView(Application.getClassLoader().load(className), o);
        }
        catch (Throwable t) {
            Logger.error((String)("error while loading view " + className), (Throwable)t);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen der View"), 1));
            GUI.gui.skipHistory = true;
            GUI.startView(FatalErrorView.class, (Object)t);
        }
    }

    public static void startView(final AbstractView view, final Object o) {
        if (view == null) {
            Logger.error((String)"no view given");
            return;
        }
        Logger.debug((String)("starting view: " + view.getClass().getName()));
        GUI.startSync(new Runnable(){

            @Override
            public void run() {
                PanelButton button;
                if (GUI.gui.currentView != null) {
                    try {
                        Application.getMessagingFactory().getMessagingQueue(GUI.QUEUE_UNBIND).sendSyncMessage(new QueryMessage(GUI.gui.currentView));
                        GUI.gui.currentView.unbind();
                        Logger.debug((String)"disposing previous view");
                        SWTUtil.disposeChildren(GUI.gui.view.getContent());
                        Logger.debug((String)"dispose finished");
                    }
                    catch (OperationCanceledException oce) {
                        Logger.debug((String)"unbind() cancelled");
                        return;
                    }
                    catch (ApplicationException e) {
                        Logger.debug((String)("message from unbind: " + e.getMessage()));
                        QueryMessage msg = new QueryMessage(e.getMessage(), GUI.gui.currentView);
                        Application.getMessagingFactory().getMessagingQueue(GUI.QUEUE_UNBIND_FAIL).sendSyncMessage(msg);
                        Object response = msg.getData();
                        if (response instanceof Boolean && ((Boolean)response).booleanValue()) {
                            Logger.debug((String)"already handled by messaging");
                            return;
                        }
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
                        return;
                    }
                    catch (Throwable t) {
                        Logger.error((String)"error while unbind current view", (Throwable)t);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Beenden des aktuellen Dialogs"), 1));
                    }
                    if (!GUI.gui.skipHistory && GUI.gui.currentView != null) {
                        boolean same = false;
                        try {
                            same = BeanUtil.equals((Object)GUI.gui.currentView.getCurrentObject(), (Object)o);
                        }
                        catch (Exception e) {
                            Logger.write((Level)Level.TRACE, (String)"unable to compare objects", (Throwable)e);
                        }
                        if (!same || !GUI.gui.currentView.getClass().getName().equals(view.getClass().getName())) {
                            HistoryEntry entry = new HistoryEntry(GUI.gui.currentView);
                            GUI.gui.history.push(entry);
                            Logger.debug((String)("adding view " + GUI.gui.currentView.getClass().getName() + " to history"));
                            if (GUI.gui.history.size() > 10) {
                                GUI.gui.history.remove(0);
                            }
                        } else {
                            Logger.debug((String)"gui view reload detected, skipping history entry");
                        }
                    }
                    GUI.gui.skipHistory = false;
                }
                GUI.gui.view.cleanContent();
                Composite parent = GUI.gui.view.getContent();
                GUI.gui.currentView = view;
                GUI.gui.currentView.setParent(parent);
                GUI.gui.currentView.setCurrentObject(o);
                if (GUI.gui.currentView.canBookmark()) {
                    button = new PanelButtonBookmark();
                    GUI.gui.view.addPanelButton(button);
                }
                if (GUI.gui.currentView.canAttach()) {
                    button = new PanelButtonAttachment();
                    GUI.gui.view.addPanelButton(button);
                }
                parent.setFocus();
                try {
                    Application.getMessagingFactory().getMessagingQueue("jameica.gui.view.bind").sendSyncMessage(new QueryMessage(GUI.gui.currentView));
                    GUI.gui.currentView.bind();
                    if (GUI.gui.currentView instanceof Extendable) {
                        try {
                            ExtensionRegistry.extend((Extendable)((Object)GUI.gui.currentView));
                        }
                        catch (Exception e) {
                            Logger.error((String)("error while extending view " + GUI.gui.currentView.getClass().getName()));
                        }
                    }
                    GUI.loadHelp(GUI.gui.currentView);
                }
                catch (JameicaException je) {
                    try {
                        Application.getCallback().notifyUser(je.getMessage());
                    }
                    catch (Exception e) {
                        Logger.error((String)je.getMessage());
                        Logger.error((String)"additional: ", (Throwable)e);
                    }
                }
                catch (ApplicationException ae) {
                    try {
                        Application.getCallback().notifyUser(ae.getMessage());
                    }
                    catch (Exception e) {
                        Logger.error((String)ae.getMessage());
                        Logger.error((String)"additional: ", (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Throwable current = t;
                    for (int i = 0; i < 10 && current != null; current = current.getCause(), ++i) {
                        if (!(current instanceof OperationCanceledException)) continue;
                        String text = current.getMessage();
                        if (text != null) {
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(text, 1));
                        }
                        GUI.startPreviousView();
                        return;
                    }
                    Logger.error((String)("error while loading view " + view.getClass().getName()), (Throwable)t);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim \u00d6ffnen des Dialogs"), 1));
                    GUI.gui.skipHistory = true;
                    GUI.startView(FatalErrorView.class, (Object)t);
                }
                GUI.gui.view.refreshContent();
            }
        });
    }

    public static void loadHelp(AbstractView view) {
        String path = "help/" + Application.getConfig().getLocale().toString().toLowerCase() + "/" + view.getClass().getName() + ".txt";
        InputStream is = Application.getClassLoader().getResourceAsStream(path);
        if (is == null) {
            path = "help/" + Locale.getDefault().toString().toLowerCase() + "/" + view.getClass().getName() + ".txt";
            is = Application.getClassLoader().getResourceAsStream(path);
        }
        GUI.updateHelp(view, is);
    }

    private static void updateHelp(AbstractView view, InputStream is) {
        try {
            Reader r = null;
            String help = view.getHelp();
            if (StringUtils.trimToNull((String)help) != null) {
                r = new StringReader(help);
            }
            if (r == null && is != null) {
                try {
                    r = new InputStreamReader(is, "ISO-8859-1");
                }
                catch (Exception e) {
                    Logger.error((String)"unable to read help", (Throwable)e);
                }
            }
            if (r != null) {
                GUI.gui.help.setText(r);
                if (GUI.gui.left.getMaximizedControl() != null) {
                    GUI.gui.left.setMaximizedControl(null);
                }
            } else {
                GUI.gui.left.setMaximizedControl(GUI.gui.left.getChildren()[0]);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to display help", (Throwable)e);
        }
    }

    public static View getView() {
        return GUI.gui.view;
    }

    public static StatusBar getStatusBar() {
        return GUI.gui.statusBar;
    }

    public static StyleFactory getStyleFactory() {
        if (GUI.gui.styleFactory == null) {
            GUI.gui.styleFactory = new StyleFactoryDefaultImpl();
        }
        return GUI.gui.styleFactory;
    }

    public static void startSync(final Runnable job) {
        if (GUI.getDisplay() == null || GUI.getDisplay().isDisposed()) {
            return;
        }
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)GUI.getDisplay(), (Runnable)job);
            }
        });
    }

    private void loop() {
        int retry = 0;
        this.navi.select("jameica.start");
        while (!this.shell.isDisposed() && !this.stop && retry < 4) {
            try {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (IllegalArgumentException e) {
                StackTraceElement[] stack = e.getStackTrace();
                boolean b = Arrays.asList(stack).stream().filter(s -> Objects.equals(s.getClassName(), FormText.class.getName()) && Objects.equals(s.getMethodName(), "repaint")).findAny().isPresent();
                if (b) {
                    Logger.warn((String)"repaint error in FormText - SWT windows bug - ignoring");
                    continue;
                }
                Logger.error((String)"main loop crashed, retry", (Throwable)e);
                ++retry;
            }
            catch (OperationCanceledException e) {
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause != null && cause instanceof OperationCanceledException) continue;
                Logger.error((String)"main loop crashed, retry", (Throwable)t);
                ++retry;
            }
        }
        GUI.quit();
    }

    public static Shell getShell() {
        if (GUI.gui.shell != null && !GUI.gui.shell.isDisposed()) {
            return GUI.gui.shell;
        }
        GUI.gui.shell = new Shell(GUI.getDisplay());
        return GUI.gui.shell;
    }

    public static Display getDisplay() {
        if (GUI.gui.display != null && !GUI.gui.display.isDisposed()) {
            return GUI.gui.display;
        }
        GUI.gui.display = Display.findDisplay((Thread)Thread.currentThread());
        boolean sleak = Boolean.valueOf(System.getProperty("sleak", "false"));
        if (!sleak) {
            if (GUI.gui.display == null || GUI.gui.display.isDisposed()) {
                GUI.gui.display = Display.getCurrent();
            }
            if (GUI.gui.display == null || GUI.gui.display.isDisposed()) {
                if (GUI.gui.stop) {
                    throw new OperationCanceledException("display unavailable, shutdown in progress");
                }
                String name = Application.getI18n().tr(Customizing.SETTINGS.getString("application.name", "Jameica {0}"), Application.getManifest().getVersion().toString());
                Display.setAppName((String)name);
                GUI.gui.display = Display.getDefault();
            }
            if (GUI.gui.display == null || GUI.gui.display.isDisposed()) {
                GUI.gui.display = new Display();
            }
        } else if (GUI.gui.display == null || GUI.gui.display.isDisposed()) {
            Logger.info((String)"ENABLE SLEAK SWT MONITOR");
            DeviceData data = new DeviceData();
            data.tracking = true;
            GUI.gui.display = new Display(data);
            Sleak sm = new Sleak();
            sm.open();
        }
        GUI.gui.display.setWarnings(Logger.isLogging((Level)Level.DEBUG));
        return GUI.gui.display;
    }

    @Override
    public void shutDown() {
        GUI.gui.stop = true;
    }

    private static void quit() {
        Logger.info((String)"shutting down GUI");
        try {
            if (GUI.gui.shell != null && !GUI.gui.shell.isDisposed()) {
                GUI.gui.shell.dispose();
            }
        }
        catch (Exception e) {
            Logger.error((String)"error while disposing shell", (Throwable)e);
        }
        finally {
            GUI.gui.shell = null;
        }
        Application.shutDown();
    }

    @Override
    public ApplicationCallback getApplicationCallback() {
        if (GUI.gui.callback == null) {
            GUI.gui.callback = new ApplicationCallbackSWT();
        }
        return GUI.gui.callback;
    }

    public static void toggleNavigation() {
        boolean hide = Customizing.SETTINGS.getBoolean("application.hidenavigation", false);
        GUI.gui.sash.setMaximizedControl((Control)(hide ? GUI.gui.right : null));
    }

    @Override
    public void start(final BackgroundTask task) {
        if (GUI.getDisplay() == null || GUI.getDisplay().isDisposed()) {
            return;
        }
        if (this.task != null) {
            Logger.error((String)"there's already running a background task");
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Es wird bereits eine Hintergrund-Aufgabe ausgef\u00fchrt"), 1));
            return;
        }
        this.task = task;
        final String name = "bg-task:" + task.getClass().getSimpleName();
        final Thread t = new Thread(name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BackgroundTaskMonitor monitor = new BackgroundTaskMonitor(task);
                try {
                    Logger.info((String)("start background task: " + name));
                    GUI.getStatusBar().startProgress();
                    task.run(monitor);
                }
                catch (OperationCanceledException oce) {
                    if (monitor != null) {
                        monitor.setStatus(5);
                        monitor.setPercentComplete(100);
                        String msg = oce.getMessage();
                        monitor.setStatusText(msg != null ? msg : Application.getI18n().tr("Vorgang abgebrochen"));
                    }
                }
                catch (ApplicationException ae) {
                    if (monitor != null) {
                        monitor.setStatus(3);
                        monitor.setPercentComplete(100);
                        monitor.setStatusText(ae.getMessage());
                    }
                }
                catch (Throwable t) {
                    Logger.error((String)"error while executing background task", (Throwable)t);
                    if (monitor != null) {
                        monitor.setStatus(3);
                        monitor.setPercentComplete(100);
                    }
                }
                finally {
                    GUI.this.task = null;
                    Logger.info((String)("finished background task: " + name));
                    GUI.getStatusBar().stopProgress();
                }
            }
        };
        Runnable job = new Runnable(){

            @Override
            public void run() {
                t.start();
            }
        };
        GUI.getDisplay().asyncExec(job);
    }

    static {
        SETTINGS.setStoreWhenRead(false);
        gui = null;
    }

    private static class HistoryEntry {
        private AbstractView view;

        private HistoryEntry(AbstractView view) {
            this.view = view;
        }
    }
}

