/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.bookmark;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.BookmarkService;
import de.willuhn.jameica.gui.internal.action.BookmarkOpen;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class BookmarkSearchProvider
implements SearchProvider {
    @Resource
    private BookmarkService service;

    @Override
    public String getName() {
        return Application.getI18n().tr("Lesezeichen");
    }

    @Override
    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        List<Bookmark> list = this.service.search(search);
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        for (Bookmark b : list) {
            results.add(new MyResult(b));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private Bookmark b = null;

        private MyResult(Bookmark b) {
            this.b = b;
        }

        @Override
        public void execute() throws RemoteException, ApplicationException {
            new BookmarkOpen().handleAction(this.b);
        }

        @Override
        public String getName() {
            Object title = this.b.getTitle();
            String comment = StringUtils.trimToNull((String)this.b.getComment());
            if (comment != null) {
                title = (String)title + ": " + comment;
            }
            return title;
        }
    }
}

