/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.backup;

import de.willuhn.io.FileFinder;
import de.willuhn.io.FileUtil;
import de.willuhn.io.ZipCreator;
import de.willuhn.io.ZipExtractor;
import de.willuhn.jameica.backup.BackupFile;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.ZipFile;

public class BackupEngine {
    private static final DateFormat format = new SimpleDateFormat("yyyyMMdd__HH_mm_ss");
    private static final String PREFIX = "jameica-backup-";
    private static final String MARKER = ".restore";

    public static synchronized BackupFile[] getBackups(String dir) throws ApplicationException {
        String s = dir == null ? Application.getConfig().getBackupDir() : dir;
        FileFinder finder = new FileFinder(new File(s));
        finder.matches("^jameica-backup-.*?\\.zip$");
        Object[] found = finder.find();
        if (found == null) {
            return new BackupFile[0];
        }
        Arrays.sort(found);
        ArrayList<BackupFile> backups = new ArrayList<BackupFile>();
        for (int i = 0; i < found.length; ++i) {
            try {
                backups.add(new BackupFile((File)found[i]));
                continue;
            }
            catch (ApplicationException e) {
                Logger.error((String)("skipping invalid backup: " + ((File)found[i]).getAbsolutePath() + ": " + e.getMessage()));
            }
        }
        return backups.toArray(new BackupFile[backups.size()]);
    }

    public static synchronized void undoRestoreMark() {
        File marker = new File(Application.getConfig().getWorkDir(), MARKER);
        if (marker.exists()) {
            marker.delete();
        }
    }

    public static synchronized void markForRestore(BackupFile backup) throws ApplicationException {
        if (backup == null) {
            throw new ApplicationException(Application.getI18n().tr("Bitte w\u00e4hlen Sie das wiederherzustellende Backup aus"));
        }
        File file = backup.getFile();
        if (!file.isFile() || !file.canRead()) {
            throw new ApplicationException(Application.getI18n().tr("Datei nicht lesbar. Stellen Sie bitte sicher, dass Sie Schreibrechte f\u00fcr sie besitzen."));
        }
        Logger.warn((String)("activating backup for restore: " + file.getAbsolutePath()));
        File marker = new File(Application.getConfig().getWorkDir(), MARKER);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(marker));
            writer.write(file.getAbsolutePath());
            writer.flush();
        }
        catch (Exception e) {
            Logger.error((String)"unable to store marker file", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Aktivieren der Backup-Datei. Pr\u00fcfen Sie bitte das System-Log"));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close marker file", (Throwable)e);
                    throw new ApplicationException(Application.getI18n().tr("Fehler beim Aktivieren der Backup-Datei. Pr\u00fcfen Sie bitte das System-Log"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupFile getCurrentRestore() throws ApplicationException {
        File marker = new File(Application.getConfig().getWorkDir(), MARKER);
        if (!marker.exists() || !marker.canRead()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(marker));
            File f = new File(reader.readLine());
            if (f.canRead() && f.isFile()) {
                BackupFile backupFile = new BackupFile(f);
                return backupFile;
            }
            BackupFile backupFile = null;
            return backupFile;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to read marker file", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close marker file", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static synchronized void doRestore(ProgressMonitor monitor) throws ApplicationException {
        monitor.setStatusText("check backup");
        BackupFile backup = BackupEngine.getCurrentRestore();
        if (backup == null) {
            Logger.error((String)"SUSPEKT: no backup to restore found");
            throw new ApplicationException(Application.getI18n().tr("Wiederherzustellendes Backup nicht gefunden"));
        }
        boolean enabled = Application.getConfig().getUseBackup();
        try {
            BackupEngine.undoRestoreMark();
            if (!enabled) {
                monitor.log("temporarily activating creation of backup to make one before doing the restore");
                Application.getConfig().setUseBackup(true);
            }
            monitor.setStatusText("creating backup");
            File[] content = BackupEngine.doBackup(monitor, false);
            if (content == null || content.length == 0) {
                throw new ApplicationException(Application.getI18n().tr("Aktuelles Backup enthielt keine Daten. Wiederherstellung abgebrochen"));
            }
            String backupFile = backup.getFile().getCanonicalPath();
            for (File dir : content) {
                if (!backupFile.startsWith(dir.getCanonicalPath())) continue;
                throw new ApplicationException(Application.getI18n().tr("Wiederherzustellendes Backup befindet sich in einem Ordner, der beim Restore gel\u00f6scht werden w\u00fcrde. Wiederherstellung abgebrochen."));
            }
            monitor.setStatusText("cleanup work dir");
            for (int i = 0; i < content.length; ++i) {
                Logger.info((String)("purge " + content[i]));
                FileUtil.deleteRecursive((File)content[i]);
            }
            monitor.setStatusText("restoring backup " + backup.getFile().getAbsolutePath());
            File workdir = new File(Application.getConfig().getWorkDir());
            ZipExtractor ext = new ZipExtractor(new ZipFile(backup.getFile()));
            ext.setMonitor(monitor);
            ext.extract(workdir);
            monitor.setStatusText("restore completed");
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to restore backup", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Wiederherstellen des Backups: " + e.getMessage()));
        }
        finally {
            if (!enabled) {
                monitor.log("switching backup support off again");
                Application.getConfig().setUseBackup(false);
            }
        }
    }

    public static synchronized File[] doBackup(ProgressMonitor monitor, boolean rotate) throws ApplicationException {
        if (!Application.getConfig().getUseBackup()) {
            return null;
        }
        ZipCreator zip = null;
        Throwable error = null;
        try {
            if (BackupEngine.getCurrentRestore() != null) {
                monitor.setStatusText("restore marker found, skipping current backup");
                File[] fileArray = null;
                return fileArray;
            }
            File workdir = new File(Application.getConfig().getWorkDir());
            String filename = PREFIX + format.format(new Date()) + ".zip";
            File dir = new File(Application.getConfig().getBackupDir());
            File backup = new File(dir, filename);
            if (backup.exists()) {
                throw new ApplicationException(Application.getI18n().tr("Backup-Datei {0} existiert bereits", backup.getAbsolutePath()));
            }
            ArrayList<File> content = new ArrayList<File>();
            monitor.setStatusText("creating backup " + backup.getAbsolutePath());
            zip = new ZipCreator((OutputStream)new BufferedOutputStream(new FileOutputStream(backup)));
            zip.setMonitor(monitor);
            File[] children = workdir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isDirectory() || "updates".equals(children[i].getName()) || "plugins".equals(children[i].getName()) || "lost+found".equals(children[i].getName()) || children[i].getCanonicalFile().equals(dir.getCanonicalFile())) continue;
                zip.add(children[i]);
                content.add(children[i]);
            }
            zip.close();
            zip = null;
            if (rotate) {
                int maxCount = Application.getConfig().getBackupCount();
                BackupFile[] old = BackupEngine.getBackups(Application.getConfig().getBackupDir());
                Object[] toDelete = new File[old.length];
                for (int i = 0; i < old.length; ++i) {
                    toDelete[i] = old[i].getFile();
                }
                Arrays.sort(toDelete);
                int pos = 0;
                while (toDelete.length - pos > maxCount) {
                    Object current = toDelete[pos];
                    monitor.setStatusText("delete old backup " + ((File)current).getAbsolutePath());
                    ((File)current).delete();
                    ++pos;
                    ++pos;
                }
            }
            monitor.setStatusText("backup created");
            File[] fileArray = content.toArray(new File[content.size()]);
            return fileArray;
        }
        catch (ApplicationException ae) {
            error = ae;
            throw ae;
        }
        catch (Exception e) {
            error = e;
            Logger.error((String)"unable to create backup", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Erstellen des Backups: " + e.getMessage()));
        }
        finally {
            block21: {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Exception e) {
                        if (error != null) break block21;
                        Logger.error((String)"unable to close backup", (Throwable)e);
                        throw new ApplicationException(Application.getI18n().tr("Fehler beim Erstellen des Backups: " + e.getMessage()));
                    }
                }
            }
        }
    }
}

