/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.attachment.storage;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.attachment.Context;
import de.willuhn.jameica.attachment.storage.StorageProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class StorageProviderLocal
implements StorageProvider {
    private static final I18N i18n = Application.getI18n();
    private static final Settings settings = new Settings(StorageProviderLocal.class);

    @Override
    public String getId() {
        return "jameica.local";
    }

    @Override
    public boolean isEnabled() {
        return settings.getBoolean("enabled", true);
    }

    @Override
    public String getName() {
        return i18n.tr("Speicherung in lokalen Dateien");
    }

    @Override
    public List<Attachment> getAttachments(Context ctx) throws IOException {
        LinkedList<Attachment> result = new LinkedList<Attachment>();
        if (ctx == null) {
            return result;
        }
        File dir = this.getDir(ctx);
        for (File f : dir.listFiles()) {
            if (!f.isFile() || !f.canRead()) continue;
            Attachment a = new Attachment();
            a.setStorageId(this.getId());
            a.setDate(f.lastModified());
            a.setContext(ctx);
            a.setFilename(f.getName());
            result.add(a);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Attachment a, InputStream is) throws IOException {
        File dir = this.getDir(a.getContext());
        File target = new File(dir, a.getFilename());
        Logger.info((String)("creating new attachment file " + target));
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(target));
            long bytes = IOUtil.copy((InputStream)is, (OutputStream)os);
            Logger.info((String)("wrote " + bytes + " bytes"));
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is, os});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is, os});
    }

    @Override
    public void update(Attachment a, InputStream is) throws IOException {
        this.create(a, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(Attachment a, OutputStream os) throws IOException {
        File dir = this.getDir(a.getContext());
        File src = new File(dir, a.getFilename());
        Logger.info((String)("read attachment file " + src));
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(src));
            long bytes = IOUtil.copy((InputStream)is, (OutputStream)os);
            Logger.info((String)("read " + bytes + " bytes"));
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is, os});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is, os});
    }

    @Override
    public void delete(Attachment a) throws IOException {
        File dir = this.getDir(a.getContext());
        File target = new File(dir, a.getFilename());
        Logger.info((String)("delete attachment file " + target));
        if (!target.delete()) {
            throw new IOException(i18n.tr("Datei {0} kann nicht gel\u00f6scht werden", target.getAbsolutePath()));
        }
    }

    private File getDir(Context ctx) throws IOException {
        File basedir = this.getBaseDir();
        File dir = new File(basedir.getAbsolutePath() + File.separator + StringUtils.defaultIfBlank((String)ctx.getPlugin(), (String)"default") + File.separator + StringUtils.defaultIfBlank((String)ctx.getClassName(), (String)"default"), StringUtils.defaultIfBlank((String)ctx.getId(), (String)"default"));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(i18n.tr("Ordner {0} kann nicht erstellt werden", dir.getAbsolutePath()));
        }
        return dir;
    }

    public File getBaseDir() {
        File def = this.getDefaultBaseDir();
        if (!this.useCustomBaseDir()) {
            return def;
        }
        String basedir = settings.getString("basedir", null);
        return basedir != null ? new File(basedir) : def;
    }

    public File getDefaultBaseDir() {
        return new File(Application.getConfig().getWorkDir() + File.separator + "attachments");
    }

    public String getCustomBaseDir() {
        return settings.getString("basedir", null);
    }

    public void setCustomBaseDir(String dir) {
        settings.setAttribute("basedir", dir);
    }

    public boolean useCustomBaseDir() {
        return settings.getBoolean("basedir.custom", false);
    }

    public void useCustomBaseDir(boolean b) {
        settings.setAttribute("basedir.custom", b);
    }
}

