/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.value;

import org.h14199.message.DbException;
import org.h14199.util.geometry.EWKTUtils;
import org.h14199.value.ExtTypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueGeometry;

public final class ExtTypeInfoGeometry
extends ExtTypeInfo {
    private final int type;
    private final Integer srid;

    private static String toSQL(int n, Integer n2) {
        if (n == 0 && n2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (n == 0) {
            stringBuilder.append("GEOMETRY");
        } else {
            stringBuilder.append(EWKTUtils.formatGeometryTypeAndDimensionSystem(n));
        }
        if (n2 != null) {
            stringBuilder.append(", ").append(n2);
        }
        return stringBuilder.append(')').toString();
    }

    public ExtTypeInfoGeometry(int n, Integer n2) {
        this.type = n;
        this.srid = n2;
    }

    @Override
    public Value cast(Value value) {
        if (value.getValueType() != 22) {
            value = value.convertTo(22);
        }
        ValueGeometry valueGeometry = (ValueGeometry)value;
        if (this.type != 0 && valueGeometry.getTypeAndDimensionSystem() != this.type || this.srid != null && valueGeometry.getSRID() != this.srid.intValue()) {
            throw DbException.get(23513, ExtTypeInfoGeometry.toSQL(valueGeometry.getTypeAndDimensionSystem(), valueGeometry.getSRID()) + " <> " + this.toString());
        }
        return valueGeometry;
    }

    @Override
    public String getCreateSQL() {
        return ExtTypeInfoGeometry.toSQL(this.type, this.srid);
    }
}

