/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.util.ColumnNamerConfiguration;
import org.h14199.util.StringUtils;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        if (session != null && session.getColumnNamerConfiguration() != null) {
            this.configuration = session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression expression, int n, String[] stringArray) {
        String string = null;
        if (stringArray != null && stringArray.length > n) {
            string = stringArray[n];
        }
        return this.getColumnName(expression, n, string);
    }

    public String getColumnName(Expression expression, int n, String string) {
        String string2 = this.getColumnName(string, null);
        if (string2 == null && (string2 = this.getColumnName(expression.getAlias(), DEFAULT_COLUMN_NAME)) == null && (string2 = this.getColumnName(expression.getColumnName(), DEFAULT_COLUMN_NAME)) == null && (string2 = this.getColumnName(expression.getSQL(false), DEFAULT_COLUMN_NAME)) == null) {
            string2 = this.configuration.getDefaultColumnNamePattern().replace("$$", Integer.toString(n + 1));
        }
        if (this.existingColumnNames.contains(string2) && this.configuration.isGenerateUniqueColumnNames()) {
            string2 = this.generateUniqueName(string2);
        }
        this.existingColumnNames.add(string2);
        return string2;
    }

    private String getColumnName(String string, String string2) {
        String string3 = null;
        if (string != null && !string.equals(string2)) {
            if (this.isAllowableColumnName(string)) {
                string3 = string;
            } else if (this.isAllowableColumnName(string = this.fixColumnName(string))) {
                string3 = string;
            }
        }
        return string3;
    }

    private String generateUniqueName(String string) {
        Object object = string;
        int n = 2;
        while (this.existingColumnNames.contains(object)) {
            String string2 = "_" + n;
            object = string.substring(0, Math.min(string.length(), this.configuration.getMaxIdentiferLength() - string2.length())) + string2;
            ++n;
        }
        return object;
    }

    private boolean isAllowableColumnName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n > this.configuration.getMaxIdentiferLength() || n == 0) {
            return false;
        }
        Pattern pattern = this.configuration.getCompiledRegularExpressionMatchAllowed();
        return pattern == null || pattern.matcher(string).matches();
    }

    private String fixColumnName(String string) {
        int n;
        Pattern pattern = this.configuration.getCompiledRegularExpressionMatchDisallowed();
        string = pattern == null ? StringUtils.replaceAll(string, "\u0000", "") : pattern.matcher(string).replaceAll("");
        int n2 = string.length();
        if (n2 > (n = this.configuration.getMaxIdentiferLength())) {
            string = string.substring(0, n);
        }
        return string;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

