/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.upgrade;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.h14199.engine.ConnectionInfo;
import org.h14199.jdbc.JdbcConnection;
import org.h14199.message.DbException;
import org.h14199.store.fs.FileUtils;
import org.h14199.util.StringUtils;
import org.h14199.util.Utils;

public class DbUpgrade {
    private static final boolean UPGRADE_CLASSES_PRESENT = Utils.isClassPresent("org.h14199.upgrade.v1_1.Driver");
    private static boolean scriptInTempDir;
    private static boolean deleteOldDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectOrUpgrade(String string, Properties properties) throws SQLException {
        ConnectionInfo connectionInfo;
        if (!UPGRADE_CLASSES_PRESENT) {
            return null;
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Object object = properties.get("password");
        if (object instanceof char[]) {
            properties2.put("password", StringUtils.cloneCharArray((char[])object));
        }
        if ((connectionInfo = new ConnectionInfo(string, properties = properties2)).isRemote() || !connectionInfo.isPersistent()) {
            return null;
        }
        String string2 = connectionInfo.getName();
        if (FileUtils.exists(string2 + ".h2.db")) {
            return null;
        }
        if (!FileUtils.exists(string2 + ".data.db")) {
            return null;
        }
        if (connectionInfo.removeProperty("NO_UPGRADE", false)) {
            return DbUpgrade.connectWithOldVersion(string, properties);
        }
        Class<DbUpgrade> clazz = DbUpgrade.class;
        synchronized (DbUpgrade.class) {
            DbUpgrade.upgrade(connectionInfo, properties);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    public static void setScriptInTempDir(boolean bl) {
        scriptInTempDir = bl;
    }

    public static void setDeleteOldDb(boolean bl) {
        deleteOldDb = bl;
    }

    private static Connection connectWithOldVersion(String object, Properties properties) throws SQLException {
        object = "jdbc:h2v1_1:" + ((String)object).substring("jdbc:h2:".length()) + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
        return DriverManager.getConnection((String)object, properties);
    }

    private static void upgrade(ConnectionInfo connectionInfo, Properties properties) throws SQLException {
        String string = connectionInfo.getName();
        String string2 = string + ".data.db";
        String string3 = string + ".index.db";
        String string4 = string + ".lobs.db";
        String string5 = string2 + ".backup";
        String string6 = string3 + ".backup";
        String string7 = string4 + ".backup";
        Object object = null;
        try {
            if (scriptInTempDir) {
                new File(Utils.getProperty("java.io.tmpdir", ".")).mkdirs();
                object = File.createTempFile("h2dbmigration", "backup.sql").getAbsolutePath();
            } else {
                object = string + ".script.sql";
            }
            String string8 = "jdbc:h2v1_1:" + string + ";UNDO_LOG=0;LOG=0;LOCK_MODE=0";
            String string9 = connectionInfo.getProperty("CIPHER", null);
            if (string9 != null) {
                string8 = string8 + ";CIPHER=" + string9;
            }
            Connection connection = DriverManager.getConnection(string8, properties);
            Statement statement = connection.createStatement();
            String string10 = UUID.randomUUID().toString();
            if (string9 != null) {
                statement.execute("script to '" + (String)object + "' cipher aes password '" + string10 + "' --hide--");
            } else {
                statement.execute("script to '" + (String)object + "'");
            }
            connection.close();
            FileUtils.move(string2, string5);
            FileUtils.move(string3, string6);
            if (FileUtils.exists(string4)) {
                FileUtils.move(string4, string7);
            }
            connectionInfo.removeProperty("IFEXISTS", false);
            connection = new JdbcConnection(connectionInfo, true);
            statement = connection.createStatement();
            if (string9 != null) {
                statement.execute("runscript from '" + (String)object + "' cipher aes password '" + string10 + "' --hide--");
            } else {
                statement.execute("runscript from '" + (String)object + "'");
            }
            statement.execute("analyze");
            statement.execute("shutdown compact");
            statement.close();
            connection.close();
            if (deleteOldDb) {
                FileUtils.delete(string5);
                FileUtils.delete(string6);
                FileUtils.deleteRecursive(string7, false);
            }
        }
        catch (Exception exception) {
            if (FileUtils.exists(string5)) {
                FileUtils.move(string5, string2);
            }
            if (FileUtils.exists(string6)) {
                FileUtils.move(string6, string3);
            }
            if (FileUtils.exists(string7)) {
                FileUtils.move(string7, string4);
            }
            FileUtils.delete(string + ".h2.db");
            throw DbException.toSQLException(exception);
        }
        finally {
            if (object != null) {
                FileUtils.delete((String)object);
            }
        }
    }
}

