/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.tools;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h14199.api.Trigger;
import org.h14199.tools.SimpleResultSet;
import org.h14199.tools.SimpleRowSource;

public abstract class TriggerAdapter
implements Trigger {
    protected String schemaName;
    protected String triggerName;
    protected String tableName;
    protected boolean before;
    protected int type;
    private SimpleResultSet oldResultSet;
    private SimpleResultSet newResultSet;
    private TriggerRowSource oldSource;
    private TriggerRowSource newSource;

    @Override
    public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getColumns(null, string, string3, null);
        this.oldSource = new TriggerRowSource();
        this.newSource = new TriggerRowSource();
        this.oldResultSet = new SimpleResultSet(this.oldSource);
        this.newResultSet = new SimpleResultSet(this.newSource);
        while (resultSet.next()) {
            String string4 = resultSet.getString("COLUMN_NAME");
            int n2 = resultSet.getInt("DATA_TYPE");
            int n3 = resultSet.getInt("COLUMN_SIZE");
            int n4 = resultSet.getInt("DECIMAL_DIGITS");
            this.oldResultSet.addColumn(string4, n2, n3, n4);
            this.newResultSet.addColumn(string4, n2, n3, n4);
        }
        this.schemaName = string;
        this.triggerName = string2;
        this.tableName = string3;
        this.before = bl;
        this.type = n;
    }

    @Override
    public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
        this.fire(connection, TriggerAdapter.wrap(this.oldResultSet, this.oldSource, objectArray), TriggerAdapter.wrap(this.newResultSet, this.newSource, objectArray2));
    }

    public abstract void fire(Connection var1, ResultSet var2, ResultSet var3) throws SQLException;

    private static SimpleResultSet wrap(SimpleResultSet simpleResultSet, TriggerRowSource triggerRowSource, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        triggerRowSource.setRow(objectArray);
        simpleResultSet.next();
        return simpleResultSet;
    }

    @Override
    public void remove() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    static class TriggerRowSource
    implements SimpleRowSource {
        private Object[] row;

        TriggerRowSource() {
        }

        void setRow(Object[] objectArray) {
            this.row = objectArray;
        }

        @Override
        public Object[] readRow() {
            return this.row;
        }

        @Override
        public void close() {
        }

        @Override
        public void reset() {
        }
    }
}

