/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h14199.command.ddl.CreateTableData;
import org.h14199.constraint.Constraint;
import org.h14199.constraint.ConstraintReferential;
import org.h14199.engine.Session;
import org.h14199.index.Index;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.table.Column;
import org.h14199.table.Table;
import org.h14199.table.TableBase;
import org.h14199.table.TableType;
import org.h14199.value.DataType;

public abstract class RegularTable
extends TableBase {
    protected final boolean containsLargeObject;
    protected volatile Session lockExclusiveSession;
    protected final ConcurrentHashMap<Session, Session> lockSharedSessions = new ConcurrentHashMap();
    private Column rowIdColumn;

    protected static void addRowsToIndex(Session session, ArrayList<Row> arrayList, Index index) {
        RegularTable.sortRows(arrayList, index);
        for (Row row : arrayList) {
            index.add(session, row);
        }
        arrayList.clear();
    }

    protected static String getDeadlockDetails(ArrayList<Session> arrayList, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : arrayList) {
            Table table = session.getWaitForLock();
            Thread thread = session.getWaitForLockThread();
            stringBuilder.append("\nSession ").append(session.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(table.toString()).append(bl ? " (exclusive)" : " (shared)").append(" while locking ");
            Table[] tableArray = session.getLocks();
            int n = tableArray.length;
            for (int i = 0; i < n; ++i) {
                Table table2 = tableArray[i];
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof RegularTable)) continue;
                if (((RegularTable)table2).lockExclusiveSession == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    protected static void sortRows(ArrayList<? extends SearchRow> arrayList, final Index index) {
        Collections.sort(arrayList, new Comparator<SearchRow>(){

            @Override
            public int compare(SearchRow searchRow, SearchRow searchRow2) {
                return index.compareRows(searchRow, searchRow2);
            }
        });
    }

    protected RegularTable(CreateTableData createTableData) {
        super(createTableData);
        this.isHidden = createTableData.isHidden;
        boolean bl = false;
        for (Column column : this.getColumns()) {
            if (!DataType.isLargeObject(column.getType().getValueType())) continue;
            bl = true;
            break;
        }
        this.containsLargeObject = bl;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            for (Constraint constraint : arrayList) {
                ConstraintReferential constraintReferential;
                if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2;
            if (session2 == null) {
                session2 = session;
                set = new HashSet<Session>();
            } else {
                if (session2 == session) {
                    return new ArrayList<Session>(0);
                }
                if (set.contains(session)) {
                    return null;
                }
            }
            set.add(session);
            ArrayList<Session> arrayList = null;
            for (Object object2 : this.lockSharedSessions.keySet()) {
                Table table;
                if (object2 == session || (table = ((Session)object2).getWaitForLock()) == null || (arrayList = table.checkDeadlock((Session)object2, session2, set)) == null) continue;
                arrayList.add(session);
                break;
            }
            Session session3 = this.lockExclusiveSession;
            if (arrayList == null && session3 != null && (object2 = session3.getWaitForLock()) != null && (arrayList = ((Table)object2).checkDeadlock(session3, session2, set)) != null) {
                arrayList.add(session);
            }
            return arrayList;
        }
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
            this.rowIdColumn.setRowId(true);
        }
        return this.rowIdColumn;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusiveSession == session;
    }

    @Override
    public String toString() {
        return this.getSQL(false);
    }
}

