/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h14199.engine.SysProperties;
import org.h14199.message.DbException;
import org.h14199.server.web.PageParser;
import org.h14199.server.web.WebApp;
import org.h14199.server.web.WebServer;
import org.h14199.util.IOUtils;
import org.h14199.util.NetUtils;
import org.h14199.util.StringUtils;
import org.h14199.util.Utils;

class WebThread
extends WebApp
implements Runnable {
    protected OutputStream output;
    protected final Socket socket;
    private final Thread thread;
    private InputStream input;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer webServer) {
        super(webServer);
        this.socket = socket;
        this.thread = new Thread((Runnable)this, "H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int n) throws InterruptedException {
        this.thread.join(n);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String string) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (string.length() == 0) {
            return "index.do";
        }
        if (string.charAt(0) == '?') {
            return "index.do" + string;
        }
        return string;
    }

    @Override
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (Exception exception) {
            DbException.traceThrowable(exception);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        boolean bl = false;
        String string = this.readHeaderLine();
        if (string.startsWith("GET ") || string.startsWith("POST ")) {
            byte[] byArray;
            Object object;
            String string2;
            int n = string.indexOf(47);
            int n2 = string.lastIndexOf(32);
            String string3 = n < 0 || n2 < n ? "" : StringUtils.trimSubstring(string, n + 1, n2);
            this.trace(string + ": " + string3);
            string3 = this.getAllowedFile(string3);
            this.attributes = new Properties();
            int n3 = string3.indexOf(63);
            this.session = null;
            String string4 = null;
            if (n3 >= 0) {
                string2 = string3.substring(n3 + 1);
                this.parseAttributes(string2);
                object = this.attributes.getProperty("jsessionid");
                string4 = this.attributes.getProperty("key");
                string3 = string3.substring(0, n3);
                this.session = this.server.getSession((String)object);
            }
            bl = this.parseHeader();
            string2 = this.socket.getInetAddress().getHostAddress();
            if ((string3 = this.processRequest(string3, string2)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                byArray = null;
                object = "HTTP/1.1 304 Not Modified\r\n";
            } else {
                byArray = this.server.getFile(string3);
                if (byArray == null) {
                    object = "HTTP/1.1 404 Not Found\r\n";
                    byArray = ("File not found: " + string3).getBytes(StandardCharsets.UTF_8);
                    object = (String)object + "Content-Length: " + byArray.length + "\r\n";
                } else {
                    if (this.session != null && string3.endsWith(".jsp")) {
                        Iterator iterator;
                        if (string4 != null) {
                            this.session.put("key", string4);
                        }
                        String string5 = new String(byArray, StandardCharsets.UTF_8);
                        if (SysProperties.CONSOLE_STREAM && (iterator = (Iterator)this.session.map.remove("chunks")) != null) {
                            object = "HTTP/1.1 200 OK\r\n";
                            object = (String)object + "Content-Type: " + this.mimeType + "\r\n";
                            object = (String)object + "Cache-Control: no-cache\r\n";
                            object = (String)object + "Transfer-Encoding: chunked\r\n";
                            object = (String)object + "\r\n";
                            this.trace((String)object);
                            this.output.write(((String)object).getBytes());
                            while (iterator.hasNext()) {
                                String string6 = (String)iterator.next();
                                byArray = (string6 = PageParser.parse(string6, this.session.map)).getBytes(StandardCharsets.UTF_8);
                                if (byArray.length == 0) continue;
                                this.output.write(Integer.toHexString(byArray.length).getBytes());
                                this.output.write("\r\n".getBytes());
                                this.output.write(byArray);
                                this.output.write("\r\n".getBytes());
                                this.output.flush();
                            }
                            this.output.write("0\r\n\r\n".getBytes());
                            this.output.flush();
                            return bl;
                        }
                        string5 = PageParser.parse(string5, this.session.map);
                        byArray = string5.getBytes(StandardCharsets.UTF_8);
                    }
                    object = "HTTP/1.1 200 OK\r\n";
                    object = (String)object + "Content-Type: " + this.mimeType + "\r\n";
                    if (!this.cache) {
                        object = (String)object + "Cache-Control: no-cache\r\n";
                    } else {
                        object = (String)object + "Cache-Control: max-age=10\r\n";
                        object = (String)object + "Last-Modified: " + this.server.getStartDateTime() + "\r\n";
                    }
                    object = (String)object + "Content-Length: " + byArray.length + "\r\n";
                }
            }
            object = (String)object + "\r\n";
            this.trace((String)object);
            this.output.write(((String)object).getBytes());
            if (byArray != null) {
                this.output.write(byArray);
            }
            this.output.flush();
        }
        return bl;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 13) {
                if (this.input.read() != 10) continue;
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            if (n == 10) {
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            stringBuilder.append((char)n);
        }
    }

    private void parseAttributes(String string) {
        int n;
        this.trace("data=" + string);
        while (string != null && (n = string.indexOf(61)) >= 0) {
            String string2;
            String string3 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(38)) >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
            }
            String string4 = StringUtils.urlDecode(string2);
            this.attributes.put(string3, string4);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        Object object;
        boolean bl = false;
        this.trace("parseHeader");
        int n = 0;
        this.ifModifiedSince = null;
        boolean bl2 = false;
        block0: while ((object = this.readHeaderLine()) != null) {
            this.trace(" " + (String)object);
            String string = StringUtils.toLowerEnglish((String)object);
            if (string.startsWith("if-modified-since")) {
                this.ifModifiedSince = WebThread.getHeaderLineValue((String)object);
                continue;
            }
            if (string.startsWith("connection")) {
                String string2 = WebThread.getHeaderLineValue((String)object);
                if (!"keep-alive".equals(string2)) continue;
                bl = true;
                continue;
            }
            if (string.startsWith("content-type")) {
                String string3 = WebThread.getHeaderLineValue((String)object);
                if (!string3.startsWith("multipart/form-data")) continue;
                bl2 = true;
                continue;
            }
            if (string.startsWith("content-length")) {
                n = Integer.parseInt(WebThread.getHeaderLineValue((String)object));
                this.trace("len=" + n);
                continue;
            }
            if (string.startsWith("user-agent")) {
                boolean bl3 = string.contains("webkit/");
                if (!bl3 || this.session == null) continue;
                this.session.put("frame-border", "1");
                this.session.put("frameset-border", "2");
                continue;
            }
            if (string.startsWith("accept-language")) {
                Locale locale = this.session == null ? null : this.session.locale;
                if (locale != null) continue;
                String string4 = WebThread.getHeaderLineValue((String)object);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.startsWith("q=") || !this.server.supportsLanguage(string5)) continue;
                    int n2 = string5.indexOf(45);
                    if (n2 >= 0) {
                        String string6 = string5.substring(0, n2);
                        String string7 = string5.substring(n2 + 1);
                        locale = new Locale(string6, string7);
                    } else {
                        locale = new Locale(string5, "");
                    }
                    this.headerLanguage = locale.getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = locale;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (!StringUtils.isWhitespaceOrEmpty((String)object)) continue;
            break;
        }
        if (!bl2 && this.session != null && n > 0) {
            object = Utils.newBytes(n);
            for (int i = 0; i < n; i += this.input.read((byte[])object, i, n - i)) {
            }
            String string = new String((byte[])object);
            this.parseAttributes(string);
        }
        return bl;
    }

    private static String getHeaderLineValue(String string) {
        return StringUtils.trimSubstring(string, string.indexOf(58) + 1);
    }

    @Override
    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.server.traceError(unknownHostException);
            return false;
        }
    }

    private void trace(String string) {
        this.server.trace(string);
    }
}

