/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.result;

import org.h14199.engine.SessionInterface;
import org.h14199.expression.Expression;
import org.h14199.message.DbException;
import org.h14199.result.ResultInterface;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;

public abstract class LazyResult
implements ResultInterface {
    private final Expression[] expressions;
    private int rowId = -1;
    private Value[] currentRow;
    private Value[] nextRow;
    private boolean closed;
    private boolean afterLast;
    private int limit;

    public LazyResult(Expression[] expressionArray) {
        this.expressions = expressionArray;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public void reset() {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.rowId = -1;
        this.afterLast = false;
        this.currentRow = null;
        this.nextRow = null;
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.rowId;
            this.currentRow = this.nextRow;
            this.nextRow = null;
            return true;
        }
        if (!this.afterLast) {
            ++this.rowId;
            this.currentRow = null;
            this.afterLast = true;
        }
        return false;
    }

    public boolean skip() {
        if (this.closed || this.afterLast) {
            return false;
        }
        this.currentRow = null;
        if (this.nextRow != null) {
            this.nextRow = null;
            return true;
        }
        if (this.skipNextRow()) {
            return true;
        }
        this.afterLast = true;
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.closed || this.afterLast) {
            return false;
        }
        if (this.nextRow == null && (this.limit <= 0 || this.rowId + 1 < this.limit)) {
            this.nextRow = this.fetchNextRow();
        }
        return this.nextRow != null;
    }

    protected abstract Value[] fetchNextRow();

    protected boolean skipNextRow() {
        return this.fetchNextRow() != null;
    }

    @Override
    public boolean isAfterLast() {
        return this.afterLast;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public int getRowCount() {
        throw DbException.getUnsupportedException("Row count is unknown for lazy result.");
    }

    @Override
    public boolean needToClose() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    @Override
    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    @Override
    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    @Override
    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    @Override
    public TypeInfo getColumnType(int n) {
        return this.expressions[n].getType();
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    @Override
    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    @Override
    public void setFetchSize(int n) {
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public ResultInterface createShallowCopy(SessionInterface sessionInterface) {
        return null;
    }
}

