/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.mvstore.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.h14199.mvstore.DataUtils;
import org.h14199.mvstore.WriteBuffer;
import org.h14199.mvstore.type.DataType;
import org.h14199.mvstore.type.StringDataType;
import org.h14199.util.Utils;

public class ObjectDataType
implements DataType {
    static final int TYPE_NULL = 0;
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_BIG_INTEGER = 6;
    static final int TYPE_FLOAT = 7;
    static final int TYPE_DOUBLE = 8;
    static final int TYPE_BIG_DECIMAL = 9;
    static final int TYPE_CHAR = 10;
    static final int TYPE_STRING = 11;
    static final int TYPE_UUID = 12;
    static final int TYPE_DATE = 13;
    static final int TYPE_ARRAY = 14;
    static final int TYPE_SERIALIZED_OBJECT = 19;
    static final int TAG_BOOLEAN_TRUE = 32;
    static final int TAG_INTEGER_NEGATIVE = 33;
    static final int TAG_INTEGER_FIXED = 34;
    static final int TAG_LONG_NEGATIVE = 35;
    static final int TAG_LONG_FIXED = 36;
    static final int TAG_BIG_INTEGER_0 = 37;
    static final int TAG_BIG_INTEGER_1 = 38;
    static final int TAG_BIG_INTEGER_SMALL = 39;
    static final int TAG_FLOAT_0 = 40;
    static final int TAG_FLOAT_1 = 41;
    static final int TAG_FLOAT_FIXED = 42;
    static final int TAG_DOUBLE_0 = 43;
    static final int TAG_DOUBLE_1 = 44;
    static final int TAG_DOUBLE_FIXED = 45;
    static final int TAG_BIG_DECIMAL_0 = 46;
    static final int TAG_BIG_DECIMAL_1 = 47;
    static final int TAG_BIG_DECIMAL_SMALL = 48;
    static final int TAG_BIG_DECIMAL_SMALL_SCALED = 49;
    static final int TAG_INTEGER_0_15 = 64;
    static final int TAG_LONG_0_7 = 80;
    static final int TAG_STRING_0_15 = 88;
    static final int TAG_BYTE_ARRAY_0_15 = 104;
    static final int FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int FLOAT_ONE_BITS = Float.floatToIntBits(1.0f);
    static final long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);
    static final long DOUBLE_ONE_BITS = Double.doubleToLongBits(1.0);
    static final Class<?>[] COMMON_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, BigInteger.class, Float.class, Double.class, BigDecimal.class, String.class, UUID.class, Date.class};
    private static final HashMap<Class<?>, Integer> COMMON_CLASSES_MAP = new HashMap(32);
    private AutoDetectDataType last = new StringType(this);

    @Override
    public int compare(Object object, Object object2) {
        return this.last.compare(object, object2);
    }

    @Override
    public int getMemory(Object object) {
        return this.last.getMemory(object);
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            this.write(writeBuffer, objectArray[i]);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        this.last.write(writeBuffer, object);
    }

    private AutoDetectDataType newType(int n) {
        switch (n) {
            case 0: {
                return new NullType(this);
            }
            case 1: {
                return new BooleanType(this);
            }
            case 2: {
                return new ByteType(this);
            }
            case 3: {
                return new ShortType(this);
            }
            case 10: {
                return new CharacterType(this);
            }
            case 4: {
                return new IntegerType(this);
            }
            case 5: {
                return new LongType(this);
            }
            case 7: {
                return new FloatType(this);
            }
            case 8: {
                return new DoubleType(this);
            }
            case 6: {
                return new BigIntegerType(this);
            }
            case 9: {
                return new BigDecimalType(this);
            }
            case 11: {
                return new StringType(this);
            }
            case 12: {
                return new UUIDType(this);
            }
            case 13: {
                return new DateType(this);
            }
            case 14: {
                return new ObjectArrayType(this);
            }
            case 19: {
                return new SerializedObjectType(this);
            }
        }
        throw DataUtils.newIllegalStateException(3, "Unsupported type {0}", n);
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.get();
        if (n2 <= 19) {
            n = n2;
        } else {
            switch (n2) {
                case 32: {
                    n = 1;
                    break;
                }
                case 33: 
                case 34: {
                    n = 4;
                    break;
                }
                case 35: 
                case 36: {
                    n = 5;
                    break;
                }
                case 37: 
                case 38: 
                case 39: {
                    n = 6;
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    n = 7;
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    n = 8;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    n = 9;
                    break;
                }
                default: {
                    if (n2 >= 64 && n2 <= 79) {
                        n = 4;
                        break;
                    }
                    if (n2 >= 88 && n2 <= 103) {
                        n = 11;
                        break;
                    }
                    if (n2 >= 80 && n2 <= 87) {
                        n = 5;
                        break;
                    }
                    if (n2 >= 104 && n2 <= 119) {
                        n = 14;
                        break;
                    }
                    throw DataUtils.newIllegalStateException(6, "Unknown tag {0}", n2);
                }
            }
        }
        AutoDetectDataType autoDetectDataType = this.last;
        if (n != autoDetectDataType.typeId) {
            this.last = autoDetectDataType = this.newType(n);
        }
        return autoDetectDataType.read(byteBuffer, n2);
    }

    private static int getTypeId(Object object) {
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof String) {
            return 11;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Boolean) {
            return 1;
        }
        if (object instanceof UUID) {
            return 12;
        }
        if (object instanceof Byte) {
            return 2;
        }
        if (object instanceof Short) {
            return 3;
        }
        if (object instanceof Character) {
            return 10;
        }
        if (object == null) {
            return 0;
        }
        if (ObjectDataType.isDate(object)) {
            return 13;
        }
        if (ObjectDataType.isBigInteger(object)) {
            return 6;
        }
        if (ObjectDataType.isBigDecimal(object)) {
            return 9;
        }
        if (object.getClass().isArray()) {
            return 14;
        }
        return 19;
    }

    AutoDetectDataType switchType(Object object) {
        int n = ObjectDataType.getTypeId(object);
        AutoDetectDataType autoDetectDataType = this.last;
        if (n != autoDetectDataType.typeId) {
            this.last = autoDetectDataType = this.newType(n);
        }
        return autoDetectDataType;
    }

    static boolean isBigInteger(Object object) {
        return object != null && object.getClass() == BigInteger.class;
    }

    static boolean isBigDecimal(Object object) {
        return object != null && object.getClass() == BigDecimal.class;
    }

    static boolean isDate(Object object) {
        return object != null && object.getClass() == Date.class;
    }

    static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getCommonClassId(Class<?> clazz) {
        HashMap<Class<?>, Integer> hashMap = COMMON_CLASSES_MAP;
        if (hashMap.size() == 0) {
            HashMap<Class<?>, Integer> hashMap2 = hashMap;
            synchronized (hashMap2) {
                if (hashMap.size() == 0) {
                    int n = COMMON_CLASSES.length;
                    for (int i = 0; i < n; ++i) {
                        hashMap.put(COMMON_CLASSES[i], i);
                    }
                }
            }
        }
        return hashMap.get(clazz);
    }

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw DataUtils.newIllegalArgumentException("Could not serialize {0}", object, throwable);
        }
    }

    public static Object deserialize(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throw DataUtils.newIllegalArgumentException("Could not deserialize {0}", Arrays.toString(byArray), throwable);
        }
    }

    public static int compareNotNull(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            if (n2 == n3) continue;
            return n2 > n3 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    static class SerializedObjectType
    extends AutoDetectDataType {
        private int averageSize = 10000;

        SerializedObjectType(ObjectDataType objectDataType) {
            super(objectDataType, 19);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            AutoDetectDataType autoDetectDataType = this.getType(object);
            AutoDetectDataType autoDetectDataType2 = this.getType(object2);
            if (autoDetectDataType != this || autoDetectDataType2 != this) {
                if (autoDetectDataType == autoDetectDataType2) {
                    return autoDetectDataType.compare(object, object2);
                }
                return super.compare(object, object2);
            }
            if (object instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
                return -((Comparable)object2).compareTo(object);
            }
            byte[] byArray = ObjectDataType.serialize(object);
            byte[] byArray2 = ObjectDataType.serialize(object2);
            return ObjectDataType.compareNotNull(byArray, byArray2);
        }

        @Override
        public int getMemory(Object object) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            if (autoDetectDataType == this) {
                return this.averageSize;
            }
            return autoDetectDataType.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            if (autoDetectDataType != this) {
                autoDetectDataType.write(writeBuffer, object);
                return;
            }
            byte[] byArray = ObjectDataType.serialize(object);
            int n = byArray.length * 2;
            this.averageSize = (n + 15 * this.averageSize) / 16;
            writeBuffer.put((byte)19).putVarInt(byArray.length).put(byArray);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = Utils.newBytes(n2);
            int n3 = byArray.length * 2;
            this.averageSize = (n3 + 15 * this.averageSize) / 16;
            byteBuffer.get(byArray);
            return ObjectDataType.deserialize(byArray);
        }
    }

    static class ObjectArrayType
    extends AutoDetectDataType {
        private final ObjectDataType elementType = new ObjectDataType();

        ObjectArrayType(ObjectDataType objectDataType) {
            super(objectDataType, 14);
        }

        @Override
        public int getMemory(Object object) {
            int n;
            block4: {
                block2: {
                    int n2;
                    Class<?> clazz;
                    block6: {
                        block5: {
                            block3: {
                                if (!ObjectDataType.isArray(object)) {
                                    return super.getMemory(object);
                                }
                                n = 64;
                                clazz = object.getClass().getComponentType();
                                if (!clazz.isPrimitive()) break block2;
                                n2 = Array.getLength(object);
                                if (clazz != Boolean.TYPE && clazz != Byte.TYPE) break block3;
                                n += n2;
                                break block4;
                            }
                            if (clazz != Character.TYPE && clazz != Short.TYPE) break block5;
                            n += n2 * 2;
                            break block4;
                        }
                        if (clazz != Integer.TYPE && clazz != Float.TYPE) break block6;
                        n += n2 * 4;
                        break block4;
                    }
                    if (clazz != Double.TYPE && clazz != Long.TYPE) break block4;
                    n += n2 * 8;
                    break block4;
                }
                for (Object object2 : (Object[])object) {
                    if (object2 == null) continue;
                    n += this.elementType.getMemory(object2);
                }
            }
            return n * 2;
        }

        @Override
        public int compare(Object object, Object object2) {
            Class<?> clazz;
            if (!ObjectDataType.isArray(object) || !ObjectDataType.isArray(object2)) {
                return super.compare(object, object2);
            }
            if (object == object2) {
                return 0;
            }
            Class<?> clazz2 = object.getClass().getComponentType();
            if (clazz2 != (clazz = object2.getClass().getComponentType())) {
                Integer n = ObjectDataType.getCommonClassId(clazz2);
                Integer n2 = ObjectDataType.getCommonClassId(clazz);
                if (n != null) {
                    if (n2 != null) {
                        return n.compareTo(n2);
                    }
                    return -1;
                }
                if (n2 != null) {
                    return 1;
                }
                return clazz2.getName().compareTo(clazz.getName());
            }
            int n = Array.getLength(object);
            int n3 = Array.getLength(object2);
            int n4 = Math.min(n, n3);
            if (clazz2.isPrimitive()) {
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object;
                    byte[] byArray2 = (byte[])object2;
                    return ObjectDataType.compareNotNull(byArray, byArray2);
                }
                for (int i = 0; i < n4; ++i) {
                    int n5;
                    if (clazz2 == Boolean.TYPE) {
                        n5 = Integer.signum((((boolean[])object)[i] ? 1 : 0) - (((boolean[])object2)[i] ? 1 : 0));
                    } else if (clazz2 == Character.TYPE) {
                        n5 = Integer.signum(((char[])object)[i] - ((char[])object2)[i]);
                    } else if (clazz2 == Short.TYPE) {
                        n5 = Integer.signum(((short[])object)[i] - ((short[])object2)[i]);
                    } else if (clazz2 == Integer.TYPE) {
                        int n6 = ((int[])object)[i];
                        int n7 = ((int[])object2)[i];
                        n5 = Integer.compare(n6, n7);
                    } else if (clazz2 == Float.TYPE) {
                        n5 = Float.compare(((float[])object)[i], ((float[])object2)[i]);
                    } else if (clazz2 == Double.TYPE) {
                        n5 = Double.compare(((double[])object)[i], ((double[])object2)[i]);
                    } else {
                        long l = ((long[])object)[i];
                        long l2 = ((long[])object2)[i];
                        n5 = Long.compare(l, l2);
                    }
                    if (n5 == 0) continue;
                    return n5;
                }
            } else {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = 0; i < n4; ++i) {
                    int n8 = this.elementType.compare(objectArray[i], objectArray2[i]);
                    if (n8 == 0) continue;
                    return n8;
                }
            }
            return Integer.compare(n, n3);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            Object[] objectArray;
            if (!ObjectDataType.isArray(object)) {
                super.write(writeBuffer, object);
                return;
            }
            Class<?> clazz = object.getClass().getComponentType();
            Integer n = ObjectDataType.getCommonClassId(clazz);
            if (n != null) {
                if (clazz.isPrimitive()) {
                    if (clazz == Byte.TYPE) {
                        byte[] byArray = (byte[])object;
                        int n2 = byArray.length;
                        if (n2 <= 15) {
                            writeBuffer.put((byte)(104 + n2));
                        } else {
                            writeBuffer.put((byte)14).put((byte)n.intValue()).putVarInt(n2);
                        }
                        writeBuffer.put(byArray);
                        return;
                    }
                    int n3 = Array.getLength(object);
                    writeBuffer.put((byte)14).put((byte)n.intValue()).putVarInt(n3);
                    for (int i = 0; i < n3; ++i) {
                        if (clazz == Boolean.TYPE) {
                            writeBuffer.put((byte)(((boolean[])object)[i] ? 1 : 0));
                            continue;
                        }
                        if (clazz == Character.TYPE) {
                            writeBuffer.putChar(((char[])object)[i]);
                            continue;
                        }
                        if (clazz == Short.TYPE) {
                            writeBuffer.putShort(((short[])object)[i]);
                            continue;
                        }
                        if (clazz == Integer.TYPE) {
                            writeBuffer.putInt(((int[])object)[i]);
                            continue;
                        }
                        if (clazz == Float.TYPE) {
                            writeBuffer.putFloat(((float[])object)[i]);
                            continue;
                        }
                        if (clazz == Double.TYPE) {
                            writeBuffer.putDouble(((double[])object)[i]);
                            continue;
                        }
                        writeBuffer.putLong(((long[])object)[i]);
                    }
                    return;
                }
                writeBuffer.put((byte)14).put((byte)n.intValue());
            } else {
                writeBuffer.put((byte)14).put((byte)-1);
                objectArray = clazz.getName();
                StringDataType.INSTANCE.write(writeBuffer, objectArray);
            }
            objectArray = (Object[])object;
            int n4 = objectArray.length;
            writeBuffer.putVarInt(n4);
            for (Object object2 : objectArray) {
                this.elementType.write(writeBuffer, object2);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            Object object;
            Class<?> clazz;
            if (n != 14) {
                int n2 = n - 104;
                byte[] byArray = Utils.newBytes(n2);
                byteBuffer.get(byArray);
                return byArray;
            }
            byte by = byteBuffer.get();
            if (by == -1) {
                String string = StringDataType.INSTANCE.read(byteBuffer);
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    throw DataUtils.newIllegalStateException(8, "Could not get class {0}", string, exception);
                }
            } else {
                clazz = COMMON_CLASSES[by];
            }
            int n3 = DataUtils.readVarInt(byteBuffer);
            try {
                object = Array.newInstance(clazz, n3);
            }
            catch (Exception exception) {
                throw DataUtils.newIllegalStateException(8, "Could not create array of type {0} length {1}", clazz, n3, exception);
            }
            if (clazz.isPrimitive()) {
                for (int i = 0; i < n3; ++i) {
                    if (clazz == Boolean.TYPE) {
                        ((boolean[])object)[i] = byteBuffer.get() == 1;
                        continue;
                    }
                    if (clazz == Byte.TYPE) {
                        ((byte[])object)[i] = byteBuffer.get();
                        continue;
                    }
                    if (clazz == Character.TYPE) {
                        ((char[])object)[i] = byteBuffer.getChar();
                        continue;
                    }
                    if (clazz == Short.TYPE) {
                        ((short[])object)[i] = byteBuffer.getShort();
                        continue;
                    }
                    if (clazz == Integer.TYPE) {
                        ((int[])object)[i] = byteBuffer.getInt();
                        continue;
                    }
                    if (clazz == Float.TYPE) {
                        ((float[])object)[i] = byteBuffer.getFloat();
                        continue;
                    }
                    if (clazz == Double.TYPE) {
                        ((double[])object)[i] = byteBuffer.getDouble();
                        continue;
                    }
                    ((long[])object)[i] = byteBuffer.getLong();
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < n3; ++i) {
                    objectArray[i] = this.elementType.read(byteBuffer);
                }
            }
            return object;
        }
    }

    static class DateType
    extends AutoDetectDataType {
        DateType(ObjectDataType objectDataType) {
            super(objectDataType, 13);
        }

        @Override
        public int getMemory(Object object) {
            return ObjectDataType.isDate(object) ? 40 : super.getMemory(object);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (ObjectDataType.isDate(object) && ObjectDataType.isDate(object2)) {
                Date date = (Date)object;
                Date date2 = (Date)object2;
                return date.compareTo(date2);
            }
            return super.compare(object, object2);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!ObjectDataType.isDate(object)) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)13);
            Date date = (Date)object;
            writeBuffer.putLong(date.getTime());
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            long l = byteBuffer.getLong();
            return new Date(l);
        }
    }

    static class UUIDType
    extends AutoDetectDataType {
        UUIDType(ObjectDataType objectDataType) {
            super(objectDataType, 12);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof UUID ? 40 : super.getMemory(object);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof UUID && object2 instanceof UUID) {
                UUID uUID = (UUID)object;
                UUID uUID2 = (UUID)object2;
                return uUID.compareTo(uUID2);
            }
            return super.compare(object, object2);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof UUID)) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)12);
            UUID uUID = (UUID)object;
            writeBuffer.putLong(uUID.getMostSignificantBits());
            writeBuffer.putLong(uUID.getLeastSignificantBits());
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            return new UUID(l, l2);
        }
    }

    static class StringType
    extends AutoDetectDataType {
        StringType(ObjectDataType objectDataType) {
            super(objectDataType, 11);
        }

        @Override
        public int getMemory(Object object) {
            if (!(object instanceof String)) {
                return super.getMemory(object);
            }
            return 24 + 2 * object.toString().length();
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return object.toString().compareTo(object2.toString());
            }
            return super.compare(object, object2);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof String)) {
                super.write(writeBuffer, object);
                return;
            }
            String string = (String)object;
            int n = string.length();
            if (n <= 15) {
                writeBuffer.put((byte)(88 + n));
            } else {
                writeBuffer.put((byte)11).putVarInt(n);
            }
            writeBuffer.putStringData(string, n);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            int n2 = n == 11 ? DataUtils.readVarInt(byteBuffer) : n - 88;
            return DataUtils.readString(byteBuffer, n2);
        }
    }

    static class BigDecimalType
    extends AutoDetectDataType {
        BigDecimalType(ObjectDataType objectDataType) {
            super(objectDataType, 9);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (ObjectDataType.isBigDecimal(object) && ObjectDataType.isBigDecimal(object2)) {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.compareTo(bigDecimal2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return ObjectDataType.isBigDecimal(object) ? 150 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!ObjectDataType.isBigDecimal(object)) {
                super.write(writeBuffer, object);
                return;
            }
            BigDecimal bigDecimal = (BigDecimal)object;
            if (BigDecimal.ZERO.equals(bigDecimal)) {
                writeBuffer.put((byte)46);
            } else if (BigDecimal.ONE.equals(bigDecimal)) {
                writeBuffer.put((byte)47);
            } else {
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n2 = bigInteger.bitLength();
                if (n2 < 64) {
                    if (n == 0) {
                        writeBuffer.put((byte)48);
                    } else {
                        writeBuffer.put((byte)49).putVarInt(n);
                    }
                    writeBuffer.putVarLong(bigInteger.longValue());
                } else {
                    byte[] byArray = bigInteger.toByteArray();
                    writeBuffer.put((byte)9).putVarInt(n).putVarInt(byArray.length).put(byArray);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 46: {
                    return BigDecimal.ZERO;
                }
                case 47: {
                    return BigDecimal.ONE;
                }
                case 48: {
                    return BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer));
                }
                case 49: {
                    int n2 = DataUtils.readVarInt(byteBuffer);
                    return BigDecimal.valueOf(DataUtils.readVarLong(byteBuffer), n2);
                }
            }
            int n3 = DataUtils.readVarInt(byteBuffer);
            int n4 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = Utils.newBytes(n4);
            byteBuffer.get(byArray);
            BigInteger bigInteger = new BigInteger(byArray);
            return new BigDecimal(bigInteger, n3);
        }
    }

    static class BigIntegerType
    extends AutoDetectDataType {
        BigIntegerType(ObjectDataType objectDataType) {
            super(objectDataType, 6);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (ObjectDataType.isBigInteger(object) && ObjectDataType.isBigInteger(object2)) {
                BigInteger bigInteger = (BigInteger)object;
                BigInteger bigInteger2 = (BigInteger)object2;
                return bigInteger.compareTo(bigInteger2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return ObjectDataType.isBigInteger(object) ? 100 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!ObjectDataType.isBigInteger(object)) {
                super.write(writeBuffer, object);
                return;
            }
            BigInteger bigInteger = (BigInteger)object;
            if (BigInteger.ZERO.equals(bigInteger)) {
                writeBuffer.put((byte)37);
            } else if (BigInteger.ONE.equals(bigInteger)) {
                writeBuffer.put((byte)38);
            } else {
                int n = bigInteger.bitLength();
                if (n <= 63) {
                    writeBuffer.put((byte)39).putVarLong(bigInteger.longValue());
                } else {
                    byte[] byArray = bigInteger.toByteArray();
                    writeBuffer.put((byte)6).putVarInt(byArray.length).put(byArray);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 37: {
                    return BigInteger.ZERO;
                }
                case 38: {
                    return BigInteger.ONE;
                }
                case 39: {
                    return BigInteger.valueOf(DataUtils.readVarLong(byteBuffer));
                }
            }
            int n2 = DataUtils.readVarInt(byteBuffer);
            byte[] byArray = Utils.newBytes(n2);
            byteBuffer.get(byArray);
            return new BigInteger(byArray);
        }
    }

    static class DoubleType
    extends AutoDetectDataType {
        DoubleType(ObjectDataType objectDataType) {
            super(objectDataType, 8);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Double && object2 instanceof Double) {
                Double d = (Double)object;
                Double d2 = (Double)object2;
                return d.compareTo(d2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Double ? 30 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Double)) {
                super.write(writeBuffer, object);
                return;
            }
            double d = (Double)object;
            long l = Double.doubleToLongBits(d);
            if (l == DOUBLE_ZERO_BITS) {
                writeBuffer.put((byte)43);
            } else if (l == DOUBLE_ONE_BITS) {
                writeBuffer.put((byte)44);
            } else {
                long l2 = Long.reverse(l);
                if (l2 >= 0L && l2 <= 0x1FFFFFFFFFFFFL) {
                    writeBuffer.put((byte)8);
                    writeBuffer.putVarLong(l2);
                } else {
                    writeBuffer.put((byte)45);
                    writeBuffer.putDouble(d);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 43: {
                    return 0.0;
                }
                case 44: {
                    return 1.0;
                }
                case 45: {
                    return byteBuffer.getDouble();
                }
            }
            return Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(byteBuffer)));
        }
    }

    static class FloatType
    extends AutoDetectDataType {
        FloatType(ObjectDataType objectDataType) {
            super(objectDataType, 7);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Float && object2 instanceof Float) {
                Float f = (Float)object;
                Float f2 = (Float)object2;
                return f.compareTo(f2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Float ? 24 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Float)) {
                super.write(writeBuffer, object);
                return;
            }
            float f = ((Float)object).floatValue();
            int n = Float.floatToIntBits(f);
            if (n == FLOAT_ZERO_BITS) {
                writeBuffer.put((byte)40);
            } else if (n == FLOAT_ONE_BITS) {
                writeBuffer.put((byte)41);
            } else {
                int n2 = Integer.reverse(n);
                if (n2 >= 0 && n2 <= 0x1FFFFF) {
                    writeBuffer.put((byte)7).putVarInt(n2);
                } else {
                    writeBuffer.put((byte)42).putFloat(f);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 40: {
                    return Float.valueOf(0.0f);
                }
                case 41: {
                    return Float.valueOf(1.0f);
                }
                case 42: {
                    return Float.valueOf(byteBuffer.getFloat());
                }
            }
            return Float.valueOf(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(byteBuffer))));
        }
    }

    static class LongType
    extends AutoDetectDataType {
        LongType(ObjectDataType objectDataType) {
            super(objectDataType, 5);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Long && object2 instanceof Long) {
                Long l = (Long)object;
                Long l2 = (Long)object2;
                return l.compareTo(l2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Long ? 30 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Long)) {
                super.write(writeBuffer, object);
                return;
            }
            long l = (Long)object;
            if (l < 0L) {
                if (-l < 0L || -l > 0x1FFFFFFFFFFFFL) {
                    writeBuffer.put((byte)36);
                    writeBuffer.putLong(l);
                } else {
                    writeBuffer.put((byte)35);
                    writeBuffer.putVarLong(-l);
                }
            } else if (l <= 7L) {
                writeBuffer.put((byte)(80L + l));
            } else if (l <= 0x1FFFFFFFFFFFFL) {
                writeBuffer.put((byte)5);
                writeBuffer.putVarLong(l);
            } else {
                writeBuffer.put((byte)36);
                writeBuffer.putLong(l);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 5: {
                    return DataUtils.readVarLong(byteBuffer);
                }
                case 35: {
                    return -DataUtils.readVarLong(byteBuffer);
                }
                case 36: {
                    return byteBuffer.getLong();
                }
            }
            return (long)(n - 80);
        }
    }

    static class IntegerType
    extends AutoDetectDataType {
        IntegerType(ObjectDataType objectDataType) {
            super(objectDataType, 4);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Integer && object2 instanceof Integer) {
                Integer n = (Integer)object;
                Integer n2 = (Integer)object2;
                return n.compareTo(n2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Integer ? 24 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Integer)) {
                super.write(writeBuffer, object);
                return;
            }
            int n = (Integer)object;
            if (n < 0) {
                if (-n < 0 || -n > 0x1FFFFF) {
                    writeBuffer.put((byte)34).putInt(n);
                } else {
                    writeBuffer.put((byte)33).putVarInt(-n);
                }
            } else if (n <= 15) {
                writeBuffer.put((byte)(64 + n));
            } else if (n <= 0x1FFFFF) {
                writeBuffer.put((byte)4).putVarInt(n);
            } else {
                writeBuffer.put((byte)34).putInt(n);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 4: {
                    return DataUtils.readVarInt(byteBuffer);
                }
                case 33: {
                    return -DataUtils.readVarInt(byteBuffer);
                }
                case 34: {
                    return byteBuffer.getInt();
                }
            }
            return n - 64;
        }
    }

    static class ShortType
    extends AutoDetectDataType {
        ShortType(ObjectDataType objectDataType) {
            super(objectDataType, 3);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Short && object2 instanceof Short) {
                Short s = (Short)object;
                Short s2 = (Short)object2;
                return s.compareTo(s2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Short ? 24 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Short)) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)3);
            writeBuffer.putShort((Short)object);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return byteBuffer.getShort();
        }
    }

    static class CharacterType
    extends AutoDetectDataType {
        CharacterType(ObjectDataType objectDataType) {
            super(objectDataType, 10);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Character && object2 instanceof Character) {
                Character c = (Character)object;
                Character c2 = (Character)object2;
                return c.compareTo(c2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Character ? 24 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Character)) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)10);
            writeBuffer.putChar(((Character)object).charValue());
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return Character.valueOf(byteBuffer.getChar());
        }
    }

    static class ByteType
    extends AutoDetectDataType {
        ByteType(ObjectDataType objectDataType) {
            super(objectDataType, 2);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Byte && object2 instanceof Byte) {
                Byte by = (Byte)object;
                Byte by2 = (Byte)object2;
                return by.compareTo(by2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Byte ? 0 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Byte)) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)2);
            writeBuffer.put((Byte)object);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return byteBuffer.get();
        }
    }

    static class BooleanType
    extends AutoDetectDataType {
        BooleanType(ObjectDataType objectDataType) {
            super(objectDataType, 1);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                Boolean bl = (Boolean)object;
                Boolean bl2 = (Boolean)object2;
                return bl.compareTo(bl2);
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object instanceof Boolean ? 0 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (!(object instanceof Boolean)) {
                super.write(writeBuffer, object);
                return;
            }
            int n = (Boolean)object != false ? 32 : 1;
            writeBuffer.put((byte)n);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return n == 1 ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    static class NullType
    extends AutoDetectDataType {
        NullType(ObjectDataType objectDataType) {
            super(objectDataType, 0);
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return super.compare(object, object2);
        }

        @Override
        public int getMemory(Object object) {
            return object == null ? 0 : super.getMemory(object);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (object != null) {
                super.write(writeBuffer, object);
                return;
            }
            writeBuffer.put((byte)0);
        }

        @Override
        public Object read(ByteBuffer byteBuffer, int n) {
            return null;
        }
    }

    static abstract class AutoDetectDataType
    implements DataType {
        protected final ObjectDataType base;
        protected final int typeId;

        AutoDetectDataType(ObjectDataType objectDataType, int n) {
            this.base = objectDataType;
            this.typeId = n;
        }

        @Override
        public int getMemory(Object object) {
            return this.getType(object).getMemory(object);
        }

        @Override
        public int compare(Object object, Object object2) {
            AutoDetectDataType autoDetectDataType = this.getType(object);
            AutoDetectDataType autoDetectDataType2 = this.getType(object2);
            int n = autoDetectDataType.typeId - autoDetectDataType2.typeId;
            if (n == 0) {
                return autoDetectDataType.compare(object, object2);
            }
            return Integer.signum(n);
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < n; ++i) {
                this.write(writeBuffer, objectArray[i]);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            this.getType(object).write(writeBuffer, object);
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }

        @Override
        public final Object read(ByteBuffer byteBuffer) {
            throw DataUtils.newIllegalStateException(3, "Internal error", new Object[0]);
        }

        AutoDetectDataType getType(Object object) {
            return this.base.switchType(object);
        }

        abstract Object read(ByteBuffer var1, int var2);
    }
}

