/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.mvstore.tx;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.h14199.mvstore.Cursor;
import org.h14199.mvstore.DataUtils;
import org.h14199.mvstore.MVMap;
import org.h14199.mvstore.Page;
import org.h14199.mvstore.RootReference;
import org.h14199.mvstore.tx.Transaction;
import org.h14199.mvstore.tx.TransactionStore;
import org.h14199.mvstore.tx.TxDecisionMaker;
import org.h14199.mvstore.tx.VersionedValueCommitted;
import org.h14199.mvstore.tx.VersionedValueUncommitted;
import org.h14199.mvstore.type.DataType;
import org.h14199.value.VersionedValue;

public class TransactionMap<K, V>
extends AbstractMap<K, V> {
    public final MVMap<K, VersionedValue> map;
    private final Transaction transaction;

    TransactionMap(Transaction transaction, MVMap<K, VersionedValue> mVMap) {
        this.transaction = transaction;
        this.map = mVMap;
    }

    public TransactionMap<K, V> getInstance(Transaction transaction) {
        return new TransactionMap<K, V>(transaction, this.map);
    }

    @Override
    public final int size() {
        long l = this.sizeAsLong();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public long sizeAsLongMax() {
        return this.map.sizeAsLong();
    }

    public long sizeAsLong() {
        Object object;
        long l;
        RootReference[] rootReferenceArray;
        Cloneable cloneable;
        RootReference rootReference;
        BitSet bitSet;
        TransactionStore transactionStore = this.transaction.store;
        do {
            bitSet = transactionStore.committingTransactions.get();
            rootReference = this.map.flushAndGetRoot();
            cloneable = transactionStore.openTransactions.get();
            rootReferenceArray = new RootReference[cloneable.length()];
            l = 0L;
            int n = cloneable.nextSetBit(0);
            while (n >= 0) {
                MVMap<Long, Object[]> mVMap = transactionStore.undoLogs[n];
                if (mVMap != null) {
                    object = mVMap.flushAndGetRoot();
                    rootReferenceArray[n] = object;
                    l += ((RootReference)object).getTotalCount();
                }
                n = cloneable.nextSetBit(n + 1);
            }
        } while (bitSet != transactionStore.committingTransactions.get() || rootReference != this.map.getRoot());
        cloneable = rootReference.root;
        long l2 = rootReference.getTotalCount();
        if (l == 0L) {
            return l2;
        }
        if (2L * l > l2) {
            object = new Cursor((Page)cloneable, null);
            while (((Cursor)object).hasNext()) {
                int n;
                boolean bl;
                Object object2;
                ((Cursor)object).next();
                VersionedValue versionedValue = (VersionedValue)((Cursor)object).getValue();
                assert (versionedValue != null);
                long l3 = versionedValue.getOperationId();
                if (l3 == 0L || (object2 = (bl = (n = TransactionStore.getTransactionId(l3)) == this.transaction.transactionId || bitSet.get(n)) ? versionedValue.getCurrentValue() : versionedValue.getCommittedValue()) != null) continue;
                --l2;
            }
        } else {
            for (RootReference rootReference2 : rootReferenceArray) {
                if (rootReference2 == null) continue;
                Cursor cursor = new Cursor(rootReference2.root, null);
                while (cursor.hasNext()) {
                    int n;
                    boolean bl;
                    Object object3;
                    VersionedValue versionedValue;
                    cursor.next();
                    Object[] objectArray = (Object[])cursor.getValue();
                    if (((Integer)objectArray[0]).intValue() != this.map.getId() || (versionedValue = this.map.get((Page)cloneable, objectArray[1])) == null) continue;
                    long l4 = cursor.getKey();
                    if (versionedValue.getOperationId() != l4 || (object3 = (bl = (n = TransactionStore.getTransactionId(l4)) == this.transaction.transactionId || bitSet.get(n)) ? versionedValue.getCurrentValue() : versionedValue.getCommittedValue()) != null) continue;
                    --l2;
                }
            }
        }
        return l2;
    }

    @Override
    public V remove(Object object) {
        return this.set(object, (V)null);
    }

    @Override
    public V put(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        return this.set(k, v);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        TxDecisionMaker.PutIfAbsentDecisionMaker putIfAbsentDecisionMaker = new TxDecisionMaker.PutIfAbsentDecisionMaker(this.map.getId(), k, v, this.transaction);
        return this.set((Object)k, putIfAbsentDecisionMaker);
    }

    public void append(K k, V v) {
        this.map.append(k, VersionedValueUncommitted.getInstance(this.transaction.log(this.map.getId(), k, null), v, null));
    }

    public V lock(K k) {
        TxDecisionMaker.LockDecisionMaker lockDecisionMaker = new TxDecisionMaker.LockDecisionMaker(this.map.getId(), k, this.transaction);
        return this.set((Object)k, lockDecisionMaker);
    }

    public V putCommitted(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        VersionedValue versionedValue = VersionedValueCommitted.getInstance(v);
        VersionedValue versionedValue2 = this.map.put(k, versionedValue);
        Object object = versionedValue2 == null ? null : versionedValue2.getCurrentValue();
        return (V)object;
    }

    private V set(Object object, V v) {
        TxDecisionMaker.PutDecisionMaker putDecisionMaker = new TxDecisionMaker.PutDecisionMaker(this.map.getId(), object, v, this.transaction);
        return this.set(object, putDecisionMaker);
    }

    private V set(Object object, TxDecisionMaker txDecisionMaker) {
        VersionedValue versionedValue;
        long l;
        Transaction transaction;
        TransactionStore transactionStore = this.transaction.store;
        do {
            l = transactionStore.openTransactions.get().getVersion();
            assert (this.transaction.getBlockerId() == 0);
            Object object2 = object;
            versionedValue = this.map.operate(object2, VersionedValue.DUMMY, txDecisionMaker);
            MVMap.Decision decision = txDecisionMaker.getDecision();
            assert (decision != null);
            assert (decision != MVMap.Decision.REPEAT);
            transaction = txDecisionMaker.getBlockingTransaction();
            if (decision != MVMap.Decision.ABORT || transaction == null) {
                Object object3 = versionedValue == null ? null : versionedValue.getCurrentValue();
                return (V)object3;
            }
            txDecisionMaker.reset();
        } while (transaction.sequenceNum > l || this.transaction.waitFor(transaction, this.map, object));
        throw DataUtils.newIllegalStateException(101, "Map entry <{0}> with key <{1}> and value {2} is locked by tx {3} and can not be updated by tx {4} within allocated time interval {5} ms.", this.map.getName(), object, versionedValue, transaction.transactionId, this.transaction.transactionId, this.transaction.timeoutMillis);
    }

    public boolean tryRemove(K k) {
        return this.trySet(k, null);
    }

    public boolean tryPut(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        return this.trySet(k, v);
    }

    public boolean trySet(K k, V v) {
        try {
            this.set(k, v);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    @Override
    public V get(Object object) {
        VersionedValue versionedValue = this.map.get(object);
        if (versionedValue == null) {
            return null;
        }
        long l = versionedValue.getOperationId();
        if (l == 0L) {
            return (V)versionedValue.getCurrentValue();
        }
        int n = TransactionStore.getTransactionId(l);
        if (n == this.transaction.transactionId || this.transaction.store.committingTransactions.get().get(n)) {
            return (V)versionedValue.getCurrentValue();
        }
        return (V)versionedValue.getCommittedValue();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean isSameTransaction(K k) {
        VersionedValue versionedValue = this.map.get(k);
        if (versionedValue == null) {
            return false;
        }
        int n = TransactionStore.getTransactionId(versionedValue.getOperationId());
        return n == this.transaction.transactionId;
    }

    public boolean isClosed() {
        return this.map.isClosed();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return TransactionMap.this.entryIterator(null, null);
            }

            @Override
            public int size() {
                return TransactionMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return TransactionMap.this.containsKey(object);
            }
        };
    }

    public K firstKey() {
        Iterator<Object> iterator = this.keyIterator(null);
        return (K)(iterator.hasNext() ? iterator.next() : null);
    }

    public K lastKey() {
        K k = this.map.lastKey();
        while (k != null && this.get(k) == null) {
            k = this.map.lowerKey(k);
        }
        return k;
    }

    public K higherKey(K k) {
        while ((k = this.map.higherKey(k)) != null && this.get(k) == null) {
        }
        return k;
    }

    public K ceilingKey(K k) {
        Iterator<K> iterator = this.keyIterator(k);
        return iterator.hasNext() ? (K)iterator.next() : null;
    }

    public K floorKey(K k) {
        k = this.map.floorKey(k);
        while (k != null && this.get(k) == null) {
            k = this.map.lowerKey(k);
        }
        return k;
    }

    public K lowerKey(K k) {
        while ((k = this.map.lowerKey(k)) != null && this.get(k) == null) {
        }
        return k;
    }

    public Iterator<K> keyIterator(K k) {
        return this.keyIterator(k, null, false);
    }

    public Iterator<K> keyIterator(K k, K k2, boolean bl) {
        return new KeyIterator<K>(this, k, k2, bl);
    }

    public Iterator<Map.Entry<K, V>> entryIterator(K k, K k2) {
        return new EntryIterator(this, k, k2);
    }

    public Iterator<K> wrapIterator(final Iterator<K> iterator, final boolean bl) {
        return new Iterator<K>(){
            private K current;
            {
                this.fetchNext();
            }

            private void fetchNext() {
                while (iterator.hasNext()) {
                    this.current = iterator.next();
                    if (bl) {
                        return;
                    }
                    if (!TransactionMap.this.containsKey(this.current)) continue;
                    return;
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public K next() {
                Object k = this.current;
                this.fetchNext();
                return k;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("Removal is not supported");
            }
        };
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public DataType getKeyType() {
        return this.map.getKeyType();
    }

    private static abstract class TMIterator<K, X>
    implements Iterator<X> {
        private final int transactionId;
        private final BitSet committingTransactions;
        private final Cursor<K, VersionedValue> cursor;
        private final boolean includeAllUncommitted;
        private X current;

        TMIterator(TransactionMap<K, ?> transactionMap, K k, K k2, boolean bl) {
            RootReference rootReference;
            BitSet bitSet;
            Transaction transaction = transactionMap.getTransaction();
            this.transactionId = transaction.transactionId;
            TransactionStore transactionStore = transaction.store;
            MVMap mVMap = transactionMap.map;
            do {
                bitSet = transactionStore.committingTransactions.get();
                rootReference = mVMap.flushAndGetRoot();
            } while (bitSet != transactionStore.committingTransactions.get());
            this.cursor = new Cursor(rootReference.root, k, k2);
            this.committingTransactions = bitSet;
            this.includeAllUncommitted = bl;
            this.fetchNext();
        }

        protected abstract X registerCurrent(K var1, VersionedValue var2);

        private void fetchNext() {
            while (this.cursor.hasNext()) {
                int n;
                long l;
                K k = this.cursor.next();
                VersionedValue versionedValue = this.cursor.getValue();
                if (!this.includeAllUncommitted && versionedValue != null && (l = versionedValue.getOperationId()) != 0L && (n = TransactionStore.getTransactionId(l)) != this.transactionId && !this.committingTransactions.get(n)) {
                    Object object = versionedValue.getCommittedValue();
                    VersionedValue versionedValue2 = versionedValue = object == null ? null : VersionedValueCommitted.getInstance(object);
                }
                if (versionedValue == null || versionedValue.getCurrentValue() == null && (!this.includeAllUncommitted || this.transactionId == TransactionStore.getTransactionId(versionedValue.getOperationId()))) continue;
                this.current = this.registerCurrent(k, versionedValue);
                return;
            }
            this.current = null;
        }

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        @Override
        public final X next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            X x = this.current;
            this.fetchNext();
            return x;
        }

        @Override
        public final void remove() {
            throw DataUtils.newUnsupportedOperationException("Removal is not supported");
        }
    }

    private static final class EntryIterator<K, V>
    extends TMIterator<K, Map.Entry<K, V>> {
        public EntryIterator(TransactionMap<K, ?> transactionMap, K k, K k2) {
            super(transactionMap, k, k2, false);
        }

        @Override
        protected Map.Entry<K, V> registerCurrent(K k, VersionedValue versionedValue) {
            return new AbstractMap.SimpleImmutableEntry<K, Object>(k, versionedValue.getCurrentValue());
        }
    }

    private static final class KeyIterator<K>
    extends TMIterator<K, K> {
        public KeyIterator(TransactionMap<K, ?> transactionMap, K k, K k2, boolean bl) {
            super(transactionMap, k, k2, bl);
        }

        @Override
        protected K registerCurrent(K k, VersionedValue versionedValue) {
            return k;
        }
    }
}

