/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.mvstore.db;

import java.util.List;
import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.engine.Session;
import org.h14199.index.BaseIndex;
import org.h14199.index.Cursor;
import org.h14199.index.IndexType;
import org.h14199.message.DbException;
import org.h14199.mvstore.db.MVIndex;
import org.h14199.mvstore.db.MVPrimaryIndex;
import org.h14199.mvstore.db.MVTable;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.Column;
import org.h14199.table.IndexColumn;
import org.h14199.table.TableFilter;
import org.h14199.value.ValueLong;

public class MVDelegateIndex
extends BaseIndex
implements MVIndex {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable mVTable, int n, String string, MVPrimaryIndex mVPrimaryIndex, IndexType indexType) {
        super(mVTable, n, string, IndexColumn.wrap(new Column[]{mVTable.getColumn(mVPrimaryIndex.getMainIndexColumn())}), indexType);
        this.mainIndex = mVPrimaryIndex;
        if (n < 0) {
            throw DbException.throwInternalError(string);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw DbException.throwInternalError();
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.mainIndex.getRow(session, l);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        ValueLong valueLong = this.mainIndex.getKey(searchRow, ValueLong.MIN, ValueLong.MIN);
        ValueLong valueLong2 = this.mainIndex.getKey(searchRow2, ValueLong.MAX, ValueLong.MIN);
        return this.mainIndex.find(session, valueLong, valueLong2);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        return this.mainIndex.findFirstOrLast(session, bl);
    }

    @Override
    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.getColumnIndex(column) == 0;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCountApproximation(), tableFilterArray, n, sortOrder, true, allColumnsForPlan);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void update(Session session, Row row, Row row2) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

