/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.mode;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ValueExpression;
import org.h14199.expression.function.Function;
import org.h14199.expression.function.FunctionInfo;
import org.h14199.message.DbException;
import org.h14199.mode.FunctionsBase;
import org.h14199.util.StringUtils;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueInt;
import org.h14199.value.ValueNull;
import org.h14199.value.ValueString;

public class FunctionsMySQL
extends FunctionsBase {
    private static final int UNIX_TIMESTAMP = 1001;
    private static final int FROM_UNIXTIME = 1002;
    private static final int DATE = 1003;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE;

    public static int unixTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int unixTimestamp(Timestamp timestamp) {
        return (int)(timestamp.getTime() / 1000L);
    }

    public static String fromUnixTime(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    public static String fromUnixTime(int n, String string) {
        string = FunctionsMySQL.convertToSimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    private static String convertToSimpleDateFormat(String string) {
        String[] stringArray = FORMAT_REPLACE;
        for (int i = 0; i < stringArray.length; i += 2) {
            string = StringUtils.replaceAll(string, stringArray[i], stringArray[i + 1]);
        }
        return string;
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo = FUNCTIONS.get(string);
        return functionInfo != null ? new FunctionsMySQL(database, functionInfo) : null;
    }

    FunctionsMySQL(Database database, FunctionInfo functionInfo) {
        super(database, functionInfo);
    }

    @Override
    protected void checkParameterCount(int n) {
        int n2;
        int n3;
        switch (this.info.type) {
            case 1001: {
                n3 = 0;
                n2 = 2;
                break;
            }
            case 1002: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 1003: {
                n3 = 1;
                n2 = 1;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
                return;
            }
        }
        if (n < n3 || n > n2) {
            throw DbException.get(7001, this.info.name, n3 + ".." + n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean bl = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            this.args[i] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
        return this;
    }

    @Override
    protected Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Value value;
        Value[] valueArray = new Value[expressionArray.length];
        Value value2 = FunctionsMySQL.getNullOrValue(session, expressionArray, valueArray, 0);
        Value value3 = FunctionsMySQL.getNullOrValue(session, expressionArray, valueArray, 1);
        block1 : switch (this.info.type) {
            case 1001: {
                value = ValueInt.get(value2 == null ? FunctionsMySQL.unixTimestamp() : FunctionsMySQL.unixTimestamp(value2.getTimestamp()));
                break;
            }
            case 1002: {
                value = ValueString.get(value3 == null ? FunctionsMySQL.fromUnixTime(value2.getInt()) : FunctionsMySQL.fromUnixTime(value2.getInt(), value3.getString()));
                break;
            }
            case 1003: {
                switch (value2.getValueType()) {
                    case 10: {
                        value = value2;
                        break block1;
                    }
                    default: {
                        try {
                            value2 = value2.convertTo(11);
                            break;
                        }
                        catch (DbException dbException) {
                            value2 = ValueNull.INSTANCE;
                        }
                    }
                    case 11: 
                    case 24: 
                }
                value = value2.convertTo(10);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    static {
        FUNCTIONS.put("UNIX_TIMESTAMP", new FunctionInfo("UNIX_TIMESTAMP", 1001, -1, 4, false, false, false, true));
        FUNCTIONS.put("FROM_UNIXTIME", new FunctionInfo("FROM_UNIXTIME", 1002, -1, 13, false, true, false, true));
        FUNCTIONS.put("DATE", new FunctionInfo("DATE", 1003, 1, 10, false, true, false, true));
        FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};
    }
}

