/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.engine.Session;
import org.h14199.index.BaseIndex;
import org.h14199.index.Cursor;
import org.h14199.index.IndexType;
import org.h14199.index.RangeCursor;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.IndexColumn;
import org.h14199.table.RangeTable;
import org.h14199.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        super(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.rangeTable = rangeTable;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = this.rangeTable.getMin(session);
        long l3 = this.rangeTable.getMax(session);
        long l4 = this.rangeTable.getStep(session);
        if (searchRow != null) {
            try {
                l = searchRow.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l > l2) {
                        l2 += (l - l2 + l4 - 1L) / l4 * l4;
                    }
                } else if (l > l3) {
                    l3 = l;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        if (searchRow2 != null) {
            try {
                l = searchRow2.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l < l3) {
                        l3 = l;
                    }
                } else if (l < l2) {
                    l2 -= (l2 - l - l4 - 1L) / l4 * l4;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return new RangeCursor(session, l2, l3, l4);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        long l = bl ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, l, l);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

