/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import java.util.Arrays;
import org.h14199.engine.Session;
import org.h14199.engine.SysProperties;
import org.h14199.index.Cursor;
import org.h14199.index.PageData;
import org.h14199.index.PageDataIndex;
import org.h14199.index.PageDataLeaf;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.store.Data;
import org.h14199.store.Page;
import org.h14199.store.PageStore;
import org.h14199.util.Utils;

public class PageDataNode
extends PageData {
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;
    private int length;

    private PageDataNode(PageDataIndex pageDataIndex, int n, Data data) {
        super(pageDataIndex, n, data);
    }

    static PageDataNode create(PageDataIndex pageDataIndex, int n, int n2) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataNode, null);
        pageDataNode.parentPageId = n2;
        pageDataNode.writeHead();
        pageDataNode.length = pageDataNode.data.length() + 4;
        return pageDataNode;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n) {
        PageDataNode pageDataNode = new PageDataNode(pageDataIndex, n, data);
        pageDataNode.read();
        return pageDataNode;
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n = this.data.readVarInt();
        if (n != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n);
        }
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.keys = Utils.newLongArray(this.entryCount);
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.keys[i] = this.data.readVarLong();
        }
        this.length = this.data.length();
        this.check();
        this.written = true;
    }

    private void addChild(int n, int n2, long l) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.childPageIds = PageDataNode.insert(this.childPageIds, this.entryCount + 1, n + 1, n2);
        this.keys = PageDataNode.insert(this.keys, this.entryCount, n, l);
        ++this.entryCount;
        this.length += 4 + Data.getVarLongLen(l);
    }

    @Override
    int addRowTry(Row row) {
        int n;
        PageData pageData;
        int n2;
        this.index.getPageStore().logUndo(this, this.data);
        int n3 = 4 + Data.getVarLongLen(row.getKey());
        while ((n2 = (pageData = this.index.getPage(this.childPageIds[n = this.find(row.getKey())], this.getPos())).addRowTry(row)) != -1) {
            if (this.length + n3 > this.index.getPageStore().getPageSize()) {
                return this.entryCount / 2;
            }
            long l = n2 == 0 ? row.getKey() : pageData.getKey(n2 - 1);
            PageData pageData2 = pageData.split(n2);
            this.index.getPageStore().update(pageData);
            this.index.getPageStore().update(pageData2);
            this.addChild(n, pageData2.getPos(), l);
            this.index.getPageStore().update(this);
        }
        this.updateRowCount(1);
        return -1;
    }

    private void updateRowCount(int n) {
        if (this.rowCount != -1) {
            this.rowCount += n;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    @Override
    Cursor find(Session session, long l, long l2) {
        int n = this.find(l);
        int n2 = this.childPageIds[n];
        return this.index.getPage(n2, this.getPos()).find(session, l, l2);
    }

    @Override
    PageData split(int n) {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataNode pageDataNode = PageDataNode.create(this.index, n2, this.parentPageId);
        int n3 = this.childPageIds[n];
        while (n < this.entryCount) {
            pageDataNode.addChild(pageDataNode.entryCount, this.childPageIds[n + 1], this.keys[n]);
            this.removeChild(n);
        }
        int n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        pageDataNode.childPageIds[0] = n3;
        pageDataNode.remapChildren(this.getPos());
        return pageDataNode;
    }

    @Override
    protected void remapChildren(int n) {
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n2 = this.childPageIds[i];
            PageData pageData = this.index.getPage(n2, n);
            pageData.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageData);
        }
    }

    void init(PageData pageData, long l, PageData pageData2) {
        this.entryCount = 1;
        this.childPageIds = new int[]{pageData.getPos(), pageData2.getPos()};
        this.keys = new long[]{l};
        this.length += 4 + Data.getVarLongLen(l);
        this.check();
    }

    @Override
    long getLastKey() {
        return this.index.getPage(this.childPageIds[this.entryCount], this.getPos()).getLastKey();
    }

    PageDataLeaf getNextPage(long l) {
        int n = this.find(l) + 1;
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return null;
            }
            PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
            return pageDataNode.getNextPage(l);
        }
        PageData pageData = this.index.getPage(this.childPageIds[n], this.getPos());
        return pageData.getFirstLeaf();
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        int n = this.childPageIds[0];
        return this.index.getPage(n, this.getPos()).getFirstLeaf();
    }

    @Override
    boolean remove(long l) {
        int n = this.find(l);
        PageData pageData = this.index.getPage(this.childPageIds[n], this.getPos());
        boolean bl = pageData.remove(l);
        this.index.getPageStore().logUndo(this, this.data);
        this.updateRowCount(-1);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().free(pageData.getPos());
        if (this.entryCount < 1) {
            return true;
        }
        this.removeChild(n);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n = this.childPageIds[i];
            this.index.getPage(n, this.getPos()).freeRecursive();
        }
    }

    @Override
    Row getRowWithKey(long l) {
        int n = this.find(l);
        PageData pageData = this.index.getPage(this.childPageIds[n], this.getPos());
        return pageData.getRowWithKey(l);
    }

    @Override
    int getRowCount() {
        if (this.rowCount == -1) {
            int n = 0;
            for (int i = 0; i < this.entryCount + 1; ++i) {
                int n2 = this.childPageIds[i];
                PageData pageData = this.index.getPage(n2, this.getPos());
                if (this.getPos() == pageData.getPos()) {
                    throw DbException.throwInternalError("Page is its own child: " + this.getPos());
                }
                this.index.getDatabase().setProgress(0, this.index.getTable() + "." + this.index.getName(), n += pageData.getRowCount(), Integer.MAX_VALUE);
            }
            this.rowCount = n;
        }
        return this.rowCount;
    }

    @Override
    long getDiskSpaceUsed() {
        long l = 0L;
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n = this.childPageIds[i];
            PageData pageData = this.index.getPage(n, this.getPos());
            if (this.getPos() == pageData.getPos()) {
                throw DbException.throwInternalError("Page is its own child: " + this.getPos());
            }
            this.index.getDatabase().setProgress(0, this.index.getTable() + "." + this.index.getName(), (int)((l += pageData.getDiskSpaceUsed()) >> 16), Integer.MAX_VALUE);
        }
        return l;
    }

    @Override
    void setRowCountStored(int n) {
        this.rowCount = n;
        if (this.rowCountStored != n) {
            this.rowCountStored = n;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void check() {
        if (SysProperties.CHECK) {
            for (int i = 0; i < this.entryCount + 1; ++i) {
                int n = this.childPageIds[i];
                if (n != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)2);
        this.data.writeShortInt(0);
        assert (this.data.length() == 3);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.rowCountStored);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        if (this.written) {
            return;
        }
        this.check();
        this.writeHead();
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (int i = 0; i < this.entryCount; ++i) {
            this.data.writeInt(this.childPageIds[i]);
            this.data.writeVarLong(this.keys[i]);
        }
        if (this.length != this.data.length()) {
            DbException.throwInternalError("expected pos: " + this.length + " got: " + this.data.length());
        }
        this.written = true;
    }

    private void removeChild(int n) {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        int n2 = n < this.entryCount ? n : n - 1;
        --this.entryCount;
        this.length -= 4 + Data.getVarLongLen(this.keys[n2]);
        if (this.entryCount < 0) {
            DbException.throwInternalError(Integer.toString(this.entryCount));
        }
        this.keys = PageDataNode.remove(this.keys, this.entryCount + 1, n2);
        this.childPageIds = PageDataNode.remove(this.childPageIds, this.entryCount + 2, n);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data node table:" + this.index.getId() + " entries:" + this.entryCount + " " + Arrays.toString(this.childPageIds);
    }

    @Override
    public void moveTo(Session session, int n) {
        PageStore pageStore = this.index.getPageStore();
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n2 = this.childPageIds[i];
            pageStore.getPage(n2);
        }
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataNode pageDataNode = PageDataNode.create(this.index, n, this.parentPageId);
        pageDataNode.rowCountStored = this.rowCountStored;
        pageDataNode.rowCount = this.rowCount;
        pageDataNode.childPageIds = this.childPageIds;
        pageDataNode.keys = this.keys;
        pageDataNode.entryCount = this.entryCount;
        pageDataNode.length = this.length;
        pageStore.update(pageDataNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageDataNode pageDataNode2 = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode2.moveChild(this.getPos(), n);
        }
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n3 = this.childPageIds[i];
            PageData pageData = (PageData)pageStore.getPage(n3);
            pageData.setParentPageId(n);
            pageStore.update(pageData);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n, int n2) {
        for (int i = 0; i < this.entryCount + 1; ++i) {
            if (this.childPageIds[i] != n) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.childPageIds[i] = n2;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError(n + " " + n2);
    }
}

