/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import org.h14199.index.Cursor;
import org.h14199.index.PageDataLeaf;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;

class PageDataCursor
implements Cursor {
    private PageDataLeaf current;
    private int idx;
    private final long maxKey;
    private Row row;

    PageDataCursor(PageDataLeaf pageDataLeaf, int n, long l) {
        this.current = pageDataLeaf;
        this.idx = n;
        this.maxKey = l;
    }

    @Override
    public Row get() {
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        this.nextRow();
        return this.checkMax();
    }

    private boolean checkMax() {
        if (this.row != null) {
            long l;
            if (this.maxKey != Long.MAX_VALUE && (l = this.current.index.getKey(this.row, Long.MAX_VALUE, Long.MAX_VALUE)) > this.maxKey) {
                this.row = null;
                return false;
            }
            return true;
        }
        return false;
    }

    private void nextRow() {
        if (this.idx >= this.current.getEntryCount()) {
            this.current = this.current.getNextPage();
            this.idx = 0;
            if (this.current == null) {
                this.row = null;
                return;
            }
        }
        this.row = this.current.getRowAt(this.idx);
        ++this.idx;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

