/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.engine.Session;
import org.h14199.index.BaseIndex;
import org.h14199.index.Cursor;
import org.h14199.index.IndexType;
import org.h14199.index.NonUniqueHashCursor;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.Column;
import org.h14199.table.IndexColumn;
import org.h14199.table.PageStoreTable;
import org.h14199.table.TableFilter;
import org.h14199.util.Utils;
import org.h14199.value.DataType;
import org.h14199.value.Value;

public class NonUniqueHashIndex
extends BaseIndex {
    private final int indexColumn;
    private final boolean totalOrdering;
    private Map<Value, ArrayList<Long>> rows;
    private final PageStoreTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(PageStoreTable pageStoreTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(pageStoreTable, n, string, indexColumnArray, indexType);
        Column column = indexColumnArray[0].column;
        this.indexColumn = column.getColumnId();
        this.totalOrdering = DataType.hasTotalOrdering(column.getType().getValueType());
        this.tableData = pageStoreTable;
        this.reset();
    }

    private void reset() {
        this.rows = this.totalOrdering ? new HashMap() : new TreeMap(this.database.getCompareMode());
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        ArrayList<Long> arrayList = this.rows.get(value);
        if (arrayList == null) {
            arrayList = Utils.newSmallArrayList();
            this.rows.put(value, arrayList);
        }
        arrayList.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value value = row.getValue(this.indexColumn);
            ArrayList<Long> arrayList = this.rows.get(value);
            if (arrayList.size() == 1) {
                this.rows.remove(value);
            } else {
                arrayList.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError(searchRow + " " + searchRow2);
        }
        if (searchRow != searchRow2 && this.compareKeys(searchRow, searchRow2) != 0) {
            throw DbException.throwInternalError();
        }
        Value value = searchRow.getValue(this.indexColumn);
        value = value.convertTo(this.tableData.getColumn(this.indexColumn).getType(), this.database.getMode(), null);
        ArrayList<Long> arrayList = this.rows.get(value);
        return new NonUniqueHashCursor(session, this.tableData, arrayList);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

