/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression.function;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h14199.command.Command;
import org.h14199.command.Parser;
import org.h14199.engine.Constants;
import org.h14199.engine.Database;
import org.h14199.engine.Mode;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionColumn;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.expression.SequenceValue;
import org.h14199.expression.ValueExpression;
import org.h14199.expression.Variable;
import org.h14199.expression.function.DateTimeFunctions;
import org.h14199.expression.function.FunctionCall;
import org.h14199.expression.function.FunctionInfo;
import org.h14199.expression.function.TableFunction;
import org.h14199.expression.function.ToChar;
import org.h14199.expression.function.ToDateParser;
import org.h14199.index.Index;
import org.h14199.jdbc.JdbcConnection;
import org.h14199.message.DbException;
import org.h14199.mode.FunctionsMSSQLServer;
import org.h14199.mode.FunctionsMySQL;
import org.h14199.mvstore.db.MVSpatialIndex;
import org.h14199.schema.Schema;
import org.h14199.schema.Sequence;
import org.h14199.security.BlockCipher;
import org.h14199.security.CipherFactory;
import org.h14199.store.fs.FileUtils;
import org.h14199.table.Column;
import org.h14199.table.ColumnResolver;
import org.h14199.table.LinkSchema;
import org.h14199.table.Table;
import org.h14199.table.TableFilter;
import org.h14199.tools.CompressTool;
import org.h14199.tools.Csv;
import org.h14199.util.Bits;
import org.h14199.util.DateTimeUtils;
import org.h14199.util.IOUtils;
import org.h14199.util.JdbcUtils;
import org.h14199.util.MathUtils;
import org.h14199.util.StringUtils;
import org.h14199.util.Utils;
import org.h14199.value.DataType;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueArray;
import org.h14199.value.ValueBoolean;
import org.h14199.value.ValueBytes;
import org.h14199.value.ValueCollectionBase;
import org.h14199.value.ValueDate;
import org.h14199.value.ValueDouble;
import org.h14199.value.ValueInt;
import org.h14199.value.ValueLong;
import org.h14199.value.ValueNull;
import org.h14199.value.ValueResultSet;
import org.h14199.value.ValueString;
import org.h14199.value.ValueTime;
import org.h14199.value.ValueTimestamp;
import org.h14199.value.ValueTimestampTimeZone;
import org.h14199.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ORA_HASH = 41;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURRENT_DATE = 100;
    public static final int CURRENT_TIME = 101;
    public static final int LOCALTIME = 102;
    public static final int CURRENT_TIMESTAMP = 103;
    public static final int LOCALTIMESTAMP = 104;
    public static final int DATE_ADD = 105;
    public static final int DATE_DIFF = 106;
    public static final int DAY_NAME = 107;
    public static final int DAY_OF_MONTH = 108;
    public static final int DAY_OF_WEEK = 109;
    public static final int DAY_OF_YEAR = 110;
    public static final int HOUR = 111;
    public static final int MINUTE = 112;
    public static final int MONTH = 113;
    public static final int MONTH_NAME = 114;
    public static final int QUARTER = 115;
    public static final int SECOND = 116;
    public static final int WEEK = 117;
    public static final int YEAR = 118;
    public static final int EXTRACT = 119;
    public static final int FORMATDATETIME = 120;
    public static final int PARSEDATETIME = 121;
    public static final int ISO_YEAR = 122;
    public static final int ISO_WEEK = 123;
    public static final int ISO_DAY_OF_WEEK = 124;
    public static final int DATE_TRUNC = 125;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int DECADE = 132;
    public static final int CENTURY = 133;
    public static final int MILLENNIUM = 134;
    public static final int DOW = 135;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    public static final int ESTIMATED_ENVELOPE = 161;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int UNNEST = 233;
    public static final int ARRAY_CONCAT = 234;
    public static final int ARRAY_APPEND = 235;
    public static final int ARRAY_SLICE = 236;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int TRIM_LEADING = 1;
    public static final int TRIM_TRAILING = 2;
    protected static final int VAR_ARGS = -1;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap(256);
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    protected final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int flags;
    protected TypeInfo type;
    private final Database database;

    public Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = Utils.newSmallArrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FUNCTIONS.put(string, new FunctionInfo(string, n, n2, n3, bl, bl2, bl3, bl4));
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunctionNotDeterministic(string, n, n2, n3, true);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3, boolean bl) {
        Function.addFunction(string, n, n2, n3, true, false, true, bl);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true, true, true);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true, true, true);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = FUNCTIONS.get(string)) == null) {
            switch (database.getMode().getEnum()) {
                case MSSQLServer: {
                    return FunctionsMSSQLServer.getFunction(database, string);
                }
                case MySQL: {
                    return FunctionsMySQL.getFunction(database, string);
                }
            }
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: 
            case 233: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS.get(string);
    }

    public void setParameter(int n, Expression expression) {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n >= this.args.length) {
                throw DbException.get(7001, this.info.name, Integer.toString(this.args.length));
            }
            this.args[n] = expression;
        }
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        block112: {
            int n;
            int n2;
            switch (this.info.type) {
                case 0: {
                    return value.getSignum() >= 0 ? value : value.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(value.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(value.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(value.getDouble()));
                }
                case 8: {
                    return ValueDouble.get(Math.ceil(value.getDouble()));
                }
                case 9: {
                    return ValueDouble.get(Math.cos(value.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(value.getDouble()));
                }
                case 10: {
                    double d = Math.tan(value.getDouble());
                    if (d != 0.0) return ValueDouble.get(1.0 / d);
                    throw DbException.get(22012, this.getSQL(false));
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(value.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(value.getDouble()));
                }
                case 13: {
                    return ValueDouble.get(Math.floor(value.getDouble()));
                }
                case 39: {
                    return ValueDouble.get(Math.log(value.getDouble()));
                }
                case 14: {
                    if (!this.database.getMode().logIsLogBase10) return ValueDouble.get(Math.log(value.getDouble()));
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 15: {
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(value.getDouble()));
                }
                case 20: {
                    if (value == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(value.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(value.getDouble()));
                }
                case 23: {
                    return ValueInt.get(value.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(value.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(value.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(value.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(value.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(value.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String string = value.getString();
                    if (!string.isEmpty()) return ValueInt.get(string.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(value));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)value.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(value));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(value));
                }
                case 54: 
                case 92: {
                    Value value2 = ValueNull.INSTANCE;
                    int n3 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n3 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n4 = n3;
                    while (true) {
                        if (n4 >= expressionArray.length) {
                            if (this.info.type != 92) return value2;
                            if (string == null) return value2;
                            if (value2 != ValueNull.INSTANCE) return value2;
                            return ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                        }
                        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, n4);
                        if (value3 != ValueNull.INSTANCE) {
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value3;
                            } else {
                                Object object = value3.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty((String)object)) {
                                    object = string + (String)object;
                                }
                                value2 = ValueString.get(value2.getString() + (String)object, this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++n4;
                    }
                }
                case 56: {
                    return ValueString.get(Function.hexToRaw(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 59: 
                case 75: {
                    return ValueString.get(value.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 71: {
                    int n5 = Math.max(0, value.getInt());
                    char[] cArray = new char[n5];
                    int n6 = n5 - 1;
                    while (true) {
                        if (n6 < 0) {
                            return ValueString.get(new String(cArray), this.database.getMode().treatEmptyStringsAsNull);
                        }
                        cArray[n6] = 32;
                        --n6;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(value.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 81: {
                    return ValueBytes.getNoCopy(value.getString().getBytes(StandardCharsets.UTF_8));
                }
                case 82: {
                    return ValueString.get(new String(value.getBytesNoCopy(), StandardCharsets.UTF_8), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 100: {
                    return (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(10);
                }
                case 101: 
                case 102: {
                    ValueTime valueTime = (ValueTime)(this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(9);
                    return valueTime.convertScale(false, value == null ? 0 : value.getInt());
                }
                case 103: {
                    ValueTimestampTimeZone valueTimestampTimeZone = this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart();
                    return valueTimestampTimeZone.convertScale(false, value == null ? 6 : value.getInt());
                }
                case 104: {
                    Value value4 = (this.database.getMode().dateTimeValueWithinTransaction ? session.getTransactionStart() : session.getCurrentCommandStart()).convertTo(11);
                    return value4.convertScale(false, value == null ? 6 : value.getInt());
                }
                case 107: {
                    int n7 = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[n7], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 122: 
                case 123: 
                case 124: {
                    return ValueInt.get(DateTimeFunctions.getIntDatePart(value, this.info.type, this.database.getMode()));
                }
                case 114: {
                    int n8 = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[n8 - 1], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    return string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, value));
                }
                case 161: {
                    return Function.getEstimatedEnvelope(session, value, valueArray[1]);
                }
                case 202: 
                case 203: {
                    Mode mode = this.database.getMode();
                    TypeInfo typeInfo = this.type;
                    value = value.convertTo(typeInfo, mode, null);
                    value = value.convertScale(mode.convertOnlyToSmallerScale, typeInfo.getScale());
                    return value = value.convertPrecision(typeInfo.getPrecision(), false);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value value2 = value;
                    if (value != ValueNull.INSTANCE) return value2.convertTo(this.type, this.database.getMode(), null);
                    value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value2.convertTo(this.type, this.database.getMode(), null);
                }
                case 201: {
                    Value value5 = !value.getBoolean() ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value5.convertTo(this.type, this.database.getMode(), null);
                }
                case 229: {
                    int n9 = -1;
                    int n10 = expressionArray.length - 1;
                    for (int i = 1; i < n10; i += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i))) continue;
                        n9 = i + 1;
                        break;
                    }
                    if (n9 < 0 && expressionArray.length % 2 == 0) {
                        n9 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n9 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n9);
                    return valueNull.convertTo(this.type, this.database.getMode(), null);
                }
                case 228: {
                    Value value6 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value6.convertTo(this.type, this.database.getMode(), null);
                }
                case 204: {
                    Value value2 = value;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value7 != ValueNull.INSTANCE) {
                            return value7.convertTo(this.type, this.database.getMode(), null);
                        }
                        ++n11;
                    }
                    return value2;
                }
                case 219: 
                case 220: {
                    Value value2 = ValueNull.INSTANCE;
                    int n12 = 0;
                    while (n12 < expressionArray.length) {
                        Value value8 = Function.getNullOrValue(session, expressionArray, valueArray, n12);
                        if (value8 != ValueNull.INSTANCE) {
                            value8 = value8.convertTo(this.type, this.database.getMode(), null);
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value8;
                            } else {
                                int n13 = this.database.compareTypeSafe(value2, value8);
                                if (this.info.type == 219 && n13 < 0) {
                                    value2 = value8;
                                } else if (this.info.type == 220 && n13 > 0) {
                                    value2 = value8;
                                }
                            }
                        }
                        ++n12;
                    }
                    return value2;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n2 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block112;
                    int n14 = expressionArray.length - 1;
                    for (n = 1; n < n14; n += 2) {
                        Value value9 = expressionArray[n].getValue(session);
                        if (!this.database.areEqual(value, value9)) continue;
                        expression = expressionArray[n + 1];
                        break block112;
                    }
                    break block112;
                }
                case 209: {
                    Value[] valueArray2 = Function.getArray(value);
                    if (valueArray2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n15 = value10.getInt();
                    if (n15 < 1) return ValueNull.INSTANCE;
                    if (n15 > valueArray2.length) return ValueNull.INSTANCE;
                    return valueArray2[n15 - 1];
                }
                case 217: {
                    Value[] valueArray3 = Function.getArray(value);
                    if (valueArray3 == null) return ValueNull.INSTANCE;
                    return ValueInt.get(valueArray3.length);
                }
                case 230: {
                    Value value2 = ValueBoolean.FALSE;
                    Value[] valueArray4 = Function.getArray(value);
                    if (valueArray4 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value11 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4;
                    int n16 = valueArray5.length;
                    int n17 = 0;
                    while (n17 < n16) {
                        Value value12 = valueArray5[n17];
                        if (this.database.areEqual(value12, value11)) {
                            return ValueBoolean.TRUE;
                        }
                        ++n17;
                    }
                    return value2;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                default: {
                    return null;
                }
            }
            for (n = 1; n < n2; n += 2) {
                Value value13 = expressionArray[n].getValue(session);
                if (!value13.getBoolean()) continue;
                expression = expressionArray[n + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        return valueNull.convertTo(this.type, this.database.getMode(), null);
    }

    private static Value[] getArray(Value value) {
        int n = value.getValueType();
        Object object = n == 17 || n == 39 ? ((ValueCollectionBase)value).getList() : null;
        return object;
    }

    private static boolean cancelStatement(Session session, int n) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        return Function.getTable(session, value).getDiskSpaceUsed();
    }

    private static Value getEstimatedEnvelope(Session session, Value value, Value value2) {
        Table table = Function.getTable(session, value);
        Column column = table.getColumn(value2.getString());
        ArrayList<Index> arrayList = table.getIndexes();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Index index = arrayList.get(i);
                if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                return ((MVSpatialIndex)index).getEstimatedBounds(session);
            }
        }
        return ValueNull.INSTANCE;
    }

    private static Table getTable(Session session, Value value) {
        return new Parser(session).parseTableName(value.getString());
    }

    protected static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n) {
        if (n >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n];
        if (value == null) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                return null;
            }
            value = valueArray[n] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Value value;
        Value value2;
        Value value3;
        Object object;
        Value[] valueArray = new Value[expressionArray.length];
        if (this.info.nullIfParameterIsNull) {
            for (int i = 0; i < expressionArray.length; ++i) {
                object = expressionArray[i];
                value3 = ((Expression)object).getValue(session);
                if (value3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                valueArray[i] = value3;
            }
        }
        if ((object = this.getSimpleValue(session, value2 = Function.getNullOrValue(session, expressionArray, valueArray, 0), expressionArray, valueArray)) != null) {
            return object;
        }
        value3 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
        Value value4 = Function.getNullOrValue(session, expressionArray, valueArray, 2);
        Value value5 = Function.getNullOrValue(session, expressionArray, valueArray, 3);
        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, 4);
        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, 5);
        block8 : switch (this.info.type) {
            case 4: {
                value = ValueDouble.get(Math.atan2(value2.getDouble(), value3.getDouble()));
                break;
            }
            case 5: {
                value = ValueLong.get(value2.getLong() & value3.getLong());
                break;
            }
            case 40: {
                value = ValueBoolean.get((value2.getLong() & 1L << value3.getInt()) != 0L);
                break;
            }
            case 6: {
                value = ValueLong.get(value2.getLong() | value3.getLong());
                break;
            }
            case 7: {
                value = ValueLong.get(value2.getLong() ^ value3.getLong());
                break;
            }
            case 16: {
                long l = value3.getLong();
                if (l == 0L) {
                    throw DbException.get(22012, this.getSQL(false));
                }
                value = ValueLong.get(value2.getLong() % l);
                break;
            }
            case 18: {
                value = ValueDouble.get(Math.pow(value2.getDouble(), value3.getDouble()));
                break;
            }
            case 21: {
                double d = value3 == null ? 1.0 : Math.pow(10.0, value3.getDouble());
                double d2 = value2.getDouble() * d;
                int n = d2 > 0.0 ? 1 : -1;
                value = ValueDouble.get((double)Math.round(Math.abs(d2)) / d * (double)n);
                break;
            }
            case 27: {
                if (value2.getValueType() == 11) {
                    value = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)value2).getDateValue(), 0L);
                    break;
                }
                if (value2.getValueType() == 10) {
                    value = ValueTimestamp.fromDateValueAndNanos(((ValueDate)value2).getDateValue(), 0L);
                    break;
                }
                if (value2.getValueType() == 24) {
                    ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value2;
                    value = ValueTimestampTimeZone.fromDateValueAndNanos(valueTimestampTimeZone.getDateValue(), 0L, valueTimestampTimeZone.getTimeZoneOffsetMins());
                    break;
                }
                if (value2.getValueType() == 13) {
                    ValueTimestamp valueTimestamp = ValueTimestamp.parse(value2.getString(), session.getDatabase().getMode());
                    value = ValueTimestamp.fromDateValueAndNanos(valueTimestamp.getDateValue(), 0L);
                    break;
                }
                double d = value2.getDouble();
                int n = value3 == null ? 0 : value3.getInt();
                double d3 = Math.pow(10.0, n);
                double d4 = d * d3;
                value = ValueDouble.get((d < 0.0 ? Math.ceil(d4) : Math.floor(d4)) / d3);
                break;
            }
            case 29: {
                value = Function.getHash(value2.getString(), value3, value4 == null ? 1 : value4.getInt());
                break;
            }
            case 30: {
                value = ValueBytes.getNoCopy(Function.encrypt(value2.getString(), value3.getBytesNoCopy(), value4.getBytesNoCopy()));
                break;
            }
            case 31: {
                value = ValueBytes.getNoCopy(Function.decrypt(value2.getString(), value3.getBytesNoCopy(), value4.getBytesNoCopy()));
                break;
            }
            case 32: {
                String string = null;
                if (value3 != null) {
                    string = value3.getString();
                }
                value = ValueBytes.getNoCopy(CompressTool.getInstance().compress(value2.getBytesNoCopy(), string));
                break;
            }
            case 41: {
                value = Function.oraHash(value2, value3 == null ? 0xFFFFFFFFL : value3.getLong(), value4 == null ? 0L : value4.getLong());
                break;
            }
            case 55: {
                value = ValueInt.get(Function.getDifference(value2.getString(), value3.getString()));
                break;
            }
            case 57: {
                if (value3 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = value3;
                    break;
                }
                value = ValueString.get(Function.insert(value2.getString(), value3.getInt(), value4.getInt(), value5.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                value = ValueString.get(Function.left(value2.getString(), value3.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                int n = value4 == null ? 0 : value4.getInt();
                value = ValueInt.get(Function.locate(value2.getString(), value3.getString(), n));
                break;
            }
            case 58: {
                int n = value4 == null ? 0 : value4.getInt();
                value = ValueInt.get(Function.locate(value3.getString(), value2.getString(), n));
                break;
            }
            case 66: {
                int n = Math.max(0, value3.getInt());
                value = ValueString.get(Function.repeat(value2.getString(), n), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                String string;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string2 = value2.getString();
                String string3 = value3.getString();
                String string4 = string = value4 == null ? "" : value4.getString();
                if (string == null) {
                    string = "";
                }
                value = ValueString.get(StringUtils.replaceAll(string2, string3, string), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                value = ValueString.get(Function.right(value2.getString(), value3.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, false, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                value = ValueString.get(StringUtils.trim(value2.getString(), (this.flags & 1) != 0, (this.flags & 2) != 0, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                value = ValueString.get(StringUtils.trim(value2.getString(), false, true, value3 == null ? " " : value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                String string = value2.getString();
                int n = value3.getInt();
                if (n < 0) {
                    n = string.length() + n + 1;
                }
                int n2 = value4 == null ? string.length() : value4.getInt();
                value = ValueString.get(Function.substring(string, n, n2), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                value = ValueInt.get(Function.locate(value2.getString(), value3.getString(), 0));
                break;
            }
            case 83: {
                value = ValueString.get(StringUtils.xmlAttr(value2.getString(), value3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                String string;
                String string5 = value3 == null ? null : (string = value3 == ValueNull.INSTANCE ? null : value3.getString());
                String string6 = value4 == null ? null : (value4 == ValueNull.INSTANCE ? null : value4.getString());
                boolean bl = value5 == null ? true : value5.getBoolean();
                value = ValueString.get(StringUtils.xmlNode(value2.getString(), string, string6, bl), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                String string = value2.getString();
                String string7 = value3.getString();
                String string8 = value4.getString();
                String string9 = value5 != null ? value5.getString() : null;
                value = this.regexpReplace(string, string7, string8, string9);
                break;
            }
            case 90: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value3.getInt(), value4 == null ? null : value4.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value3.getInt(), value4 == null ? null : value4.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 93: {
                switch (value2.getValueType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        value = ValueString.get(ToChar.toCharDateTime(value2, value3 == null ? null : value3.getString(), value4 == null ? null : value4.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block8;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        value = ValueString.get(ToChar.toChar(value2.getBigDecimal(), value3 == null ? null : value3.getString(), value4 == null ? null : value4.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block8;
                    }
                }
                value = ValueString.get(value2.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                value = ToDateParser.toDate(session, value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 97: {
                value = ToDateParser.toTimestamp(session, value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 98: {
                value = DateTimeFunctions.dateadd("MONTH", value3.getInt(), value2);
                break;
            }
            case 99: {
                value = ToDateParser.toTimestampTz(session, value2.getString(), value3 == null ? null : value3.getString());
                break;
            }
            case 94: {
                String string = value3.getString();
                String string10 = value4.getString();
                value = ValueString.get(Function.translate(value2.getString(), string, string10), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                value = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 105: {
                value = DateTimeFunctions.dateadd(value2.getString(), value3.getLong(), value4);
                break;
            }
            case 106: {
                value = ValueLong.get(DateTimeFunctions.datediff(value2.getString(), value3, value4));
                break;
            }
            case 125: {
                value = DateTimeFunctions.truncateDate(value2.getString(), value3);
                break;
            }
            case 119: {
                value = DateTimeFunctions.extract(value2.getString(), value3, this.database.getMode());
                break;
            }
            case 120: {
                String string;
                String string11;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string12 = value4 == null ? null : (string11 = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string13 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                if (value2 instanceof ValueTimestampTimeZone) {
                    string = DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)value2).getTimeZoneOffsetMins());
                }
                value = ValueString.get(DateTimeFunctions.formatDateTime(value2.getTimestamp(), value3.getString(), string11, string), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 121: {
                String string;
                if (value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string14 = value4 == null ? null : (string = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string15 = value5 == null ? null : (value5 == ValueNull.INSTANCE ? null : value5.getString());
                Date date = DateTimeFunctions.parseDateTime(value2.getString(), value3.getString(), string, string15);
                value = ValueTimestamp.fromMillis(date.getTime());
                break;
            }
            case 205: {
                value = this.database.areEqual(value2, value3) ? ValueNull.INSTANCE : value2;
                break;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, value2, value3);
                SequenceValue sequenceValue = new SequenceValue(sequence);
                value = sequenceValue.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.getSequence(session, value2, value3);
                value = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                String[] stringArray;
                String string = value2.getString();
                String string16 = value3 == null ? null : value3.getString();
                Csv csv = new Csv();
                String string17 = value4 == null ? null : value4.getString();
                String string18 = null;
                if (string17 != null && string17.indexOf(61) >= 0) {
                    string18 = csv.setOptions(string17);
                } else {
                    string18 = string17;
                    String string19 = value5 == null ? null : value5.getString();
                    stringArray = value6 == null ? null : value6.getString();
                    String string20 = value7 == null ? null : value7.getString();
                    Value value8 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string21 = value8 == null ? null : value8.getString();
                    Function.setCsvDelimiterEscape(csv, string19, (String)stringArray, string20);
                    csv.setNullString(string21);
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string16, c, true);
                try {
                    value = ValueResultSet.get(session, csv.read(string, stringArray, string18), Integer.MAX_VALUE);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 234: {
                ValueArray valueArray2 = (ValueArray)value2.convertTo(17);
                ValueArray valueArray3 = (ValueArray)value3.convertTo(17);
                if (!valueArray2.getComponentType().equals(valueArray3.getComponentType())) {
                    throw DbException.get(50000, "Expected component type " + valueArray2.getComponentType() + " but got " + valueArray3.getComponentType());
                }
                Value[] valueArray4 = Arrays.copyOf(valueArray2.getList(), valueArray2.getList().length + valueArray3.getList().length);
                System.arraycopy(valueArray3.getList(), 0, valueArray4, valueArray2.getList().length, valueArray3.getList().length);
                value = ValueArray.get(valueArray2.getComponentType(), valueArray4);
                break;
            }
            case 235: {
                ValueArray valueArray5 = (ValueArray)value2.convertTo(17);
                if (value3 != ValueNull.INSTANCE && valueArray5.getComponentType() != Object.class && !valueArray5.getComponentType().isInstance(value3.getObject())) {
                    throw DbException.get(50000, "Expected component type " + valueArray5.getComponentType() + " but got " + value3.getClass());
                }
                Value[] valueArray6 = Arrays.copyOf(valueArray5.getList(), valueArray5.getList().length + 1);
                valueArray6[valueArray5.getList().length] = value3;
                value = ValueArray.get(valueArray5.getComponentType(), valueArray6);
                break;
            }
            case 236: {
                boolean bl;
                value = null;
                ValueArray valueArray7 = (ValueArray)value2.convertTo(17);
                int n = value3.getInt() - 1;
                int n3 = value4.getInt();
                boolean bl2 = bl = this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
                if (n > n3) {
                    value = bl ? ValueArray.get(valueArray7.getComponentType(), new Value[0]) : ValueNull.INSTANCE;
                } else {
                    if (n < 0) {
                        if (bl) {
                            n = 0;
                        } else {
                            value = ValueNull.INSTANCE;
                        }
                    }
                    if (n3 > valueArray7.getList().length) {
                        if (bl) {
                            n3 = valueArray7.getList().length;
                        } else {
                            value = ValueNull.INSTANCE;
                        }
                    }
                }
                if (value != null) break;
                value = ValueArray.get(valueArray7.getComponentType(), Arrays.copyOfRange(valueArray7.getList(), n, n3));
                break;
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                ResultSet resultSet = LinkSchema.linkSchema(jdbcConnection, value2.getString(), value3.getString(), value4.getString(), value5.getString(), value6.getString(), value7.getString());
                value = ValueResultSet.get(session, resultSet, Integer.MAX_VALUE);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                Csv csv = new Csv();
                String string = value4 == null ? null : value4.getString();
                String string22 = null;
                if (string != null && string.indexOf(61) >= 0) {
                    string22 = csv.setOptions(string);
                } else {
                    string22 = string;
                    String string23 = value5 == null ? null : value5.getString();
                    String string24 = value6 == null ? null : value6.getString();
                    String string25 = value7 == null ? null : value7.getString();
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 6);
                    String string26 = value9 == null ? null : value9.getString();
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 7);
                    String string27 = value10 == null ? null : value10.getString();
                    Function.setCsvDelimiterEscape(csv, string23, string24, string25);
                    csv.setNullString(string26);
                    if (string27 != null) {
                        csv.setLineSeparator(string27);
                    }
                }
                try {
                    int n = csv.write(jdbcConnection, value2.getString(), value3.getString(), string22);
                    value = ValueInt.get(n);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 222: {
                Variable variable = (Variable)expressionArray[0];
                session.setVariable(variable.getName(), value3);
                value = value3;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String string = value2.getString();
                boolean bl = expressionArray.length == 1;
                try {
                    long l = FileUtils.size(string);
                    InputStream inputStream = FileUtils.newInputStream(string);
                    try {
                        if (bl) {
                            value = this.database.getLobStorage().createBlob(inputStream, l);
                        } else {
                            InputStreamReader inputStreamReader = value3 == ValueNull.INSTANCE ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, value3.getString());
                            value = this.database.getLobStorage().createClob(inputStreamReader, l);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(inputStream);
                    }
                    session.addTemporaryLob(value);
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 232: {
                session.getUser().checkAdmin();
                value = ValueNull.INSTANCE;
                String string = value3.getString();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    try (InputStream inputStream = value2.getInputStream();){
                        value = ValueLong.get(IOUtils.copyAndClose(inputStream, fileOutputStream));
                        break;
                    }
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 227: {
                value = value2.convertPrecision(value3.getLong(), value4.getBoolean());
                break;
            }
            case 88: {
                if (value3 == null) {
                    value = ValueString.get(StringUtils.xmlText(value2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                value = ValueString.get(StringUtils.xmlText(value2.getString(), value3.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 240: {
                String string = value3.getString();
                String string28 = value4 != null ? value4.getString() : null;
                int n = Function.makeRegexpFlags(string28, false);
                try {
                    value = ValueBoolean.get(Pattern.compile(string, n).matcher(value2.getString()).find());
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DbException.get(22025, patternSyntaxException, string);
                }
            }
            case 250: {
                Expression expression = expressionArray[0];
                StringBuilder stringBuilder = new StringBuilder();
                Parser.quoteIdentifier(stringBuilder, expression.getSchemaName(), true).append('.');
                Parser.quoteIdentifier(stringBuilder, expression.getTableName(), true).append('.');
                Parser.quoteIdentifier(stringBuilder, expression.getColumnName(), true);
                value = session.getVariable(stringBuilder.toString());
                break;
            }
            case 160: {
                String string = value2.getString();
                if (string.startsWith("00") || !SIGNAL_PATTERN.matcher(string).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", string);
                }
                String string29 = value3.getString();
                throw DbException.fromUser(string, string29);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getValueType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getType().getPrecision();
            }
        }
        return value.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUpInt(byArray.length, n);
        return Utils.copyBytes(byArray, n2);
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static Value getHash(String string, Value value, int n) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        if (n <= 0) {
            throw DbException.getInvalidValueException("iterations", n);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-256");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        byte[] byArray = messageDigest.digest();
        for (int i = 1; i < n; ++i) {
            byArray = messageDigest.digest(byArray);
        }
        return ValueBytes.getNoCopy(byArray);
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (--n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n = n > n3 ? n3 : n;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(n, n + n2);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n);
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static String hexToRaw(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string3 == null ? 0 : string3.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                    if (i > 0) {
                        stringBuilder.append(string, 0, i);
                    }
                }
                if (n3 < n) {
                    c = string3.charAt(n3);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d;
        }
        int n = stringBuilder.length();
        if (n < 16) {
            return d;
        }
        if (stringBuilder.toString().indexOf(46) > n - 3) {
            return d;
        }
        stringBuilder.delete(n - 2, n);
        char c = stringBuilder.charAt((n -= 2) - 2);
        char c2 = stringBuilder.charAt(n - 3);
        char c3 = stringBuilder.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuilder.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuilder.setCharAt(n - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    private static Value oraHash(Value value, long l, long l2) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", l);
        }
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", l2);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-1");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 != 0L) {
            byte[] byArray = new byte[4];
            Bits.writeInt(byArray, 0, (int)l2);
            messageDigest.update(byArray);
        }
        long l3 = Bits.readLong(messageDigest.digest(), 0);
        return ValueLong.get((l3 & Long.MAX_VALUE) % (l + 1L));
    }

    private static MessageDigest hashImpl(Value value, String string) {
        MessageDigest messageDigest;
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            case 13: 
            case 14: 
            case 21: {
                try {
                    messageDigest = MessageDigest.getInstance(string);
                    messageDigest.update(value.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            case 15: 
            case 16: {
                try {
                    messageDigest = MessageDigest.getInstance(string);
                    byte[] byArray = new byte[4096];
                    try (InputStream inputStream = value.getInputStream();){
                        int n;
                        while ((n = inputStream.read(byArray)) > 0) {
                            messageDigest.update(byArray, 0, n);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            default: {
                try {
                    messageDigest = MessageDigest.getInstance(string);
                    messageDigest.update(value.getBytesNoCopy());
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
        }
        return messageDigest;
    }

    private Value regexpReplace(String string, String string2, String string3, String string4) {
        int n;
        Mode mode = this.database.getMode();
        if (mode.regexpReplaceBackslashReferences && (string3.indexOf(92) >= 0 || string3.indexOf(36) >= 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < string3.length(); ++n) {
                char c = string3.charAt(n);
                if (c == '$') {
                    stringBuilder.append('\\');
                } else if (c == '\\' && ++n < string3.length()) {
                    c = string3.charAt(n);
                    stringBuilder.append((char)(c >= '0' && c <= '9' ? 36 : 92));
                }
                stringBuilder.append(c);
            }
            string3 = stringBuilder.toString();
        }
        boolean bl = Mode.ModeEnum.PostgreSQL.equals((Object)mode.getEnum());
        n = Function.makeRegexpFlags(string4, bl);
        try {
            Matcher matcher = Pattern.compile(string2, n).matcher(string);
            return ValueString.get(bl && (string4 == null || string4.indexOf(103) < 0) ? matcher.replaceFirst(string3) : matcher.replaceAll(string3), mode.treatEmptyStringsAsNull);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DbException.get(22025, patternSyntaxException, string2);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            throw DbException.get(22025, runtimeException, string3);
        }
    }

    private static int makeRegexpFlags(String string, boolean bl) {
        int n = 64;
        if (string != null) {
            block7: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case 'i': {
                        n |= 2;
                        continue block7;
                    }
                    case 'c': {
                        n &= 0xFFFFFFFD;
                        continue block7;
                    }
                    case 'n': {
                        n |= 0x20;
                        continue block7;
                    }
                    case 'm': {
                        n |= 8;
                        continue block7;
                    }
                    case 'g': {
                        if (bl) continue block7;
                    }
                    default: {
                        throw DbException.get(90008, string);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getValueType() {
        return this.type.getValueType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    protected void checkParameterCount(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                n3 = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 125: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 93: 
            case 96: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 41: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 29: 
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 4;
                break;
            }
            case 120: 
            case 121: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 207: 
            case 208: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 206: 
            case 229: {
                n2 = 3;
                break;
            }
            case 89: {
                n2 = 3;
                n3 = 4;
                break;
            }
            case 240: {
                n2 = 2;
                n3 = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl2 = bl = n >= n2 && n <= n3;
        if (!bl) {
            throw DbException.get(7001, this.info.name, n2 + ".." + n3);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            this.checkParameterCount(this.varArgs.size());
            this.args = this.varArgs.toArray(new Expression[0]);
            this.varArgs = null;
        } else {
            int n = this.args.length;
            if (n > 0 && this.args[n - 1] == null) {
                throw DbException.get(7001, this.info.name, Integer.toString(n));
            }
        }
    }

    public void setDataType(Column column) {
        TypeInfo typeInfo;
        this.type = typeInfo = column.getType();
    }

    @Override
    public Expression optimize(Session session) {
        TypeInfo typeInfo;
        Expression expression;
        boolean bl = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            expression = this.args[i];
            if (expression == null) continue;
            this.args[i] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        expression = this.args.length < 1 ? null : this.args[0];
        block0 : switch (this.info.type) {
            case 105: {
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                if (!expression.isConstant()) break;
                Expression expression2 = this.args[2];
                block24 : switch (expression2.getType().getValueType()) {
                    case 9: {
                        typeInfo = TypeInfo.TYPE_TIME;
                        break;
                    }
                    case 10: {
                        int n = DateTimeFunctions.getDatePart(expression.getValue(session).getString());
                        switch (n) {
                            case 111: 
                            case 112: 
                            case 116: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: {
                                break block24;
                            }
                        }
                        this.type = TypeInfo.TYPE_DATE;
                        break;
                    }
                    case 24: {
                        this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                    }
                }
                break;
            }
            case 119: {
                if (expression.isConstant() && DateTimeFunctions.getDatePart(expression.getValue(session).getString()) == 127) {
                    typeInfo = TypeInfo.getTypeInfo(6, 28L, 9, null);
                    break;
                }
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 125: {
                typeInfo = this.args[1].getType();
                if (typeInfo.getValueType() == 24) break;
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                break;
            }
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                for (Expression expression3 : this.args) {
                    TypeInfo typeInfo2;
                    int n;
                    if (expression3 == ValueExpression.getNull() || (n = (typeInfo2 = expression3.getType()).getValueType()) == -1 || n == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo2);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 206: 
            case 229: {
                TypeInfo typeInfo3;
                int n;
                Expression expression4;
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                int n2 = this.args.length;
                for (int i = 2; i < n2; i += 2) {
                    TypeInfo typeInfo4;
                    int n3;
                    Expression expression5 = this.args[i];
                    if (expression5 == ValueExpression.getNull() || (n3 = (typeInfo4 = expression5.getType()).getValueType()) == -1 || n3 == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo4);
                }
                if (this.args.length % 2 == 0 && (expression4 = this.args[this.args.length - 1]) != ValueExpression.getNull() && (n = (typeInfo3 = expression4.getType()).getValueType()) != -1 && n != 0) {
                    typeInfo = Value.getHigherType(typeInfo, typeInfo3);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 201: {
                typeInfo = Value.getHigherType(this.args[1].getType(), this.args[2].getType());
                break;
            }
            case 228: {
                TypeInfo typeInfo5 = this.args[1].getType();
                TypeInfo typeInfo6 = this.args[2].getType();
                switch (typeInfo5.getValueType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        typeInfo = TypeInfo.getTypeInfo(typeInfo5.getValueType(), -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = Value.getHigherType(typeInfo5, typeInfo6);
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                if (this.type != null) {
                    typeInfo = this.type;
                    break;
                }
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                break;
            }
            case 27: {
                switch (expression.getType().getValueType()) {
                    case 10: 
                    case 11: 
                    case 13: {
                        typeInfo = TypeInfo.getTypeInfo(11, -1L, 0, null);
                        break block0;
                    }
                    case 24: {
                        typeInfo = TypeInfo.getTypeInfo(24, -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                TypeInfo typeInfo7;
                typeInfo = typeInfo7 = expression.getType();
                if (typeInfo.getValueType() != 0) break;
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 222: {
                typeInfo = this.args[1].getType();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL(false));
            }
            case 225: {
                if (this.args.length == 1) {
                    typeInfo = TypeInfo.getTypeInfo(15, Integer.MAX_VALUE, 0, null);
                    break;
                }
                typeInfo = TypeInfo.getTypeInfo(16, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 72: 
            case 73: {
                long l = this.args[0].getType().getPrecision();
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l, 0, null);
                break;
            }
            case 30: 
            case 31: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[2].getType().getPrecision(), 0, null);
                break;
            }
            case 32: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 52: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 1L, 0, null);
                break;
            }
            case 54: {
                long l = 0L;
                for (Expression expression6 : this.args) {
                    TypeInfo typeInfo8 = expression6.getType();
                    if ((l += typeInfo8.getPrecision()) >= 0L) continue;
                    l = Long.MAX_VALUE;
                }
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l, 0, null);
                break;
            }
            case 56: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, (this.args[0].getType().getPrecision() + 3L) / 4L, 0, null);
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 65: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision() * 4L, 0, null);
                break;
            }
            case 70: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 4L, 0, null);
                break;
            }
            case 107: 
            case 114: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 20L, 0, null);
                break;
            }
            default: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, -1L, -1, null);
            }
        }
        this.type = typeInfo;
        if (bl) {
            Value value = this.getValue(session);
            if (this.info.type == 203 || this.info.type == 202) {
                if (value == ValueNull.INSTANCE) {
                    return this;
                }
                DataType dataType = DataType.getDataType(this.type.getValueType());
                TypeInfo typeInfo9 = value.getType();
                if (dataType.supportsPrecision && this.type.getPrecision() != typeInfo9.getPrecision() || dataType.supportsScale && this.type.getScale() != typeInfo9.getScale()) {
                    return this;
                }
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        boolean bl2;
        stringBuilder.append(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                stringBuilder.append(' ');
                this.args[0].getSQL(stringBuilder, bl);
            }
            int n = this.args.length - 1;
            for (int i = 1; i < n; i += 2) {
                stringBuilder.append(" WHEN ");
                this.args[i].getSQL(stringBuilder, bl);
                stringBuilder.append(" THEN ");
                this.args[i + 1].getSQL(stringBuilder, bl);
            }
            if (this.args.length % 2 == 0) {
                stringBuilder.append(" ELSE ");
                this.args[this.args.length - 1].getSQL(stringBuilder, bl);
            }
            return stringBuilder.append(" END");
        }
        boolean bl3 = bl2 = this.args.length > 0 || this.info.requireParentheses;
        if (bl2) {
            stringBuilder.append('(');
        }
        switch (this.info.type) {
            case 78: {
                switch (this.flags) {
                    case 1: {
                        stringBuilder.append("LEADING ");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("TRAILING ");
                    }
                }
                if (this.args.length > 1) {
                    this.args[1].getSQL(stringBuilder, bl).append(" FROM ");
                }
                this.args[0].getSQL(stringBuilder, bl);
                break;
            }
            case 203: {
                this.args[0].getSQL(stringBuilder, bl).append(" AS ").append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    stringBuilder.append(new Column(null, this.type).getCreateSQL()).append(',');
                    this.args[0].getSQL(stringBuilder, bl);
                    break;
                }
                this.args[0].getSQL(stringBuilder, bl).append(',').append(new Column(null, this.type).getCreateSQL());
                break;
            }
            case 119: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                stringBuilder.append(valueString.getString()).append(" FROM ");
                this.args[1].getSQL(stringBuilder, bl);
                break;
            }
            default: {
                Function.writeExpressions(stringBuilder, this.args, bl);
            }
        }
        if (bl2) {
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session, n);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.get(session, resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (!string.isEmpty()) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.isEmpty() ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.isEmpty() ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    @Override
    public boolean isGeneratedKey() {
        return this.info.type == 207;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.args[n];
    }

    static {
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, -1, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ORA_HASH", 41, -1, 5);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("SYSDATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("TODAY", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 101, -1, 9);
        Function.addFunctionNotDeterministic("LOCALTIME", 102, -1, 9, false);
        Function.addFunctionNotDeterministic("SYSTIME", 102, 0, 9, false);
        Function.addFunctionNotDeterministic("CURTIME", 102, -1, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("LOCALTIMESTAMP", 104, -1, 11, false);
        Function.addFunctionNotDeterministic("NOW", 104, -1, 11);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunction("DATEADD", 105, 3, 11);
        Function.addFunction("TIMESTAMPADD", 105, 3, 11);
        Function.addFunction("DATEDIFF", 106, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 106, 3, 5);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAY", 108, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 108, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 109, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 110, 1, 4);
        Function.addFunction("DAYOFMONTH", 108, 1, 4);
        Function.addFunction("DAYOFWEEK", 109, 1, 4);
        Function.addFunction("DAYOFYEAR", 110, 1, 4);
        Function.addFunction("HOUR", 111, 1, 4);
        Function.addFunction("MINUTE", 112, 1, 4);
        Function.addFunction("MONTH", 113, 1, 4);
        Function.addFunction("MONTHNAME", 114, 1, 13);
        Function.addFunction("QUARTER", 115, 1, 4);
        Function.addFunction("SECOND", 116, 1, 4);
        Function.addFunction("WEEK", 117, 1, 4);
        Function.addFunction("YEAR", 118, 1, 4);
        Function.addFunction("EXTRACT", 119, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 120, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 121, -1, 11);
        Function.addFunction("ISO_YEAR", 122, 1, 4);
        Function.addFunction("ISO_WEEK", 123, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 124, 1, 4);
        Function.addFunction("DATE_TRUNC", 125, 2, 0);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 0);
        Function.addFunctionWithNull("ARRAY_CONTAINS", 230, 2, 1);
        Function.addFunction("ARRAY_CAT", 234, 2, 17);
        Function.addFunction("ARRAY_APPEND", 235, 2, 17);
        Function.addFunction("ARRAY_SLICE", 236, 3, 17);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false, true);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunctionNotDeterministic("ESTIMATED_ENVELOPE", 161, 2, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("UNNEST", 233, -1, 18);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false, true);
    }
}

