/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression.condition;

import java.util.AbstractList;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionColumn;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.expression.Parameter;
import org.h14199.expression.ValueExpression;
import org.h14199.expression.condition.Comparison;
import org.h14199.expression.condition.Condition;
import org.h14199.index.IndexCondition;
import org.h14199.result.ResultInterface;
import org.h14199.table.ColumnResolver;
import org.h14199.table.TableFilter;
import org.h14199.value.Value;
import org.h14199.value.ValueArray;
import org.h14199.value.ValueBoolean;
import org.h14199.value.ValueNull;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    static Value getValue(Database database, Value value, Value value2) {
        boolean bl = false;
        if (value2.containsNull()) {
            bl = true;
        } else if (value2.getValueType() == 18) {
            ResultInterface resultInterface = value2.getResult();
            while (resultInterface.next()) {
                Value value3 = resultInterface.currentRow()[0];
                Value value4 = Comparison.compare(database, value, value3, 0);
                if (value4 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value4 != ValueBoolean.TRUE) continue;
                return value4;
            }
        } else {
            for (Value value5 : ((ValueArray)value2.convertTo(17)).getList()) {
                Value value6 = Comparison.compare(database, value, value5, 0);
                if (value6 == ValueNull.INSTANCE) {
                    bl = true;
                    continue;
                }
                if (value6 != ValueBoolean.TRUE) continue;
                return value6;
            }
        }
        if (bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    public ConditionInParameter(Database database, Expression expression, Parameter parameter) {
        this.database = database;
        this.left = expression;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return ConditionInParameter.getValue(this.database, value, this.parameter.getValue(session));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" = ANY(");
        return this.parameter.getSQL(stringBuilder, bl).append("))");
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.parameter.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int n) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[n]);
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

