/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression;

import org.h14199.command.Prepared;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.message.DbException;
import org.h14199.table.ColumnResolver;
import org.h14199.table.TableFilter;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueLong;

public class Rownum
extends Expression {
    private final Prepared prepared;

    public Rownum(Prepared prepared) {
        if (prepared == null) {
            throw DbException.throwInternalError();
        }
        this.prepared = prepared;
    }

    @Override
    public Value getValue(Session session) {
        return ValueLong.get(this.prepared.getCurrentRowNumber());
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_LONG;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public String getSQL(boolean bl) {
        return "ROWNUM()";
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append("ROWNUM()");
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }
}

