/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.h14199.command.Command;
import org.h14199.command.CommandInterface;
import org.h14199.command.Parser;
import org.h14199.command.Prepared;
import org.h14199.command.ddl.Analyze;
import org.h14199.command.dml.Query;
import org.h14199.constraint.Constraint;
import org.h14199.engine.ConnectionInfo;
import org.h14199.engine.Database;
import org.h14199.engine.Engine;
import org.h14199.engine.GeneratedKeys;
import org.h14199.engine.Procedure;
import org.h14199.engine.SessionInterface;
import org.h14199.engine.SessionWithState;
import org.h14199.engine.SysProperties;
import org.h14199.engine.UndoLog;
import org.h14199.engine.UndoLogRecord;
import org.h14199.engine.User;
import org.h14199.index.Index;
import org.h14199.index.ViewIndex;
import org.h14199.jdbc.JdbcConnection;
import org.h14199.message.DbException;
import org.h14199.message.Trace;
import org.h14199.message.TraceSystem;
import org.h14199.mvstore.MVMap;
import org.h14199.mvstore.db.MVTable;
import org.h14199.mvstore.db.MVTableEngine;
import org.h14199.mvstore.tx.Transaction;
import org.h14199.mvstore.tx.TransactionStore;
import org.h14199.result.ResultInterface;
import org.h14199.result.Row;
import org.h14199.result.SortOrder;
import org.h14199.schema.Schema;
import org.h14199.store.DataHandler;
import org.h14199.store.InDoubtTransaction;
import org.h14199.table.SubQueryInfo;
import org.h14199.table.Table;
import org.h14199.table.TableFilter;
import org.h14199.table.TableType;
import org.h14199.util.ColumnNamerConfiguration;
import org.h14199.util.CurrentTimestamp;
import org.h14199.util.SmallLRUCache;
import org.h14199.util.Utils;
import org.h14199.value.DataType;
import org.h14199.value.Value;
import org.h14199.value.ValueArray;
import org.h14199.value.ValueLong;
import org.h14199.value.ValueNull;
import org.h14199.value.ValueString;
import org.h14199.value.ValueTimestampTimeZone;
import org.h14199.value.VersionedValue;

public class Session
extends SessionWithState
implements TransactionStore.RollbackListener {
    public static final int LOG_WRITTEN = -1;
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private final Database database;
    private ConnectionInfo connectionInfo;
    private final User user;
    private final int id;
    private final ArrayList<Table> locks = Utils.newSmallArrayList();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private Value lastScopeIdentity = ValueLong.get(0L);
    private Value lastTriggerIdentity;
    private GeneratedKeys generatedKeys;
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Savepoint> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private long throttleNs;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, Value> removeLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean redoLogBinary = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAtNs;
    private final long sessionStart = System.currentTimeMillis();
    private ValueTimestampTimeZone transactionStart;
    private ValueTimestampTimeZone currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<ResultInterface> temporaryResults;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private Thread waitForLockThread;
    private int modificationId;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;
    private long modificationMetaID = -1L;
    private SubQueryInfo subQueryInfo;
    private ArrayDeque<String> viewNameStack;
    private int preparingQueryExpression;
    private volatile SmallLRUCache<Object, ViewIndex> viewIndexCache;
    private HashMap<Object, ViewIndex> subQueryIndexCache;
    private boolean joinBatchEnabled;
    private boolean forceJoinOrder;
    private boolean lazyQueryExecution;
    private ColumnNamerConfiguration columnNamerConfiguration;
    private HashSet<Table> tablesToAnalyze;
    private LinkedList<TimeoutValue> temporaryResultLobs;
    private ArrayList<Value> temporaryLobs;
    private Transaction transaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private long startStatement = -1L;
    private BitSet idsToRelease;

    public Session(Database database, User user, int n) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.user = user;
        this.id = n;
        this.lockTimeout = database.getLockTimeout();
        Schema schema = database.getMainSchema();
        this.currentSchemaName = schema != null ? schema.getName() : database.sysIdentifier("PUBLIC");
        this.columnNamerConfiguration = ColumnNamerConfiguration.getDefault();
    }

    public void setLazyQueryExecution(boolean bl) {
        this.lazyQueryExecution = bl;
    }

    public boolean isLazyQueryExecution() {
        return this.lazyQueryExecution;
    }

    public void setForceJoinOrder(boolean bl) {
        this.forceJoinOrder = bl;
    }

    public boolean isForceJoinOrder() {
        return this.forceJoinOrder;
    }

    public void setJoinBatchEnabled(boolean bl) {
        this.joinBatchEnabled = bl;
    }

    public boolean isJoinBatchEnabled() {
        return this.joinBatchEnabled;
    }

    public Row createRow(Value[] valueArray, int n) {
        return this.database.createRow(valueArray, n);
    }

    public void pushSubQueryInfo(int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder) {
        this.subQueryInfo = new SubQueryInfo(this.subQueryInfo, nArray, tableFilterArray, n, sortOrder);
    }

    public void popSubQueryInfo() {
        this.subQueryInfo = this.subQueryInfo.getUpper();
    }

    public SubQueryInfo getSubQueryInfo() {
        return this.subQueryInfo;
    }

    public void setParsingCreateView(boolean bl, String string) {
        if (this.viewNameStack == null) {
            this.viewNameStack = new ArrayDeque(3);
        }
        if (bl) {
            this.viewNameStack.push(string);
        } else {
            String string2 = this.viewNameStack.pop();
            assert (string.equals(string2));
        }
    }

    public String getParsingCreateViewName() {
        return this.viewNameStack != null ? this.viewNameStack.peek() : null;
    }

    public boolean isParsingCreateView() {
        return this.viewNameStack != null && !this.viewNameStack.isEmpty();
    }

    public void optimizeQueryExpression(Query query) {
        SubQueryInfo subQueryInfo = this.subQueryInfo;
        this.subQueryInfo = null;
        ++this.preparingQueryExpression;
        try {
            query.prepare();
        }
        finally {
            this.subQueryInfo = subQueryInfo;
            --this.preparingQueryExpression;
        }
    }

    public boolean isPreparingQueryExpression() {
        assert (this.preparingQueryExpression >= 0);
        return this.preparingQueryExpression != 0;
    }

    @Override
    public ArrayList<String> getClusterServers() {
        return new ArrayList<String>();
    }

    public boolean setCommitOrRollbackDisabled(boolean bl) {
        boolean bl2 = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = bl;
        return bl2;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.database.newStringMap();
        }
    }

    public void setVariable(String string, Value value) {
        Value value2;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            value2 = this.variables.remove(string);
        } else {
            value = value.copy(this.database, -1);
            value2 = this.variables.put(string, value);
        }
        if (value2 != null) {
            value2.remove();
        }
    }

    public Value getVariable(String string) {
        this.initVariables();
        Value value = this.variables.get(string);
        return value == null ? ValueNull.INSTANCE : value;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public Table findLocalTempTable(String string) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(string);
    }

    public ArrayList<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return Utils.newSmallArrayList();
        }
        return new ArrayList<Table>(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.database.newStringMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            table.getSQL(stringBuilder, false).append(" AS ");
            Parser.quoteIdentifier(table.getName(), false);
            throw DbException.get(42101, stringBuilder.toString());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        boolean bl = this.database.lockMeta(this);
        try {
            ++this.modificationId;
            if (this.localTempTables != null) {
                this.localTempTables.remove(table.getName());
            }
            Database database = this.database;
            synchronized (database) {
                table.removeChildrenAndResources(this);
            }
        }
        finally {
            if (!bl) {
                this.database.unlockMeta(this);
            }
        }
    }

    public Index findLocalTempTableIndex(String string) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(string);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return new HashMap<String, Index>();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.database.newStringMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL(false));
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String string) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(string);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return new HashMap<String, Constraint>();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String string;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.database.newStringMap();
        }
        if (this.localTempTableConstraints.get(string = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL(false));
        }
        this.localTempTableConstraints.put(string, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int n) {
        this.lockTimeout = n;
    }

    @Override
    public synchronized CommandInterface prepareCommand(String string, int n) {
        return this.prepareLocal(string);
    }

    public Prepared prepare(String string) {
        return this.prepare(string, false, false);
    }

    public Prepared prepare(String string, boolean bl, boolean bl2) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(bl);
        parser.setLiteralsChecked(bl2);
        return parser.prepare(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command prepareLocal(String string) {
        Command command;
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
                this.modificationMetaID = this.database.getModificationMetaId();
            } else {
                long l = this.database.getModificationMetaId();
                if (l != this.modificationMetaID) {
                    this.queryCache.clear();
                    this.modificationMetaID = l;
                }
                if ((command = (Command)this.queryCache.get(string)) != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        try {
            command = parser.prepareCommand(string);
        }
        finally {
            this.subQueryIndexCache = null;
        }
        command.prepareJoinBatch();
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(string, command);
        }
        return command;
    }

    void scheduleDatabaseObjectIdForRelease(int n) {
        if (this.idsToRelease == null) {
            this.idsToRelease = new BitSet();
        }
        this.idsToRelease.set(n);
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int n) {
        this.database.setPowerOffCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean bl) {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        if (this.transaction != null) {
            try {
                if (!this.locks.isEmpty()) {
                    for (Table table : this.locks) {
                        if (!(table instanceof MVTable)) continue;
                        ((MVTable)table).commit();
                    }
                }
                this.transaction.commit();
            }
            finally {
                this.transaction = null;
            }
        } else if (this.containsUncommitted()) {
            this.database.commit(this);
        }
        this.removeTemporaryLobs(true);
        if (this.undoLog != null && this.undoLog.size() > 0) {
            this.undoLog.clear();
        }
        if (!bl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        if (this.tablesToAnalyze != null) {
            if (this.database.isMVStore()) {
                this.analyzeTables();
                this.commit(true);
            } else {
                this.analyzeTables();
            }
        }
        this.endTransaction();
    }

    private void analyzeTables() {
        int n = this.getDatabase().getSettings().analyzeSample / 10;
        for (Table table : this.tablesToAnalyze) {
            Analyze.analyzeTable(this, table, n, false);
        }
        this.database.unlockMeta(this);
        this.tablesToAnalyze = null;
    }

    private void removeTemporaryLobs(boolean bl) {
        assert (this != this.getDatabase().getLobSession() || Thread.holdsLock(this) || Thread.holdsLock(this.getDatabase()));
        if (this.temporaryLobs != null) {
            for (Value value : this.temporaryLobs) {
                if (value.isLinkedToTable()) continue;
                value.remove();
            }
            this.temporaryLobs.clear();
        }
        if (this.temporaryResultLobs != null && !this.temporaryResultLobs.isEmpty()) {
            long l = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.database.getSettings().lobTimeout);
            while (!this.temporaryResultLobs.isEmpty()) {
                TimeoutValue timeoutValue = this.temporaryResultLobs.getFirst();
                if (bl && timeoutValue.created >= l) break;
                Value value = this.temporaryResultLobs.removeFirst().value;
                if (value.isLinkedToTable()) continue;
                value.remove();
            }
        }
    }

    private void checkCommitRollback() {
        if (this.commitOrRollbackDisabled && !this.locks.isEmpty()) {
            throw DbException.get(90058);
        }
    }

    private void endTransaction() {
        if (this.removeLobMap != null && this.removeLobMap.size() > 0) {
            if (this.database.getStore() == null) {
                this.database.flush();
            }
            for (Value value : this.removeLobMap.values()) {
                value.remove();
            }
            this.removeLobMap = null;
        }
        this.unlockAll();
        if (this.idsToRelease != null) {
            this.database.releaseDatabaseObjectIds(this.idsToRelease);
            this.idsToRelease = null;
        }
    }

    public void rollback() {
        boolean bl;
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        boolean bl2 = bl = this.undoLog != null && this.undoLog.size() > 0 || this.transaction != null;
        if (bl) {
            this.rollbackTo(null);
        }
        if (!this.locks.isEmpty() || bl) {
            this.database.commit(this);
        }
        this.idsToRelease = null;
        this.cleanTempTables(false);
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
        this.endTransaction();
    }

    public void rollbackTo(Savepoint savepoint) {
        String[] stringArray;
        int n;
        int n2 = n = savepoint == null ? 0 : savepoint.logIndex;
        if (this.undoLog != null) {
            while (this.undoLog.size() > n) {
                stringArray = this.undoLog.getLast();
                stringArray.undo(this);
                this.undoLog.removeLast();
            }
        }
        if (this.transaction != null) {
            if (savepoint == null) {
                this.transaction.rollback();
                this.transaction = null;
            } else {
                this.transaction.rollbackToSavepoint(savepoint.transactionSavepoint);
            }
        }
        if (this.savepoints != null) {
            for (String string : stringArray = this.savepoints.keySet().toArray(new String[this.savepoints.size()])) {
                Savepoint savepoint2 = this.savepoints.get(string);
                int n3 = savepoint2.logIndex;
                if (n3 <= n) continue;
                this.savepoints.remove(string);
            }
        }
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        return this.undoLog != null && this.undoLog.size() > 0;
    }

    public Savepoint setSavepoint() {
        Savepoint savepoint = new Savepoint();
        if (this.undoLog != null) {
            savepoint.logIndex = this.undoLog.size();
        }
        if (this.database.getStore() != null) {
            savepoint.transactionSavepoint = this.getStatementSavepoint();
        }
        return savepoint;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAtNs = System.nanoTime();
    }

    @Override
    public void close() {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            try {
                this.database.checkPowerOff();
                this.rollback();
                this.removeTemporaryLobs(false);
                this.cleanTempTables(true);
                this.commit(true);
                if (this.undoLog != null) {
                    this.undoLog.clear();
                }
                this.database.unlockMeta(this);
            }
            finally {
                this.database.removeSession(this);
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.contains(table)) {
            DbException.throwInternalError(table.toString());
        }
        this.locks.add(table);
    }

    public void log(Table table, short s, Row row) {
        if (table.isMVStore()) {
            return;
        }
        if (this.undoLogEnabled) {
            int n;
            UndoLogRecord undoLogRecord = new UndoLogRecord(table, s, row);
            if (SysProperties.CHECK && (n = this.database.getLockMode()) != 0 && !this.database.isMVStore()) {
                TableType tableType = undoLogRecord.getTable().getTableType();
                if (!this.locks.contains(undoLogRecord.getTable()) && TableType.TABLE_LINK != tableType && TableType.EXTERNAL_TABLE_ENGINE != tableType) {
                    DbException.throwInternalError(String.valueOf((Object)tableType));
                }
            }
            if (this.undoLog == null) {
                this.undoLog = new UndoLog(this.database);
            }
            this.undoLog.add(undoLogRecord);
        }
    }

    public void unlockReadLocks() {
        if (!this.database.isMVStore() && this.database.isMultiThreaded() && this.database.getLockMode() == 3) {
            Iterator<Table> iterator = this.locks.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (table.isLockedExclusively()) continue;
                table.unlock(this);
                iterator.remove();
            }
        }
    }

    void unlock(Table table) {
        this.locks.remove(table);
    }

    private void unlockAll() {
        if (this.undoLog != null && this.undoLog.size() > 0) {
            DbException.throwInternalError();
        }
        if (!this.locks.isEmpty()) {
            for (Table table : this.locks) {
                table.unlock(this);
            }
            this.locks.clear();
        }
        this.database.unlockMetaDebug(this);
        this.savepoints = null;
        this.sessionStateChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean bl) {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            if (this.database.isMVStore()) {
                this._cleanTempTables(bl);
            } else {
                Database database = this.database;
                synchronized (database) {
                    this._cleanTempTables(bl);
                }
            }
        }
    }

    private void _cleanTempTables(boolean bl) {
        Iterator<Table> iterator = this.localTempTables.values().iterator();
        while (iterator.hasNext()) {
            Table table = iterator.next();
            if (bl || table.getOnCommitDrop()) {
                ++this.modificationId;
                table.setModified();
                iterator.remove();
                this.database.lockMeta(this);
                table.removeChildrenAndResources(this);
                if (!bl) continue;
                this.database.commit(this);
                continue;
            }
            if (!table.getOnCommitTruncate()) continue;
            table.truncate(this);
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.isClosed()) {
            return this.trace;
        }
        String string = "jdbc[" + this.id + "]";
        if (this.isClosed()) {
            return new TraceSystem(null).getTrace(string);
        }
        this.trace = this.database.getTraceSystem().getTrace(string);
        return this.trace;
    }

    public void setLastIdentity(Value value) {
        this.lastIdentity = value;
        this.lastScopeIdentity = value;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void setLastScopeIdentity(Value value) {
        this.lastScopeIdentity = value;
    }

    public Value getLastScopeIdentity() {
        return this.lastScopeIdentity;
    }

    public void setLastTriggerIdentity(Value value) {
        this.lastTriggerIdentity = value;
    }

    public Value getLastTriggerIdentity() {
        return this.lastTriggerIdentity;
    }

    public GeneratedKeys getGeneratedKeys() {
        if (this.generatedKeys == null) {
            this.generatedKeys = new GeneratedKeys();
        }
        return this.generatedKeys;
    }

    public void addLogPos(int n, int n2) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = n;
            this.firstUncommittedPos = n2;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    public boolean containsUncommitted() {
        if (this.database.getStore() != null) {
            return this.transaction != null && this.transaction.hasChanges();
        }
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String string) {
        if (this.savepoints == null) {
            this.savepoints = this.database.newStringMap();
        }
        this.savepoints.put(string, this.setSavepoint());
    }

    public void rollbackToSavepoint(String string) {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = null;
        if (this.savepoints == null) {
            throw DbException.get(90063, string);
        }
        Savepoint savepoint = this.savepoints.get(string);
        if (savepoint == null) {
            throw DbException.get(90063, string);
        }
        this.rollbackTo(savepoint);
    }

    public void prepareCommit(String string) {
        if (this.containsUncommitted()) {
            this.database.prepareCommit(this, string);
        }
        this.currentTransactionName = string;
    }

    public void setPreparedTransaction(String string, boolean bl) {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(string)) {
            if (bl) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> arrayList = this.database.getInDoubtTransactions();
            int n = bl ? 1 : 2;
            boolean bl2 = false;
            if (arrayList != null) {
                for (InDoubtTransaction inDoubtTransaction : arrayList) {
                    if (!inDoubtTransaction.getTransactionName().equals(string)) continue;
                    inDoubtTransaction.setState(n);
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                throw DbException.get(90129, string);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public void setThrottle(int n) {
        this.throttleNs = TimeUnit.MILLISECONDS.toNanos(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle() {
        if (this.currentCommandStart == null) {
            this.currentCommandStart = CurrentTimestamp.get();
        }
        if (this.throttleNs == 0L) {
            return;
        }
        long l = System.nanoTime();
        if (this.lastThrottle + TimeUnit.MILLISECONDS.toNanos(50L) > l) {
            return;
        }
        State state = this.state.get();
        if (state != State.CLOSED) {
            this.lastThrottle = l + this.throttleNs;
            try {
                this.state.compareAndSet(state, State.SLEEP);
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.throttleNs));
            }
            catch (Exception exception) {
            }
            finally {
                this.state.compareAndSet(State.SLEEP, state);
            }
        }
    }

    public void setCurrentCommand(Command command, Object object) {
        State state;
        this.currentCommand = command;
        if (command != null && !command.isQuery()) {
            this.getGeneratedKeys().clear(object);
        }
        if (command != null) {
            if (this.queryTimeout > 0) {
                this.currentCommandStart = CurrentTimestamp.get();
                long l = System.nanoTime();
                this.cancelAtNs = l + TimeUnit.MILLISECONDS.toNanos(this.queryTimeout);
            } else {
                this.currentCommandStart = null;
            }
        }
        if ((state = this.state.get()) != State.CLOSED) {
            this.state.compareAndSet(state, command == null ? State.SLEEP : State.RUNNING);
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.cancelAtNs == 0L) {
            return;
        }
        long l = System.nanoTime();
        if (l >= this.cancelAtNs) {
            this.cancelAtNs = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAtNs;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public ValueTimestampTimeZone getCurrentCommandStart() {
        if (this.currentCommandStart == null) {
            this.currentCommandStart = CurrentTimestamp.get();
        }
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean bl) {
        this.allowLiterals = bl;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    @Override
    public void setCurrentSchemaName(String string) {
        Schema schema = this.database.getSchema(string);
        this.setCurrentSchema(schema);
    }

    public JdbcConnection createConnection(boolean bl) {
        String string = bl ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), string);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void removeAtCommit(Value value) {
        String string = value.toString();
        if (!value.isLinkedToTable()) {
            DbException.throwInternalError(string);
        }
        if (this.removeLobMap == null) {
            this.removeLobMap = new HashMap();
        }
        this.removeLobMap.put(string, value);
    }

    public void removeAtCommitStop(Value value) {
        if (this.removeLobMap != null) {
            this.removeLobMap.remove(value.toString());
        }
    }

    public String getNextSystemIdentifier(String string) {
        String string2;
        while (string.contains(string2 = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++)) {
        }
        return string2;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.database.newStringMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String string) {
        if (this.procedures != null) {
            this.procedures.remove(string);
        }
    }

    public Procedure getProcedure(String string) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(string);
    }

    public void setSchemaSearchPath(String[] stringArray) {
        ++this.modificationId;
        this.schemaSearchPath = stringArray;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + (this.user == null ? "<null>" : this.user.getName()) + ")";
    }

    public void setUndoLogEnabled(boolean bl) {
        this.undoLogEnabled = bl;
    }

    public void setRedoLogBinary(boolean bl) {
        this.redoLogBinary = bl;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public ValueTimestampTimeZone getTransactionStart() {
        if (this.transactionStart == null) {
            this.transactionStart = CurrentTimestamp.get();
        }
        return this.transactionStart;
    }

    public Table[] getLocks() {
        ArrayList<Table> arrayList = new ArrayList<Table>(this.locks.size());
        for (Table table : this.locks) {
            try {
                arrayList.add(table);
            }
            catch (Exception exception) {
                break;
            }
        }
        return arrayList.toArray(new Table[0]);
    }

    public void waitIfExclusiveModeEnabled() {
        Session session;
        if (this.database.getLobSession() == this) {
            return;
        }
        while ((session = this.database.getExclusiveSession()) != null && session != this && !Thread.holdsLock(session)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Map<Object, ViewIndex> getViewIndexCache(boolean bl) {
        if (bl) {
            if (this.subQueryIndexCache == null) {
                this.subQueryIndexCache = new HashMap();
            }
            return this.subQueryIndexCache;
        }
        SmallLRUCache<Object, ViewIndex> smallLRUCache = this.viewIndexCache;
        if (smallLRUCache == null) {
            this.viewIndexCache = smallLRUCache = SmallLRUCache.newInstance(64);
        }
        return smallLRUCache;
    }

    public void addTemporaryResult(ResultInterface resultInterface) {
        if (!resultInterface.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = new HashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(resultInterface);
        }
    }

    private void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (ResultInterface resultInterface : this.temporaryResults) {
                resultInterface.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int n) {
        int n2 = this.database.getSettings().maxQueryTimeout;
        if (n2 != 0 && (n2 < n || n == 0)) {
            n = n2;
        }
        this.queryTimeout = n;
        this.cancelAtNs = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table table, Thread thread) {
        this.waitForLock = table;
        this.waitForLockThread = thread;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public Thread getWaitForLockThread() {
        return this.waitForLockThread;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean bl) {
        block2: {
            do {
                boolean bl2;
                if (bl2 = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!bl) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public void afterWriting() {
        this.database.afterWriting();
    }

    @Override
    public SessionInterface reconnect(boolean bl) {
        this.readSessionState();
        this.close();
        Session session = Engine.getInstance().createSession(this.connectionInfo);
        session.sessionState = this.sessionState;
        session.recreateSessionState();
        if (bl) {
            while (!session.database.beforeWriting()) {
            }
        }
        return session;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public Value getTransactionId() {
        if (this.database.getStore() != null) {
            if (this.transaction == null || !this.transaction.hasChanges()) {
                return ValueNull.INSTANCE;
            }
            return ValueString.get(Long.toString(this.getTransaction().getSequenceNum()));
        }
        if (!this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        if (this.undoLog == null || this.undoLog.size() == 0) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.redoLogBinary;
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            MVTableEngine.Store store = this.database.getStore();
            if (store != null) {
                if (store.getMvStore().isClosed()) {
                    Throwable throwable = this.database.getBackgroundException();
                    this.database.shutdownImmediately();
                    throw DbException.get(90098, throwable, new String[0]);
                }
                this.transaction = store.getTransactionStore().begin(this, this.lockTimeout, this.id);
            }
            this.startStatement = -1L;
        }
        return this.transaction;
    }

    private long getStatementSavepoint() {
        if (this.startStatement == -1L) {
            this.startStatement = this.getTransaction().setSavepoint();
        }
        return this.startStatement;
    }

    public void startStatementWithinTransaction() {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            transaction.markStatementStart();
        }
        this.startStatement = -1L;
    }

    public void endStatement() {
        if (this.transaction != null) {
            this.transaction.markStatementEnd();
        }
        this.startStatement = -1L;
        this.closeTemporaryResults();
    }

    public void clearViewIndexCache() {
        this.viewIndexCache = null;
    }

    @Override
    public void addTemporaryLob(Value value) {
        if (!DataType.isLargeObject(value.getValueType())) {
            return;
        }
        if (value.getTableId() == -3 || value.getTableId() == -2) {
            if (this.temporaryResultLobs == null) {
                this.temporaryResultLobs = new LinkedList();
            }
            this.temporaryResultLobs.add(new TimeoutValue(value));
        } else {
            if (this.temporaryLobs == null) {
                this.temporaryLobs = new ArrayList();
            }
            this.temporaryLobs.add(value);
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void markTableForAnalyze(Table table) {
        if (this.tablesToAnalyze == null) {
            this.tablesToAnalyze = new HashSet();
        }
        this.tablesToAnalyze.add(table);
    }

    public State getState() {
        return this.getBlockingSessionId() != 0 ? State.BLOCKED : this.state.get();
    }

    public int getBlockingSessionId() {
        return this.transaction == null ? 0 : this.transaction.getBlockerId();
    }

    @Override
    public void onRollback(MVMap<Object, VersionedValue> mVMap, Object object, VersionedValue versionedValue, VersionedValue versionedValue2) {
        MVTable mVTable;
        MVTableEngine.Store store = this.database.getStore();
        if (store != null && (mVTable = store.getTable(mVMap.getName())) != null) {
            long l = ((ValueLong)object).getLong();
            Row row = Session.getRowFromVersionedValue(mVTable, l, versionedValue);
            Row row2 = Session.getRowFromVersionedValue(mVTable, l, versionedValue2);
            mVTable.fireAfterRow(this, row, row2, true);
            if (mVTable.getContainsLargeObject()) {
                Value value;
                int n;
                int n2;
                if (row != null) {
                    n2 = row.getColumnCount();
                    for (n = 0; n < n2; ++n) {
                        value = row.getValue(n);
                        if (!value.isLinkedToTable()) continue;
                        this.removeAtCommit(value);
                    }
                }
                if (row2 != null) {
                    n2 = row2.getColumnCount();
                    for (n = 0; n < n2; ++n) {
                        value = row2.getValue(n);
                        if (!value.isLinkedToTable()) continue;
                        this.removeAtCommitStop(value);
                    }
                }
            }
        }
    }

    private static Row getRowFromVersionedValue(MVTable mVTable, long l, VersionedValue versionedValue) {
        Row row;
        Object object;
        Object object2 = object = versionedValue == null ? null : versionedValue.getCurrentValue();
        if (object == null) {
            return null;
        }
        if (object instanceof Row) {
            row = (Row)object;
            assert (row.getKey() == l) : row.getKey() + " != " + l;
        } else {
            ValueArray valueArray = (ValueArray)object;
            row = mVTable.createRow(valueArray.getList(), 0);
            row.setKey(l);
        }
        return row;
    }

    public ColumnNamerConfiguration getColumnNamerConfiguration() {
        return this.columnNamerConfiguration;
    }

    public void setColumnNamerConfiguration(ColumnNamerConfiguration columnNamerConfiguration) {
        this.columnNamerConfiguration = columnNamerConfiguration;
    }

    @Override
    public boolean isSupportsGeneratedKeys() {
        return true;
    }

    public static class TimeoutValue {
        final long created = System.nanoTime();
        final Value value;

        TimeoutValue(Value value) {
            this.value = value;
        }
    }

    public static class Savepoint {
        int logIndex;
        long transactionSavepoint;
    }

    public static enum State {
        INIT,
        RUNNING,
        BLOCKED,
        SLEEP,
        CLOSED;

    }
}

