/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h14199.engine.Database;
import org.h14199.engine.DbObject;
import org.h14199.engine.DbObjectBase;
import org.h14199.engine.Right;
import org.h14199.engine.Role;
import org.h14199.table.Table;
import org.h14199.util.StringUtils;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap<Role, Right> grantedRoles;
    private HashMap<DbObject, Right> grantedRights;

    protected RightOwner(Database database, int n, String string, int n2) {
        super(database, n, StringUtils.toUpperEnglish(string), n2);
    }

    @Override
    public void rename(String string) {
        super.rename(StringUtils.toUpperEnglish(string));
    }

    public boolean isRoleGranted(Role role) {
        if (role == this) {
            return true;
        }
        if (this.grantedRoles != null) {
            for (Role role2 : this.grantedRoles.keySet()) {
                if (role2 == role) {
                    return true;
                }
                if (!role2.isRoleGranted(role)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRightGrantedRecursive(Table table, int n) {
        if (this.grantedRights != null) {
            Right right;
            if (table != null && (right = this.grantedRights.get(table.getSchema())) != null && (right.getRightMask() & n) == n) {
                return true;
            }
            right = this.grantedRights.get(table);
            if (right != null && (right.getRightMask() & n) == n) {
                return true;
            }
        }
        if (this.grantedRoles != null) {
            for (RightOwner rightOwner : this.grantedRoles.keySet()) {
                if (!rightOwner.isRightGrantedRecursive(table, n)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(DbObject dbObject, Right right) {
        if (this.grantedRights == null) {
            this.grantedRights = new HashMap();
        }
        this.grantedRights.put(dbObject, right);
    }

    void revokeRight(DbObject dbObject) {
        if (this.grantedRights == null) {
            return;
        }
        this.grantedRights.remove(dbObject);
        if (this.grantedRights.size() == 0) {
            this.grantedRights = null;
        }
    }

    public void grantRole(Role role, Right right) {
        if (this.grantedRoles == null) {
            this.grantedRoles = new HashMap();
        }
        this.grantedRoles.put(role, right);
    }

    void revokeRole(Role role) {
        if (this.grantedRoles == null) {
            return;
        }
        Right right = this.grantedRoles.get(role);
        if (right == null) {
            return;
        }
        this.grantedRoles.remove(role);
        if (this.grantedRoles.size() == 0) {
            this.grantedRoles = null;
        }
    }

    public void revokeTemporaryRightsOnRoles() {
        if (this.grantedRoles == null) {
            return;
        }
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (Map.Entry<Role, Right> entry : this.grantedRoles.entrySet()) {
            if (!entry.getValue().isTemporary() && entry.getValue().isValid()) continue;
            arrayList.add(entry.getKey());
        }
        for (Role role : arrayList) {
            this.revokeRole(role);
        }
    }

    public Right getRightForObject(DbObject dbObject) {
        if (this.grantedRights == null) {
            return null;
        }
        return this.grantedRights.get(dbObject);
    }

    public Right getRightForRole(Role role) {
        if (this.grantedRoles == null) {
            return null;
        }
        return this.grantedRoles.get(role);
    }
}

