/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.constraint;

import java.util.ArrayList;
import java.util.HashSet;
import org.h14199.command.Prepared;
import org.h14199.constraint.Constraint;
import org.h14199.constraint.ConstraintActionType;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.Parameter;
import org.h14199.index.Cursor;
import org.h14199.index.Index;
import org.h14199.message.DbException;
import org.h14199.result.ResultInterface;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.schema.Schema;
import org.h14199.table.Column;
import org.h14199.table.IndexColumn;
import org.h14199.table.Table;
import org.h14199.util.StringUtils;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    private IndexColumn[] columns;
    private IndexColumn[] refColumns;
    private ConstraintActionType deleteAction = ConstraintActionType.RESTRICT;
    private ConstraintActionType updateAction = ConstraintActionType.RESTRICT;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.REFERENTIAL;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, this.refTable, string, true);
    }

    public String getCreateSQLForCopy(Table table, Table table2, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        table.getSQL(stringBuilder, true).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        IndexColumn[] indexColumnArray = this.columns;
        IndexColumn[] indexColumnArray2 = this.refColumns;
        stringBuilder.append(" FOREIGN KEY(");
        IndexColumn.writeColumns(stringBuilder, indexColumnArray, true);
        stringBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            stringBuilder.append(" INDEX ");
            this.index.getSQL(stringBuilder, true);
        }
        stringBuilder.append(" REFERENCES ");
        if (this.table == this.refTable) {
            table.getSQL(stringBuilder, true);
        } else {
            table2.getSQL(stringBuilder, true);
        }
        stringBuilder.append('(');
        IndexColumn.writeColumns(stringBuilder, indexColumnArray2, true);
        stringBuilder.append(')');
        if (bl && this.refIndexOwner && table == this.table) {
            stringBuilder.append(" INDEX ");
            this.refIndex.getSQL(stringBuilder, true);
        }
        if (this.deleteAction != ConstraintActionType.RESTRICT) {
            stringBuilder.append(" ON DELETE ").append(this.deleteAction.getSqlName());
        }
        if (this.updateAction != ConstraintActionType.RESTRICT) {
            stringBuilder.append(" ON UPDATE ").append(this.updateAction.getSqlName());
        }
        return stringBuilder.append(" NOCHECK").toString();
    }

    private String getShortDescription(Index index, SearchRow searchRow) {
        StringBuilder stringBuilder = new StringBuilder(this.getName()).append(": ");
        this.table.getSQL(stringBuilder, false).append(" FOREIGN KEY(");
        IndexColumn.writeColumns(stringBuilder, this.columns, false);
        stringBuilder.append(") REFERENCES ");
        this.refTable.getSQL(stringBuilder, false).append('(');
        IndexColumn.writeColumns(stringBuilder, this.refColumns, false);
        stringBuilder.append(')');
        if (index != null && searchRow != null) {
            stringBuilder.append(" (");
            Column[] columnArray = index.getColumns();
            int n = Math.min(this.columns.length, columnArray.length);
            for (int i = 0; i < n; ++i) {
                int n2 = columnArray[i].getColumnId();
                Value value = searchRow.getValue(n2);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(value == null ? "" : value.toString());
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(true), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet;
        block3: {
            block2: {
                hashSet = new HashSet<Column>();
                if (table != this.table) break block2;
                for (IndexColumn indexColumn : this.columns) {
                    hashSet.add(indexColumn.column);
                }
                break block3;
            }
            if (table != this.refTable) break block3;
            for (IndexColumn indexColumn : this.refColumns) {
                hashSet.add(indexColumn.column);
            }
        }
        return hashSet;
    }

    public void setRefColumns(IndexColumn[] indexColumnArray) {
        this.refColumns = indexColumnArray;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table table) {
        this.refTable = table;
        if (table.isTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void setRefIndex(Index index, boolean bl) {
        this.refIndex = index;
        this.refIndexOwner = bl;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (table == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, row, row2);
        }
        if (table == this.refTable) {
            this.checkRowRefTable(session, row, row2);
        }
    }

    private void checkRowOwnTable(Session session, Row row, Row row2) {
        int n;
        int n2;
        int n3;
        Object object;
        if (row2 == null) {
            return;
        }
        boolean bl = row != null;
        for (IndexColumn indexColumn : this.columns) {
            int n4 = indexColumn.column.getColumnId();
            object = row2.getValue(n4);
            if (object == ValueNull.INSTANCE) {
                return;
            }
            if (!bl || this.database.areEqual((Value)object, row.getValue(n4))) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.refTable == this.table) {
            boolean bl2 = true;
            n3 = this.columns.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = this.columns[n2].column.getColumnId();
                Value value = row2.getValue(n5);
                object = this.refColumns[n2].column;
                n = ((Column)object).getColumnId();
                Value value2 = row2.getValue(n);
                if (this.database.areEqual(value2, value)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return;
            }
        }
        Row row3 = this.refTable.getTemplateRow();
        n3 = this.columns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = this.columns[n2].column.getColumnId();
            Value value = row2.getValue(n6);
            object = this.refColumns[n2].column;
            n = ((Column)object).getColumnId();
            row3.setValue(n, ((Column)object).convert(value));
        }
        if (!this.existsRow(session, this.refIndex, row3, null)) {
            throw DbException.get(23506, this.getShortDescription(this.refIndex, row3));
        }
    }

    private boolean existsRow(Session session, Index index, SearchRow searchRow, Row row) {
        Table table = index.getTable();
        table.lock(session, false, false);
        Cursor cursor = index.find(session, searchRow, searchRow);
        while (cursor.next()) {
            SearchRow searchRow2 = cursor.getSearchRow();
            if (row != null && searchRow2.getKey() == row.getKey()) continue;
            Column[] columnArray = index.getColumns();
            boolean bl = true;
            int n = Math.min(this.columns.length, columnArray.length);
            for (int i = 0; i < n; ++i) {
                Value value;
                int n2 = columnArray[i].getColumnId();
                Value value2 = searchRow.getValue(n2);
                if (table.compareValues(value2, value = searchRow2.getValue(n2)) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row row, Row row2) {
        return this.refIndex.compareRows(row, row2) == 0;
    }

    private void checkRow(Session session, Row row) {
        Row row2;
        SearchRow searchRow = this.table.getTemplateSimpleRow(false);
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            Column column = this.columns[i].column;
            Column column2 = this.refColumns[i].column;
            int n2 = column2.getColumnId();
            Value value = column.convert(row.getValue(n2));
            if (value == ValueNull.INSTANCE) {
                return;
            }
            searchRow.setValue(column.getColumnId(), value);
        }
        Row row3 = row2 = this.refTable == this.table ? row : null;
        if (this.existsRow(session, this.index, searchRow, row2)) {
            throw DbException.get(23503, this.getShortDescription(this.index, searchRow));
        }
    }

    private void checkRowRefTable(Session session, Row row, Row row2) {
        if (row == null) {
            return;
        }
        if (row2 != null && this.isEqual(row, row2)) {
            return;
        }
        if (row2 == null) {
            if (this.deleteAction == ConstraintActionType.RESTRICT) {
                this.checkRow(session, row);
            } else {
                int n = this.deleteAction == ConstraintActionType.CASCADE ? 0 : this.columns.length;
                Prepared prepared = this.getDelete(session);
                this.setWhere(prepared, n, row);
                this.updateWithSkipCheck(prepared);
            }
        } else if (this.updateAction == ConstraintActionType.RESTRICT) {
            this.checkRow(session, row);
        } else {
            Prepared prepared = this.getUpdate(session);
            if (this.updateAction == ConstraintActionType.CASCADE) {
                ArrayList<Parameter> arrayList = prepared.getParameters();
                int n = this.columns.length;
                for (int i = 0; i < n; ++i) {
                    Parameter parameter = arrayList.get(i);
                    Column column = this.refColumns[i].column;
                    parameter.setValue(row2.getValue(column.getColumnId()));
                }
            }
            this.setWhere(prepared, this.columns.length, row);
            this.updateWithSkipCheck(prepared);
        }
    }

    private void updateWithSkipCheck(Prepared prepared) {
        try {
            this.skipOwnTable = true;
            prepared.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    private void setWhere(Prepared prepared, int n, Row row) {
        int n2 = this.refColumns.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.refColumns[i].column.getColumnId();
            Value value = row.getValue(n3);
            ArrayList<Parameter> arrayList = prepared.getParameters();
            Parameter parameter = arrayList.get(n + i);
            parameter.setValue(value);
        }
    }

    public ConstraintActionType getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(ConstraintActionType constraintActionType) {
        if (constraintActionType == this.deleteAction && this.deleteSQL == null) {
            return;
        }
        if (this.deleteAction != ConstraintActionType.RESTRICT) {
            throw DbException.get(90045, "ON DELETE");
        }
        this.deleteAction = constraintActionType;
        this.buildDeleteSQL();
    }

    public void updateOnTableColumnRename() {
        if (this.deleteAction != null) {
            this.deleteSQL = null;
            this.buildDeleteSQL();
        }
        if (this.updateAction != null) {
            this.updateSQL = null;
            this.buildUpdateSQL();
        }
    }

    private void buildDeleteSQL() {
        if (this.deleteAction == ConstraintActionType.RESTRICT) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.deleteAction == ConstraintActionType.CASCADE) {
            stringBuilder.append("DELETE FROM ");
            this.table.getSQL(stringBuilder, true);
        } else {
            this.appendUpdate(stringBuilder);
        }
        this.appendWhere(stringBuilder);
        this.deleteSQL = stringBuilder.toString();
    }

    private Prepared getUpdate(Session session) {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public ConstraintActionType getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(ConstraintActionType constraintActionType) {
        if (constraintActionType == this.updateAction && this.updateSQL == null) {
            return;
        }
        if (this.updateAction != ConstraintActionType.RESTRICT) {
            throw DbException.get(90045, "ON UPDATE");
        }
        this.updateAction = constraintActionType;
        this.buildUpdateSQL();
    }

    private void buildUpdateSQL() {
        if (this.updateAction == ConstraintActionType.RESTRICT) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendUpdate(stringBuilder);
        this.appendWhere(stringBuilder);
        this.updateSQL = stringBuilder.toString();
    }

    @Override
    public void rebuild() {
        this.buildUpdateSQL();
        this.buildDeleteSQL();
    }

    private Prepared prepare(Session session, String string, ConstraintActionType constraintActionType) {
        Prepared prepared = session.prepare(string);
        if (constraintActionType != ConstraintActionType.CASCADE) {
            ArrayList<Parameter> arrayList = prepared.getParameters();
            int n = this.columns.length;
            for (int i = 0; i < n; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter parameter = arrayList.get(i);
                if (constraintActionType == ConstraintActionType.SET_NULL) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expression = column.getDefaultExpression();
                    if (expression == null) {
                        throw DbException.get(23507, column.getName());
                    }
                    value = expression.getValue(session);
                }
                parameter.setValue(value);
            }
        }
        return prepared;
    }

    private void appendUpdate(StringBuilder stringBuilder) {
        stringBuilder.append("UPDATE ");
        this.table.getSQL(stringBuilder, true).append(" SET ");
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.columns[i].column.getSQL(stringBuilder, true).append("=?");
        }
    }

    private void appendWhere(StringBuilder stringBuilder) {
        stringBuilder.append(" WHERE ");
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(" AND ");
            }
            this.columns[i].column.getSQL(stringBuilder, true).append("=?");
        }
    }

    @Override
    public Table getRefTable() {
        return this.refTable;
    }

    @Override
    public boolean usesIndex(Index index) {
        return index == this.index || index == this.refIndex;
    }

    @Override
    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            DbException.throwInternalError(index + " " + this.toString());
        }
    }

    @Override
    public boolean isBefore() {
        return false;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        session.startStatementWithinTransaction();
        StringBuilder stringBuilder = new StringBuilder("SELECT 1 FROM (SELECT ");
        IndexColumn.writeColumns(stringBuilder, this.columns, true);
        stringBuilder.append(" FROM ");
        this.table.getSQL(stringBuilder, true).append(" WHERE ");
        IndexColumn.writeColumns(stringBuilder, this.columns, " AND ", " IS NOT NULL ", true);
        stringBuilder.append(" ORDER BY ");
        IndexColumn.writeColumns(stringBuilder, this.columns, true);
        stringBuilder.append(") C WHERE NOT EXISTS(SELECT 1 FROM ");
        this.refTable.getSQL(stringBuilder, true).append(" P WHERE ");
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("C.");
            this.columns[i].getSQL(stringBuilder, true).append('=').append("P.");
            this.refColumns[i].getSQL(stringBuilder, true);
        }
        stringBuilder.append(')');
        ResultInterface resultInterface = session.prepare(stringBuilder.toString()).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23506, this.getShortDescription(null, null));
        }
    }

    @Override
    public Index getUniqueIndex() {
        return this.refIndex;
    }
}

