/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.constraint;

import java.util.HashSet;
import org.h14199.constraint.Constraint;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.index.Index;
import org.h14199.message.DbException;
import org.h14199.result.ResultInterface;
import org.h14199.result.Row;
import org.h14199.schema.Schema;
import org.h14199.table.Column;
import org.h14199.table.Table;
import org.h14199.table.TableFilter;
import org.h14199.util.StringUtils;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.CHECK;
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.filter = tableFilter;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        table.getSQL(stringBuilder, true).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        stringBuilder.append(" CHECK(");
        this.expr.getUnenclosedSQL(stringBuilder, true).append(") NOCHECK");
        return stringBuilder.toString();
    }

    private String getShortDescription() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getName()).append(": ");
        this.expr.getSQL(stringBuilder, false);
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        boolean bl;
        if (row2 == null) {
            return;
        }
        this.filter.set(row2);
        try {
            Value value = this.expr.getValue(session);
            bl = value == ValueNull.INSTANCE || value.getBoolean();
        }
        catch (DbException dbException) {
            throw DbException.get(23514, dbException, this.getShortDescription());
        }
        if (!bl) {
            throw DbException.get(23513, this.getShortDescription());
        }
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(hashSet, table));
        return hashSet;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("SELECT 1 FROM ");
        this.filter.getTable().getSQL(stringBuilder, true).append(" WHERE NOT(");
        this.expr.getSQL(stringBuilder, true).append(')');
        String string = stringBuilder.toString();
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23513, this.getName());
        }
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }
}

