/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.h14199.command.Prepared;
import org.h14199.command.dml.AllColumnsForPlan;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.Parameter;
import org.h14199.expression.ValueExpression;
import org.h14199.message.DbException;
import org.h14199.result.ResultInterface;
import org.h14199.result.Row;
import org.h14199.result.RowList;
import org.h14199.table.Column;
import org.h14199.table.PlanItem;
import org.h14199.table.Table;
import org.h14199.table.TableFilter;
import org.h14199.util.Utils;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private TableFilter sourceTableFilter;
    private Expression limitExpr;
    private boolean updateToCurrentValuesReturnsZero;
    private final ArrayList<Column> columns = Utils.newSmallArrayList();
    private final HashMap<Column, Expression> expressionMap = new HashMap();
    private HashSet<Long> updatedKeysCollector;

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.expressionMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.columns.add(column);
        this.expressionMap.put(column, expression);
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    public void setUpdatedKeysCollector(HashSet<Long> hashSet) {
        this.updatedKeysCollector = hashSet;
    }

    @Override
    public int update() {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        try (RowList rowList = new RowList(this.session);){
            Row row;
            Object object;
            Table table = this.targetTableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            int n = table.getColumns().length;
            this.setCurrentRowNumber(0L);
            int n2 = 0;
            Column[] columnArray = table.getColumns();
            int n3 = -1;
            if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = ((Value)object).getInt();
            }
            while (this.targetTableFilter.next()) {
                Object object2;
                this.setCurrentRowNumber(n2 + 1);
                if (n3 >= 0 && n2 >= n3) break;
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                object = this.targetTableFilter.get();
                if (table.isMVStore()) {
                    row = table.lockRow(this.session, (Row)object);
                    if (row == null) continue;
                    if (!object.hasSharedData(row)) {
                        object = row;
                        this.targetTableFilter.set((Row)object);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                row = table.getTemplateRow();
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    Expression expression = this.expressionMap.get(columnArray[i]);
                    Column column = table.getColumn(i);
                    if (expression == null) {
                        if (column.getOnUpdateExpression() != null) {
                            bl = true;
                        }
                        object2 = object.getValue(i);
                    } else {
                        object2 = expression == ValueExpression.getDefault() ? table.getDefaultValue(this.session, column) : column.convert(expression.getValue(this.session), this.session.getDatabase().getMode());
                    }
                    row.setValue(i, (Value)object2);
                }
                long l = object.getKey();
                row.setKey(l);
                if (bl || this.updateToCurrentValuesReturnsZero) {
                    int n4;
                    bl = false;
                    for (n4 = 0; n4 < n; ++n4) {
                        if (Objects.equals(object.getValue(n4), row.getValue(n4))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        for (n4 = 0; n4 < n; ++n4) {
                            if (this.expressionMap.get(columnArray[n4]) != null || ((Column)(object2 = table.getColumn(n4))).getOnUpdateExpression() == null) continue;
                            row.setValue(n4, table.getOnUpdateValue(this.session, (Column)object2));
                        }
                    } else if (this.updateToCurrentValuesReturnsZero) {
                        --n2;
                    }
                }
                table.validateConvertUpdateSequence(this.session, row);
                if (!table.fireRow() || !table.fireBeforeRow(this.session, (Row)object, row)) {
                    rowList.add((Row)object);
                    rowList.add(row);
                    if (this.updatedKeysCollector != null) {
                        this.updatedKeysCollector.add(l);
                    }
                }
                ++n2;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    object = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, (Row)object, row, false);
                }
            }
            table.fire(this.session, 2, false);
            int n5 = n2;
            return n5;
        }
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.targetTableFilter.getPlanSQL(stringBuilder, false, bl).append("\nSET\n    ");
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(",\n    ");
            }
            Column column = this.columns.get(i);
            column.getSQL(stringBuilder, bl).append(" = ");
            this.expressionMap.get(column).getSQL(stringBuilder, bl);
        }
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ");
            this.limitExpr.getUnenclosedSQL(stringBuilder, bl);
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        for (Column object2 : this.columns) {
            Expression expression = this.expressionMap.get(object2);
            expression.mapColumns(this.targetTableFilter, 0, 0);
            if (this.sourceTableFilter != null) {
                expression.mapColumns(this.sourceTableFilter, 0, 0);
            }
            this.expressionMap.put(object2, expression.optimize(this.session));
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, new AllColumnsForPlan(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public void setUpdateToCurrentValuesReturnsZero(boolean bl) {
        this.updateToCurrentValuesReturnsZero = bl;
    }
}

