/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h14199.command.Prepared;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.message.DbException;
import org.h14199.mvstore.MVStore;
import org.h14199.mvstore.db.MVTableEngine;
import org.h14199.result.ResultInterface;
import org.h14199.store.FileLister;
import org.h14199.store.PageStore;
import org.h14199.store.fs.FileUtils;
import org.h14199.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public int update() {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            MVTableEngine.Store store = database.getStore();
            if (store != null) {
                store.flush();
            }
            String string2 = database.getName();
            string2 = FileUtils.getName(string2);
            try (OutputStream outputStream = FileUtils.newOutputStream(string, false);){
                Object object;
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                database.flush();
                if (database.getPageStore() != null) {
                    object = database.getName() + ".h2.db";
                    this.backupPageStore(zipOutputStream, (String)object, database.getPageStore());
                }
                object = FileUtils.getParent(database.getName());
                Object object2 = database.getLobSyncObject();
                synchronized (object2) {
                    String string3 = database.getDatabasePath();
                    String string4 = FileUtils.getParent(string3);
                    string4 = FileLister.getDir(string4);
                    ArrayList<String> arrayList = FileLister.getDatabaseFiles(string4, string2, true);
                    for (String string5 : arrayList) {
                        if (string5.endsWith(".lob.db")) {
                            BackupCommand.backupFile(zipOutputStream, (String)object, string5);
                        }
                        if (!string5.endsWith(".mv.db") || store == null) continue;
                        MVStore mVStore = store.getMvStore();
                        boolean bl = mVStore.getReuseSpace();
                        mVStore.setReuseSpace(false);
                        try {
                            InputStream inputStream = store.getInputStream();
                            BackupCommand.backupFile(zipOutputStream, (String)object, string5, inputStream);
                        }
                        finally {
                            mVStore.setReuseSpace(bl);
                        }
                    }
                }
                zipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = 0;
        try {
            pageStore.setBackup(true);
            while ((n = pageStore.copyDirect(n, zipOutputStream)) >= 0) {
                int n2 = pageStore.getPageCount();
                database.setProgress(3, string, n, n2);
            }
        }
        finally {
            pageStore.setBackup(false);
        }
        zipOutputStream.closeEntry();
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        InputStream inputStream = FileUtils.newInputStream(string2);
        BackupCommand.backupFile(zipOutputStream, string, string2, inputStream);
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2, InputStream inputStream) throws IOException {
        String string3 = FileUtils.toRealPath(string2);
        if (!string3.startsWith(string = FileUtils.toRealPath(string))) {
            DbException.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

