/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.ddl;

import java.util.ArrayList;
import org.h14199.command.ddl.DefineCommand;
import org.h14199.engine.Database;
import org.h14199.engine.DbObject;
import org.h14199.engine.DbObjectBase;
import org.h14199.engine.Role;
import org.h14199.engine.Session;
import org.h14199.engine.User;
import org.h14199.schema.Schema;
import org.h14199.schema.SchemaObject;
import org.h14199.schema.Sequence;
import org.h14199.table.Table;
import org.h14199.table.TableType;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        ArrayList<SchemaObject> arrayList;
        boolean bl;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        database.lockMeta(this.session);
        do {
            arrayList = database.getAllTablesAndViews(false);
            ArrayList<Table> object32 = new ArrayList<Table>(arrayList.size());
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || TableType.VIEW != ((Table)object).getTableType()) continue;
                object32.add((Table)object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || TableType.TABLE_LINK != ((Table)object).getTableType()) continue;
                object32.add((Table)object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || TableType.TABLE != ((Table)object).getTableType() || ((Table)object).isHidden()) continue;
                object32.add((Table)object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || TableType.EXTERNAL_TABLE_ENGINE != ((Table)object).getTableType() || ((Table)object).isHidden()) continue;
                object32.add((Table)object);
            }
            bl = false;
            for (Object object : object32) {
                if (((DbObjectBase)object).getName() == null) continue;
                if (database.getDependentTable((SchemaObject)object, (Table)object) == null) {
                    database.removeSchemaObject(this.session, (SchemaObject)object);
                    continue;
                }
                bl = true;
            }
        } while (bl);
        for (Schema schema : database.getAllSchemas()) {
            if (!schema.canDrop()) continue;
            database.removeDatabaseObject(this.session, schema);
        }
        arrayList = new ArrayList<SchemaObject>();
        for (SchemaObject schemaObject : database.getAllSchemaObjects(3)) {
            if (((Sequence)schemaObject).getBelongsToTable()) continue;
            arrayList.add(schemaObject);
        }
        arrayList.addAll(database.getAllSchemaObjects(5));
        arrayList.addAll(database.getAllSchemaObjects(4));
        arrayList.addAll(database.getAllSchemaObjects(11));
        arrayList.addAll(database.getAllSchemaObjects(9));
        for (SchemaObject schemaObject : arrayList) {
            if (schemaObject.isHidden()) continue;
            database.removeSchemaObject(this.session, schemaObject);
        }
        for (User user : database.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            database.removeDatabaseObject(this.session, user);
        }
        for (Role role : database.getAllRoles()) {
            Object object;
            object = role.getCreateSQL();
            if (object == null) continue;
            database.removeDatabaseObject(this.session, role);
        }
        ArrayList<DbObjectBase> arrayList2 = new ArrayList<DbObjectBase>();
        arrayList2.addAll(database.getAllRights());
        arrayList2.addAll(database.getAllAggregates());
        arrayList2.addAll(database.getAllDomains());
        for (Object object : arrayList2) {
            String string = object.getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, (DbObject)object);
        }
    }

    public void setDropAllObjects(boolean bl) {
        this.dropAllObjects = bl;
    }

    public void setDeleteFiles(boolean bl) {
        this.deleteFiles = bl;
    }

    @Override
    public int getType() {
        return 38;
    }
}

