/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.ddl;

import org.h14199.command.ddl.SchemaCommand;
import org.h14199.command.dml.Query;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.message.DbException;
import org.h14199.schema.Schema;
import org.h14199.table.Column;
import org.h14199.table.Table;
import org.h14199.table.TableType;
import org.h14199.table.TableView;
import org.h14199.value.TypeInfo;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean orReplace;
    private boolean force;
    private boolean isTableExpression;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public void setSelect(Query query) {
        this.select = query;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setSelectSQL(String string) {
        this.selectSQL = string;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setOrReplace(boolean bl) {
        this.orReplace = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setTableExpression(boolean bl) {
        this.isTableExpression = bl;
    }

    @Override
    public int update() {
        Column[] columnArray;
        String string;
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        TableView tableView = null;
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table != null) {
            if (this.ifNotExists) {
                return 0;
            }
            if (!this.orReplace || TableType.VIEW != table.getTableType()) {
                throw DbException.get(90038, this.viewName);
            }
            tableView = (TableView)table;
        }
        int n = this.getObjectId();
        if (this.select == null) {
            string = this.selectSQL;
        } else {
            columnArray = this.select.getParameters();
            if (columnArray != null && !columnArray.isEmpty()) {
                throw DbException.getUnsupportedException("parameters in views");
            }
            string = this.select.getPlanSQL(true);
        }
        columnArray = null;
        Column[] columnArray2 = null;
        if (this.columnNames != null) {
            columnArray = new Column[this.columnNames.length];
            columnArray2 = new Column[this.columnNames.length];
            for (int i = 0; i < this.columnNames.length; ++i) {
                columnArray[i] = new Column(this.columnNames[i], TypeInfo.TYPE_UNKNOWN);
                columnArray2[i] = new Column(this.columnNames[i], 13);
            }
        }
        if (tableView == null) {
            tableView = this.isTableExpression ? TableView.createTableViewMaybeRecursive(this.getSchema(), n, this.viewName, string, null, columnArray2, this.session, false, this.isTableExpression, false, database) : new TableView(this.getSchema(), n, this.viewName, string, null, columnArray, this.session, false, false, this.isTableExpression, false);
        } else {
            tableView.replace(string, columnArray, this.session, false, this.force, false);
            tableView.setModified();
        }
        if (this.comment != null) {
            tableView.setComment(this.comment);
        }
        if (table == null) {
            database.addSchemaObject(this.session, tableView);
            database.unlockMeta(this.session);
        } else {
            database.updateMeta(this.session, tableView);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 34;
    }
}

