/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.serialize;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.serialize.AbstractXmlIO;
import de.willuhn.datasource.serialize.Writer;
import de.willuhn.logging.Logger;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class XmlWriter
extends AbstractXmlIO
implements Writer {
    private OutputStream os = null;
    private boolean headerWritten = false;
    private static final Map XML_MAP = new HashMap();

    public XmlWriter(OutputStream os) {
        this.os = new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                try {
                    Logger.debug((String)"closing xml file");
                    this.write("</objects>".getBytes("UTF-8"));
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public String[] getAttributeNames(GenericObject object) throws RemoteException {
        return object.getAttributeNames();
    }

    @Override
    public synchronized void write(GenericObject object) throws IOException {
        if (!this.headerWritten) {
            Logger.debug((String)"writing xml header");
            this.os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<objects>\n".getBytes("UTF-8"));
            this.headerWritten = true;
        }
        Logger.debug((String)("serializing object: " + object.getClass().getName() + ":" + object.getID()));
        StringBuffer sb = new StringBuffer();
        sb.append("  <object type=\"");
        sb.append(object.getClass().getName());
        sb.append("\" id=\"");
        sb.append(object.getID());
        sb.append("\">\n");
        String[] names = this.getAttributeNames(object);
        for (int i = 0; i < names.length; ++i) {
            Object o = object.getAttribute(names[i]);
            if (o == null) continue;
            String type = o.getClass().getName();
            if (o instanceof GenericObject) {
                type = Integer.class.getName();
                o = ((GenericObject)o).getID();
            }
            sb.append("    <");
            sb.append(names[i]);
            sb.append(" type=\"");
            sb.append(type);
            sb.append("\">");
            AbstractXmlIO.Value v = (AbstractXmlIO.Value)valueMap.get(type);
            if (v == null) {
                v = (AbstractXmlIO.Value)valueMap.get(null);
            }
            sb.append(this.encode(v.serialize(o)));
            sb.append("</");
            sb.append(names[i]);
            sb.append(">\n");
        }
        sb.append("  </object>\n");
        this.os.write(sb.toString().getBytes("UTF-8"));
    }

    private String encode(String s) {
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            String replacement = (String)XML_MAP.get(new Character(chars[i]));
            if (replacement == null) {
                sb.append(chars[i]);
                continue;
            }
            sb.append(replacement);
        }
        return sb.toString();
    }

    static {
        XML_MAP.put(new Character('&'), "&amp;");
        XML_MAP.put(new Character('\''), "&apos;");
        XML_MAP.put(new Character('\"'), "&quot;");
        XML_MAP.put(new Character('<'), "&lt;");
        XML_MAP.put(new Character('>'), "&gt;");
    }
}

