/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.serialize;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.serialize.AbstractXmlIO;
import de.willuhn.datasource.serialize.ObjectFactory;
import de.willuhn.datasource.serialize.Reader;
import de.willuhn.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReader
extends AbstractXmlIO
implements Reader {
    private InputStream is = null;
    private ObjectFactory factory = null;
    private Document doc = null;
    private int pos = 0;

    public XmlReader(InputStream is, ObjectFactory factory) throws Exception {
        this.is = is;
        this.factory = factory;
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
    }

    @Override
    public GenericObject read() throws IOException {
        Node current;
        NodeList objects = this.doc.getElementsByTagName("object");
        if (objects == null || objects.getLength() == 0) {
            return null;
        }
        if ((current = objects.item(this.pos++)) == null) {
            return null;
        }
        NamedNodeMap attributes = current.getAttributes();
        String type = attributes.getNamedItem("type").getNodeValue();
        Node nid = attributes.getNamedItem("id");
        String id = nid != null ? nid.getNodeValue() : null;
        HashMap<String, Object> values = new HashMap<String, Object>();
        NodeList list = current.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getNodeName();
            String vType = n.getAttributes().getNamedItem("type").getNodeValue();
            String value = null;
            try {
                value = n.getLastChild().getNodeValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            AbstractXmlIO.Value v = (AbstractXmlIO.Value)valueMap.get(vType);
            if (v == null) {
                v = (AbstractXmlIO.Value)valueMap.get(null);
            }
            values.put(name, v.unserialize(value));
        }
        try {
            return this.factory.create(type, id, values);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e2) {
            Logger.error((String)("unable to create object " + type + ":" + id), (Throwable)e2);
            throw new IOException("unable to create object " + type + ":" + id);
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

