/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.TextPrintPiece;
import net.sf.paperclips.TextStyle;
import net.sf.paperclips.internal.ResourcePool;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class TextPiece
implements TextPrintPiece {
    private final Point size;
    private final String[] lines;
    private final TextStyle style;
    private final int ascent;
    private final ResourcePool resources;

    TextPiece(Device device, TextStyle style, String[] text, Point size, int ascent) {
        Util.notNull(device, size, style);
        Util.noNulls(text);
        this.size = size;
        this.lines = text;
        this.style = style;
        this.ascent = ascent;
        this.resources = ResourcePool.forDevice(device);
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    public int getAscent() {
        return this.ascent;
    }

    public void paint(GC gc, int x, int y) {
        Font oldFont = gc.getFont();
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        int width = this.getSize().x;
        int align = this.style.getAlignment();
        try {
            boolean transparent = this.initGC(gc);
            FontMetrics fm = gc.getFontMetrics();
            int lineHeight = fm.getHeight();
            boolean strikeout = this.style.getStrikeout();
            boolean underline = this.style.getUnderline();
            int lineThickness = Math.max(1, fm.getDescent() / 3);
            int strikeoutOffset = fm.getLeading() + fm.getAscent() / 2;
            int underlineOffset = this.ascent + lineThickness;
            int i = 0;
            while (i < this.lines.length) {
                String line = this.lines[i];
                int lineWidth = gc.stringExtent((String)line).x;
                int offset = this.getHorzAlignmentOffset(align, lineWidth, width);
                gc.drawString(this.lines[i], x + offset, y + lineHeight * i, transparent);
                if (strikeout || underline) {
                    Color saveBackground = gc.getBackground();
                    gc.setBackground(gc.getForeground());
                    if (strikeout) {
                        gc.fillRectangle(x + offset, y + lineHeight * i + strikeoutOffset, lineWidth, lineThickness);
                    }
                    if (underline) {
                        gc.fillRectangle(x + offset, y + lineHeight * i + underlineOffset, lineWidth, lineThickness);
                    }
                    gc.setBackground(saveBackground);
                }
                ++i;
            }
        }
        finally {
            this.restoreGC(gc, oldFont, oldForeground, oldBackground);
        }
    }

    private boolean initGC(GC gc) {
        this.initGCFont(gc);
        this.initGCForeground(gc);
        boolean transparent = this.initGCBackground(gc);
        return transparent;
    }

    private void restoreGC(GC gc, Font font, Color foreground, Color background) {
        gc.setFont(font);
        gc.setForeground(foreground);
        gc.setBackground(background);
    }

    private int getHorzAlignmentOffset(int align, int lineWidth, int totalWidth) {
        if (align == 0x1000000) {
            return (totalWidth - lineWidth) / 2;
        }
        if (align == 131072) {
            return totalWidth - lineWidth;
        }
        return 0;
    }

    private boolean initGCBackground(GC gc) {
        boolean transparent;
        Color background = this.resources.getColor(this.style.getBackground());
        boolean bl = transparent = background == null;
        if (!transparent) {
            gc.setBackground(background);
        }
        return transparent;
    }

    private void initGCForeground(GC gc) {
        Color foreground = this.resources.getColor(this.style.getForeground());
        if (foreground != null) {
            gc.setForeground(foreground);
        }
    }

    private void initGCFont(GC gc) {
        Font font = this.resources.getFont(this.style.getFontData());
        if (font != null) {
            gc.setFont(font);
        }
    }

    public void dispose() {
    }
}

