/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.paperclips.CompositeEntry;
import net.sf.paperclips.CompositePiece;
import net.sf.paperclips.LayerEntry;
import net.sf.paperclips.LayerEntryIterator;
import net.sf.paperclips.LayerPrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.PrintSizeStrategy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class LayerIterator
implements PrintIterator {
    LayerEntryIterator[] entries;

    LayerIterator(LayerPrint print, Device device, GC gc) {
        this.entries = new LayerEntryIterator[print.entries.size()];
        LayerEntry[] e = print.getEntries();
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = e[i].iterator(device, gc);
            ++i;
        }
    }

    LayerIterator(LayerIterator that) {
        this.entries = (LayerEntryIterator[])that.entries.clone();
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].target.hasNext()) {
                this.entries[i] = this.entries[i].copy();
            }
            ++i;
        }
    }

    public boolean hasNext() {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].target.hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PrintPiece next(int width, int height) {
        PrintPiece[] pieces;
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        if ((pieces = this.nextPieces(width, height)) == null) {
            return null;
        }
        CompositeEntry[] entries = new CompositeEntry[pieces.length];
        int i = 0;
        while (i < entries.length) {
            PrintPiece piece = pieces[i];
            int offset = this.getHorzAlignmentOffset(this.entries[i].alignment, piece.getSize().x, width);
            entries[i] = new CompositeEntry(piece, new Point(offset, 0));
            ++i;
        }
        return new CompositePiece(entries);
    }

    private PrintPiece[] nextPieces(int width, int height) {
        LayerEntryIterator[] entries = (LayerEntryIterator[])this.entries.clone();
        ArrayList<PrintPiece> pieces = new ArrayList<PrintPiece>();
        int i = 0;
        while (i < entries.length) {
            LayerEntryIterator entry = entries[i];
            if (entry.target.hasNext()) {
                PrintPiece piece = PaperClips.next(entry.target, width, height);
                if (piece == null) {
                    Iterator iter = pieces.iterator();
                    while (iter.hasNext()) {
                        ((PrintPiece)iter.next()).dispose();
                    }
                    return null;
                }
                pieces.add(piece);
            }
            ++i;
        }
        this.entries = entries;
        return pieces.toArray(new PrintPiece[pieces.size()]);
    }

    private int getHorzAlignmentOffset(int alignment, int pieceWidth, int totalWidth) {
        int offset = 0;
        switch (alignment) {
            case 0x1000000: {
                offset = (totalWidth - pieceWidth) / 2;
                break;
            }
            case 131072: {
                offset = totalWidth - pieceWidth;
            }
        }
        return offset;
    }

    Point computeSize(PrintSizeStrategy strategy) {
        Point size = new Point(0, 0);
        int i = 0;
        while (i < this.entries.length) {
            LayerEntryIterator entry = this.entries[i];
            Point entrySize = strategy.computeSize(entry.target);
            size.x = Math.max(size.x, entrySize.x);
            size.y = Math.max(size.y, entrySize.y);
            ++i;
        }
        return size;
    }

    public Point minimumSize() {
        return this.computeSize(PrintSizeStrategy.MINIMUM);
    }

    public Point preferredSize() {
        return this.computeSize(PrintSizeStrategy.PREFERRED);
    }

    public PrintIterator copy() {
        return new LayerIterator(this);
    }
}

