/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.LayerEntryIterator;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.PaperClipsUtil;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class LayerEntry {
    final Print target;
    final int align;

    LayerEntry(Print target, int align) {
        Util.notNull(target);
        this.target = target;
        this.align = LayerEntry.checkAlign(align);
    }

    LayerEntry(LayerEntry that) {
        this.target = that.target;
        this.align = that.align;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerEntry other = (LayerEntry)obj;
        if (this.align != other.align) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public Print getTarget() {
        return this.target;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    private static int checkAlign(int align) {
        return PaperClipsUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    LayerEntry copy() {
        return new LayerEntry(this);
    }

    LayerEntryIterator iterator(Device device, GC gc) {
        return new LayerEntryIterator(this, device, gc);
    }
}

