/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.BasicGridLookPainter;
import net.sf.paperclips.BorderPainter;
import net.sf.paperclips.CellBackgroundProvider;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.DefaultGridMargins;
import net.sf.paperclips.GridMargins;
import net.sf.paperclips.internal.ResourcePool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

class DefaultGridLookPainter
extends BasicGridLookPainter {
    private final Rectangle cellPadding;
    private final BorderPainter border;
    private final CellBackgroundProvider headerBackground;
    private final CellBackgroundProvider bodyBackground;
    private final CellBackgroundProvider footerBackground;
    private final GridMargins margins;
    private final ResourcePool resources;

    DefaultGridLookPainter(DefaultGridLook look, Device device, GC gc) {
        super(device);
        Point dpi = device.getDPI();
        this.border = look.cellBorder.createPainter(device, gc);
        this.cellPadding = this.calculateCellPadding(look, dpi);
        this.margins = this.calculateGridMargins(look, dpi);
        this.bodyBackground = look.bodyBackgroundProvider;
        this.headerBackground = look.headerBackgroundProvider;
        this.footerBackground = look.footerBackgroundProvider;
        this.resources = ResourcePool.forDevice(device);
    }

    private Rectangle calculateCellPadding(DefaultGridLook look, Point dpi) {
        Rectangle cellPadding = new Rectangle(look.cellPadding.x * dpi.x / 72, look.cellPadding.y * dpi.y / 72, look.cellPadding.width * dpi.x / 72, look.cellPadding.height * dpi.y / 72);
        return cellPadding;
    }

    private GridMargins calculateGridMargins(DefaultGridLook look, Point dpi) {
        Point cellSpacing = new Point(this.border.getWidth() + (look.cellSpacing.x == -1 ? -this.border.getOverlap().x : dpi.x * look.cellSpacing.x / 72), this.border.getHeight(false, false) + (look.cellSpacing.y == -1 ? -this.border.getOverlap().y : dpi.y * look.cellSpacing.y / 72));
        int headerClosedSpacing = this.border.getHeight(false, false) + (look.headerGap == -1 ? -this.border.getOverlap().y : dpi.y * look.headerGap / 72);
        int headerOpenSpacing = this.border.getHeight(true, false) + (look.headerGap == -1 ? dpi.y / 72 : dpi.y * look.headerGap / 72);
        int footerClosedSpacing = this.border.getHeight(false, false) + (look.footerGap == -1 ? -this.border.getOverlap().y : dpi.y * look.footerGap / 72);
        int footerOpenSpacing = this.border.getHeight(false, true) + (look.footerGap == -1 ? dpi.y / 72 : dpi.y * look.footerGap / 72);
        return new DefaultGridMargins(this.border, cellSpacing, this.cellPadding, headerClosedSpacing, headerOpenSpacing, footerClosedSpacing, footerOpenSpacing);
    }

    public GridMargins getMargins() {
        return this.margins;
    }

    protected void paintHeaderCell(GC gc, Rectangle bounds, int row, int col, int colspan) {
        RGB background = this.headerBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, false, false);
    }

    protected void paintBodyCell(GC gc, Rectangle bounds, int row, int col, int colspan, boolean topOpen, boolean bottomOpen) {
        RGB background = this.bodyBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, topOpen, bottomOpen);
    }

    protected void paintFooterCell(GC gc, Rectangle bounds, int row, int col, int colspan) {
        RGB background = this.footerBackground.getCellBackground(row, col, colspan);
        this.paintCell(gc, background, bounds, false, false);
    }

    private void paintCell(GC gc, RGB background, Rectangle bounds, boolean topOpen, boolean bottomOpen) {
        int x = bounds.x - this.border.getLeft() - this.cellPadding.x;
        int y = bounds.y - this.border.getTop(topOpen) - (topOpen ? 0 : this.cellPadding.y);
        int width = bounds.width + this.border.getWidth() + this.cellPadding.x + this.cellPadding.width;
        int height = bounds.height + this.border.getHeight(topOpen, bottomOpen) + (bottomOpen ? 0 : this.cellPadding.y + this.cellPadding.height);
        Color backgroundColor = this.resources.getColor(background);
        if (backgroundColor != null) {
            Color oldBackground = gc.getBackground();
            gc.setBackground(backgroundColor);
            gc.fillRectangle(x, y, width, height);
            gc.setBackground(oldBackground);
        }
        this.border.paint(gc, x, y, width, height, topOpen, bottomOpen);
    }

    public void dispose() {
        this.border.dispose();
    }
}

