/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInConstantSet;
import org.h2.expression.condition.ConditionNot;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int n, Expression expression, Expression expression2) {
        this.andOrType = n;
        this.left = expression;
        this.right = expression2;
        if (expression == null || expression2 == null) {
            DbException.throwInternalError(expression + " " + expression2);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl);
        switch (this.andOrType) {
            case 0: {
                stringBuilder.append("\n    AND ");
                break;
            }
            case 1: {
                stringBuilder.append("\n    OR ");
                break;
            }
            default: {
                throw DbException.throwInternalError("andOrType=" + this.andOrType);
            }
        }
        return this.right.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, tableFilter);
            this.right.createIndexConditions(session, tableFilter);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        Expression expression;
        Expression expression2 = this.left.getNotIfPossible(session);
        if (expression2 == null) {
            expression2 = new ConditionNot(this.left);
        }
        if ((expression = this.right.getNotIfPossible(session)) == null) {
            expression = new ConditionNot(this.right);
        }
        int n = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(n, expression2, expression);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (value != ValueNull.INSTANCE && !value.getBoolean()) {
                    return value;
                }
                Value value2 = this.right.getValue(session);
                if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
                    return value2;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value2 == ValueNull.INSTANCE) {
                    return value2;
                }
                return ValueBoolean.TRUE;
            }
            case 1: {
                if (value.getBoolean()) {
                    return value;
                }
                Value value3 = this.right.getValue(session);
                if (value3.getBoolean()) {
                    return value3;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value3 == ValueNull.INSTANCE) {
                    return value3;
                }
                return ValueBoolean.FALSE;
            }
        }
        throw DbException.throwInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(Session session) {
        Object object;
        Expression expression;
        Expression expression2;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int n = this.left.getCost();
        int n2 = this.right.getCost();
        if (n2 < n) {
            expression2 = this.left;
            this.left = this.right;
            this.right = expression2;
        }
        if (session.getDatabase().getSettings().optimizeTwoEquals && this.andOrType == 0 && this.left instanceof Comparison && this.right instanceof Comparison && (expression = ((Comparison)(expression2 = (Comparison)this.left)).getAdditional(session, (Comparison)(object = (Comparison)this.right), true)) != null) {
            expression = expression.optimize(session);
            return new ConditionAndOr(0, this, expression);
        }
        if (this.andOrType == 1 && session.getDatabase().getSettings().optimizeOr) {
            if (this.left instanceof Comparison && this.right instanceof Comparison) {
                expression2 = (Comparison)this.left;
                object = (Comparison)this.right;
                expression = ((Comparison)expression2).getAdditional(session, (Comparison)object, false);
                if (expression != null) {
                    return expression.optimize(session);
                }
            } else if (this.left instanceof ConditionIn && this.right instanceof Comparison) {
                expression2 = ((ConditionIn)this.left).getAdditional((Comparison)this.right);
                if (expression2 != null) {
                    return expression2.optimize(session);
                }
            } else if (this.right instanceof ConditionIn && this.left instanceof Comparison) {
                expression2 = ((ConditionIn)this.right).getAdditional((Comparison)this.left);
                if (expression2 != null) {
                    return expression2.optimize(session);
                }
            } else if (this.left instanceof ConditionInConstantSet && this.right instanceof Comparison) {
                expression2 = ((ConditionInConstantSet)this.left).getAdditional(session, (Comparison)this.right);
                if (expression2 != null) {
                    return expression2.optimize(session);
                }
            } else if (this.right instanceof ConditionInConstantSet && this.left instanceof Comparison) {
                expression2 = ((ConditionInConstantSet)this.right).getAdditional(session, (Comparison)this.left);
                if (expression2 != null) {
                    return expression2.optimize(session);
                }
            } else if (this.left instanceof ConditionAndOr && this.right instanceof ConditionAndOr && (expression = ConditionAndOr.optimizeConditionAndOr((ConditionAndOr)(object = (ConditionAndOr)this.left), (ConditionAndOr)(expression2 = (ConditionAndOr)this.right))) != null) {
                return expression.optimize(session);
            }
        }
        expression2 = this.left.isConstant() ? this.left.getValue(session) : null;
        Object object2 = object = this.right.isConstant() ? this.right.getValue(session) : null;
        if (expression2 == null && object == null) {
            return this;
        }
        if (expression2 != null && object != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.andOrType) {
            case 0: {
                if (expression2 != null) {
                    if (expression2 != ValueNull.INSTANCE && !((Value)((Object)expression2)).getBoolean()) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (!((Value)((Object)expression2)).getBoolean()) break;
                    return this.right;
                }
                if (object == null) break;
                if (object != ValueNull.INSTANCE && !((Value)object).getBoolean()) {
                    return ValueExpression.get((Value)object);
                }
                if (!((Value)object).getBoolean()) break;
                return this.left;
            }
            case 1: {
                if (expression2 != null) {
                    if (((Value)((Object)expression2)).getBoolean()) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (expression2 == ValueNull.INSTANCE) break;
                    return this.right;
                }
                if (object == null) break;
                if (((Value)object).getBoolean()) {
                    return ValueExpression.get((Value)object);
                }
                if (object == ValueNull.INSTANCE) break;
                return this.left;
            }
            default: {
                DbException.throwInternalError("type=" + this.andOrType);
            }
        }
        return this;
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(tableFilter, bl);
            this.right.addFilterConditions(tableFilter, bl);
        } else {
            super.addFilterConditions(tableFilter, bl);
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static Expression optimizeConditionAndOr(ConditionAndOr conditionAndOr, ConditionAndOr conditionAndOr2) {
        String string;
        if (conditionAndOr.andOrType != 0 || conditionAndOr2.andOrType != 0) {
            return null;
        }
        Expression expression = conditionAndOr.getSubexpression(0);
        Expression expression2 = conditionAndOr.getSubexpression(1);
        Expression expression3 = conditionAndOr2.getSubexpression(0);
        Expression expression4 = conditionAndOr2.getSubexpression(1);
        String string2 = expression.getSQL(true);
        if (string2.equals(string = expression3.getSQL(true))) {
            ConditionAndOr conditionAndOr3 = new ConditionAndOr(1, expression2, expression4);
            return new ConditionAndOr(0, expression, conditionAndOr3);
        }
        String string3 = expression4.getSQL(true);
        if (string2.equals(string3)) {
            ConditionAndOr conditionAndOr4 = new ConditionAndOr(1, expression2, expression3);
            return new ConditionAndOr(0, expression, conditionAndOr4);
        }
        String string4 = expression2.getSQL(true);
        if (string4.equals(string)) {
            ConditionAndOr conditionAndOr5 = new ConditionAndOr(1, expression, expression4);
            return new ConditionAndOr(0, expression2, conditionAndOr5);
        }
        if (string4.equals(string3)) {
            ConditionAndOr conditionAndOr6 = new ConditionAndOr(1, expression, expression3);
            return new ConditionAndOr(0, expression2, conditionAndOr6);
        }
        return null;
    }
}

