/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.io.IOUtil;
import de.willuhn.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Settings {
    private static final long RELOAD_INTERVAL = 1000L;
    private File file = null;
    private long lastModified = 0L;
    private long lastReload = 0L;
    private Properties properties = null;
    private boolean storeWhenRead = false;

    public Settings(String path, Class clazz) {
        this(null, path, clazz);
    }

    public Settings(String systemPath, String userPath, Class clazz) {
        this(systemPath != null ? new File(systemPath + File.separator + clazz.getName() + ".properties") : null, new File(userPath + File.separator + clazz.getName() + ".properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings(File systemFile, File userFile) {
        this.file = userFile;
        this.properties = new Properties();
        if (systemFile != null && systemFile.exists() && systemFile.canRead()) {
            BufferedInputStream is = null;
            try {
                Logger.debug("loading system presets from " + systemFile.getAbsolutePath());
                Properties presets = new Properties();
                is = new BufferedInputStream(new FileInputStream(systemFile));
                presets.load(is);
                this.properties.putAll((Map<?, ?>)presets);
            }
            catch (Exception e1) {
                try {
                    Logger.error("unable to load system presets from " + systemFile.getAbsolutePath(), e1);
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    throw throwable;
                }
                IOUtil.close(is);
            }
            IOUtil.close(is);
        }
        if (this.file != null && this.file.exists()) {
            this.reload();
        }
    }

    public void setStoreWhenRead(boolean b) {
        this.storeWhenRead = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributes() {
        this.reload();
        Properties properties = this.properties;
        synchronized (properties) {
            Iterator<Object> it = this.properties.keySet().iterator();
            String[] attributes = new String[this.properties.size()];
            int i = 0;
            while (it.hasNext()) {
                attributes[i++] = (String)it.next();
            }
            return attributes;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        this.reload();
        String def = Boolean.toString(defaultValue);
        String s = this.properties.getProperty(name, def);
        if (s != null) {
            s = s.trim();
        }
        boolean b = "true".equalsIgnoreCase(s);
        this.storeConditional(name, Boolean.toString(b));
        return b;
    }

    public int getInt(String name, int defaultValue) {
        this.reload();
        String def = Integer.toString(defaultValue);
        String s = this.properties.getProperty(name, def);
        if (s != null) {
            s = s.trim();
        }
        int i = defaultValue;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse value of param \"" + name + "\", value: " + s, e);
        }
        this.storeConditional(name, Integer.toString(i));
        return i;
    }

    public long getLong(String name, long defaultValue) {
        this.reload();
        String def = Long.toString(defaultValue);
        String s = this.properties.getProperty(name, def);
        if (s != null) {
            s = s.trim();
        }
        long l = defaultValue;
        try {
            l = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse value of param \"" + name + "\", value: " + s, e);
        }
        this.storeConditional(name, Long.toString(l));
        return l;
    }

    public double getDouble(String name, double defaultValue) {
        this.reload();
        String def = "" + defaultValue;
        String s = this.properties.getProperty(name, def);
        if (s != null) {
            s = s.trim();
        }
        double d = defaultValue;
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse value of param \"" + name + "\", value: " + s, e);
        }
        this.storeConditional(name, "" + d);
        return d;
    }

    public String getString(String name, String defaultValue) {
        this.reload();
        String s = this.properties.getProperty(name, defaultValue);
        this.storeConditional(name, s);
        return s;
    }

    public String[] getList(String name, String[] defaultValues) {
        this.reload();
        String[] result = this.getList(name);
        if (result.length == 0) {
            this.storeConditional(name, defaultValues);
            return defaultValues;
        }
        this.storeConditional(name, result);
        return result;
    }

    private String[] getList(String name) {
        ArrayList<String> l = new ArrayList<String>();
        String s = null;
        for (int i = 0; i < 255; ++i) {
            s = this.properties.getProperty(name + "." + i, null);
            if (s == null) continue;
            l.add(s);
        }
        return l.toArray(new String[l.size()]);
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, Boolean.toString(value));
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    public void setAttribute(String name, double value) {
        this.setAttribute(name, "" + value);
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, Long.toString(value));
    }

    public void setAttribute(String name, String value) {
        if (value == null) {
            String prev = (String)this.properties.remove(name);
            if (prev != null) {
                this.store();
            }
        } else {
            String prev = (String)this.properties.setProperty(name, value);
            if (prev == null || !value.equals(prev)) {
                this.store();
            }
        }
    }

    public void setAttribute(String name, String[] values) {
        int i;
        for (i = 0; i < 255; ++i) {
            this.properties.remove(name + "." + i);
        }
        if (values == null || values.length == 0) {
            this.store();
            return;
        }
        for (i = 0; i < values.length && i < 255; ++i) {
            if (values[i] == null) continue;
            this.properties.setProperty(name + "." + i, values[i]);
        }
        this.store();
    }

    private void storeConditional(String name, String value) {
        if (!this.storeWhenRead) {
            return;
        }
        String old = this.properties.getProperty(name);
        if (value == null ? old == null : value.equals(old)) {
            return;
        }
        this.setAttribute(name, value);
    }

    private void storeConditional(String name, String[] values) {
        if (!this.storeWhenRead) {
            return;
        }
        Object[] old = this.getList(name);
        if (Arrays.equals(values, old)) {
            return;
        }
        this.setAttribute(name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void store() {
        if (this.file == null || !this.file.exists() && this.properties.size() == 0) {
            return;
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(this.file));
            Logger.debug("saving " + this.file.getAbsolutePath());
            this.properties.store(os, null);
        }
        catch (Exception e1) {
            Logger.error("unable to store settings. Do you have write permissions in " + this.file.getAbsolutePath() + " ?", e1);
        }
        finally {
            this.lastModified = this.file.lastModified();
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    Logger.error("unable to close settings file: " + this.file.getAbsolutePath(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void reload() {
        if (this.file == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastReload < 1000L) {
            return;
        }
        this.lastReload = now;
        long modified = this.file.lastModified();
        if (this.lastModified == modified) {
            return;
        }
        BufferedInputStream is = null;
        try {
            if (this.lastModified > 0L) {
                Logger.debug(this.file.getAbsolutePath() + " has changed, reloading");
            }
            is = new BufferedInputStream(new FileInputStream(this.file));
            this.properties.load(is);
            this.lastModified = modified;
        }
        catch (FileNotFoundException nfe) {
            Logger.warn("file " + this.file.getAbsolutePath() + " has been deleted");
            this.properties.clear();
            this.lastModified = modified;
            IOUtil.close(is);
        }
        catch (Exception e1) {
            Logger.error("unable to (re)load settings. Do you have read permissions in " + this.file.getAbsolutePath() + " ?", e1);
            this.lastModified = modified;
            {
                catch (Throwable throwable) {
                    this.lastModified = modified;
                    IOUtil.close(is);
                    throw throwable;
                }
            }
            IOUtil.close(is);
        }
        IOUtil.close(is);
    }
}

