/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class Queue {
    private int capacity = 10;
    private Vector v = null;
    public static int CAPACITY_MIN = 2;
    public static int CAPACITY_MAX = 1000;

    public Queue(int capacity) {
        if (capacity >= CAPACITY_MIN && capacity <= CAPACITY_MAX) {
            this.capacity = capacity;
        }
        this.v = new Vector(this.capacity);
    }

    public synchronized Object pop() {
        Object o = this.v.get(0);
        this.v.removeElementAt(0);
        return o;
    }

    public int size() {
        return this.v.size();
    }

    public synchronized List elements() {
        return Arrays.asList(this.v.toArray());
    }

    public Object[] toArray(Object[] type) {
        return this.v.toArray(type);
    }

    public boolean full() {
        return this.v.size() >= this.capacity;
    }

    public synchronized void push(Object o) throws QueueFullException {
        if (this.full()) {
            throw new QueueFullException("maximum queue size reached");
        }
        this.v.addElement(o);
    }

    public static class QueueFullException
    extends Exception {
        public QueueFullException(String message) {
            super(message);
        }
    }
}

