/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class Platform {
    public static File getDir(Class c) throws IOException {
        try {
            URL url = c.getProtectionDomain().getCodeSource().getLocation();
            File f = new File(url.toURI());
            if (f.isFile()) {
                return f.getParentFile();
            }
            return f;
        }
        catch (URISyntaxException e) {
            throw new IOException("unable to determine dir for class " + c + ": " + e.getMessage());
        }
    }

    public static OS getPlatform() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        if (os.toLowerCase().indexOf("linux") != -1) {
            return arch.toLowerCase().indexOf("64") != -1 ? OS.LINUX64 : OS.LINUX32;
        }
        if (os.toLowerCase().indexOf("windows") != -1) {
            return arch.toLowerCase().indexOf("64") != -1 ? OS.WIN64 : OS.WIN32;
        }
        if (os.toLowerCase().indexOf("mac") != -1) {
            return arch.toLowerCase().indexOf("64") != -1 ? OS.MACOS64 : OS.MACOS32;
        }
        if (os.toLowerCase().indexOf("freebsd") != -1) {
            return arch.toLowerCase().indexOf("64") != -1 ? OS.FREEBSD64 : OS.FREEBSD32;
        }
        return OS.UNKNOWN;
    }

    public static enum OS {
        WIN32,
        WIN64,
        LINUX32,
        LINUX64,
        MACOS32,
        MACOS64,
        FREEBSD32,
        FREEBSD64,
        UNKNOWN;

    }
}

