/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class I18N {
    private ResourceBundle bundle;
    private Properties fallbackBundle;
    private Properties unresolved = new Properties();
    private Locale locale;
    private static final String DEFAULTPATH = "lang/messages";

    public I18N() {
        this(null, null, null);
    }

    public I18N(Locale l) {
        this(null, l, null);
    }

    public I18N(String resourcePath) {
        this(resourcePath, null, null);
    }

    public I18N(String resourcePath, Locale l) {
        this(resourcePath, l, null);
    }

    public I18N(String resourcePath, Locale l, ClassLoader loader) {
        if (resourcePath == null) {
            resourcePath = DEFAULTPATH;
        }
        this.locale = l == null ? Locale.getDefault() : l;
        Logger.info("loading resource bundle " + resourcePath + " for locale " + (l == null ? "<default>" : l.toString()));
        if (l == null || resourcePath == null) {
            return;
        }
        this.bundle = loader != null ? ResourceBundle.getBundle(resourcePath, l, loader) : ResourceBundle.getBundle(resourcePath, l);
    }

    public I18N(InputStream is) {
        this.fallbackBundle = new Properties();
        if (is == null) {
            Logger.error("no inputstream given for I18N");
        }
        try {
            this.fallbackBundle.load(is);
        }
        catch (IOException e) {
            Logger.error("error while reading resource bundle from inputstream", e);
        }
    }

    public String tr(String key) {
        String translated = null;
        try {
            if (this.bundle != null) {
                translated = this.bundle.getString(key);
            } else if (this.fallbackBundle != null) {
                translated = this.fallbackBundle.getProperty(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (translated != null) {
            return translated;
        }
        this.unresolved.put(key, key);
        return key;
    }

    public String tr(String key, String ... replacements) {
        return MessageFormat.format(this.tr(key), replacements);
    }

    public String tr(String key, String replacement) {
        return this.tr(key, new String[]{replacement});
    }

    public void storeUntranslated(OutputStream os) throws IOException {
        Logger.info("saving unresolved locale strings");
        this.unresolved.store(os, "unresolved strings for locale " + this.locale.toString());
    }
}

