/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.logging.Logger;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class ClassFinder {
    private Hashtable cache = new Hashtable();
    private ArrayList classes = new ArrayList();
    private ArrayList children = new ArrayList();

    ClassFinder() {
    }

    void addFinder(ClassFinder finder) {
        this.children.add(finder);
    }

    void addClass(Class clazz) {
        if (this.isImpl(clazz)) {
            this.classes.add(clazz);
        }
    }

    public Class[] findImplementors(Class interphase) throws ClassNotFoundException {
        Class[] found = (Class[])this.cache.get(interphase);
        if (found != null && found.length > 0) {
            return found;
        }
        if (this.isImpl(interphase)) {
            return new Class[]{interphase};
        }
        long start = System.currentTimeMillis();
        ArrayList<Class> ranking = new ArrayList<Class>();
        for (int i = 0; i < this.children.size(); ++i) {
            ClassFinder child = (ClassFinder)this.children.get(i);
            try {
                found = child.findImplementors(interphase);
                if (found == null || found.length <= 0) continue;
                ranking.addAll(Arrays.asList(found));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Class test = null;
        Hashtable<Class, Class> duplicates = new Hashtable<Class, Class>();
        for (int i = 0; i < this.classes.size(); ++i) {
            test = (Class)this.classes.get(i);
            if (duplicates.get(test) != null || !interphase.isAssignableFrom(test)) continue;
            ranking.add(test);
            duplicates.put(test, test);
        }
        if (ranking.size() == 0) {
            Logger.debug("...no implementor found for " + interphase.getName());
            throw new ClassNotFoundException("no implementor found for " + interphase.getName());
        }
        Class[] classes = ranking.toArray(new Class[ranking.size()]);
        this.cache.put(interphase, classes);
        Logger.debug("used time to search for implementors of " + interphase.getName() + ": " + (System.currentTimeMillis() - start) + " millis]");
        return classes;
    }

    private boolean isImpl(Class clazz) {
        if (clazz.isInterface() || clazz.isPrimitive()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        String s = clazz.getName();
        return s.indexOf("$") == -1 && !s.endsWith("_Stub") && !s.endsWith("_Skel");
    }
}

