/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.logging.Logger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Base64 {
    private static Encoder encoder = null;

    public static final byte[] decode(String base64) throws IOException {
        if (encoder == null) {
            throw new IOException("base64 decoder not available");
        }
        return encoder.decode(base64);
    }

    public static final String encode(byte[] text) {
        if (encoder == null) {
            return null;
        }
        return encoder.encode(text);
    }

    static {
        for (Encoder e : Arrays.asList(new JavaEncoder(), new SunEncoder())) {
            if (!e.exists()) continue;
            encoder = e;
            Logger.info("using base64 encoder/decoder: " + encoder.getClass().getSimpleName());
            break;
        }
        if (encoder == null) {
            Logger.warn("no base64 encoder/decoder found");
        }
    }

    private static class JavaEncoder
    implements Encoder {
        private static final String BASE64 = "java.util.Base64";
        private Object decoder = JavaEncoder.load("java.util.Base64", "getMimeDecoder");
        private Object encoder = JavaEncoder.load("java.util.Base64", "getMimeEncoder");
        private Method decode = null;
        private Method encode = null;

        private JavaEncoder() {
        }

        private static Object load(String className, String method) {
            try {
                Class<?> base64 = Class.forName(className);
                Method m = base64.getMethod(method, new Class[0]);
                return m.invoke(base64, new Object[0]);
            }
            catch (Throwable t) {
                Logger.debug("base64 encoder/decoder " + className + " not available on this java version");
                return null;
            }
        }

        @Override
        public boolean exists() {
            return this.decoder != null && this.encoder != null;
        }

        @Override
        public byte[] decode(String base64) throws IOException {
            if (this.decoder == null) {
                throw new IOException("base64 decoder not available");
            }
            try {
                if (this.decode == null) {
                    this.decode = this.decoder.getClass().getMethod("decode", String.class);
                }
                return (byte[])this.decode.invoke(this.decoder, base64);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
        }

        @Override
        public String encode(byte[] text) {
            if (this.encoder == null) {
                Logger.warn("base64 encoder not available");
                return null;
            }
            try {
                if (this.encode == null) {
                    this.encode = this.encoder.getClass().getMethod("encodeToString", byte[].class);
                }
                return (String)this.encode.invoke(this.encoder, new Object[]{text});
            }
            catch (Throwable t) {
                Logger.error("unable to encode base64", t);
                return null;
            }
        }
    }

    private static class SunEncoder
    implements Encoder {
        private static final String DECODER = "sun.misc.BASE64Decoder";
        private static final String ENCODER = "sun.misc.BASE64Encoder";
        private Object decoder = SunEncoder.load("sun.misc.BASE64Decoder");
        private Object encoder = SunEncoder.load("sun.misc.BASE64Encoder");
        private Method decode = null;
        private Method encode = null;

        private SunEncoder() {
        }

        private static Object load(String className) {
            try {
                return Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                Logger.debug("base64 encoder/decoder " + className + " not available on this java version");
                return null;
            }
        }

        @Override
        public boolean exists() {
            return this.decoder != null && this.encoder != null;
        }

        @Override
        public byte[] decode(String base64) throws IOException {
            if (this.decoder == null) {
                throw new IOException("base64 decoder not available");
            }
            try {
                if (this.decode == null) {
                    this.decode = this.decoder.getClass().getMethod("decodeBuffer", String.class);
                }
                return (byte[])this.decode.invoke(this.decoder, base64);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
        }

        @Override
        public String encode(byte[] text) {
            if (this.encoder == null) {
                Logger.warn("base64 encoder not available");
                return null;
            }
            try {
                if (this.encode == null) {
                    this.encode = this.encoder.getClass().getMethod("encode", byte[].class);
                }
                return (String)this.encode.invoke(this.encoder, new Object[]{text});
            }
            catch (Throwable t) {
                Logger.error("unable to encode base64", t);
                return null;
            }
        }
    }

    private static interface Encoder {
        public boolean exists();

        public byte[] decode(String var1) throws IOException;

        public String encode(byte[] var1);
    }
}

